/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.client.render.pressure_gauge.PressureGaugeRenderer2D;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class JEIPressureChamberRecipeCategory
implements IRecipeCategory<PressureChamberRecipe> {
    private final String localizedName;
    private final IDrawable background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_PRESSURE_CHAMBER, 5, 11, 166, 116);
    private final IDrawable icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.PRESSURE_CHAMBER_WALL.get()));
    private final ITickTimer tickTimer;

    JEIPressureChamberRecipeCategory() {
        this.localizedName = I18n.func_135052_a((String)"pneumaticcraft.gui.pressureChamber", (Object[])new Object[0]);
        this.tickTimer = JEIPlugin.jeiHelpers.getGuiHelper().createTickTimer(60, 60, false);
    }

    public ResourceLocation getUid() {
        return ModCategoryUid.PRESSURE_CHAMBER;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    protected static Optional<PressureChamberRecipe.SlotCycle> getMatchingCycle(IIngredients ingredients, IFocus<ItemStack> focus) {
        List slots;
        if (focus == null) {
            return Optional.empty();
        }
        IFocus.Mode mode = focus.getMode();
        if (mode == IFocus.Mode.INPUT) {
            slots = ingredients.getInputs(VanillaTypes.ITEM);
        } else if (mode == IFocus.Mode.OUTPUT) {
            slots = ingredients.getOutputs(VanillaTypes.ITEM);
        } else {
            return Optional.empty();
        }
        ItemStack needle = (ItemStack)focus.getValue();
        for (int slot = 0; slot < slots.size(); ++slot) {
            List stacks = (List)slots.get(slot);
            if (stacks.size() <= 1) continue;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (int i = 0; i < stacks.size(); ++i) {
                if (!needle.func_77969_a((ItemStack)stacks.get(i))) continue;
                builder.add((Object)i);
            }
            ImmutableList matches = builder.build();
            if (matches.size() <= 0) continue;
            return Optional.of(new PressureChamberRecipe.SlotCycle(new PressureChamberRecipe.RecipeSlot(mode == IFocus.Mode.INPUT, slot), (ImmutableList<Integer>)matches));
        }
        return Optional.empty();
    }

    protected static List<List<ItemStack>> applyOverrides(boolean isInput, List<List<ItemStack>> slotCycles, Map<PressureChamberRecipe.RecipeSlot, List<Integer>> slotCycleOverrides) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < slotCycles.size(); ++i) {
            List<ItemStack> stacks = slotCycles.get(i);
            List<Integer> cycleOverrides = slotCycleOverrides.get(new PressureChamberRecipe.RecipeSlot(isInput, i));
            if (cycleOverrides != null) {
                builder.add(cycleOverrides.stream().map(stacks::get).filter(Objects::nonNull).collect(ImmutableList.toImmutableList()));
                continue;
            }
            builder.add(stacks);
        }
        return builder.build();
    }

    public void setIngredients(PressureChamberRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputsForDisplay());
        ingredients.setOutputLists(VanillaTypes.ITEM, recipe.getResultsForDisplay());
    }

    public void setRecipe(IRecipeLayout recipeLayout, PressureChamberRecipe recipe, IIngredients ingredients) {
        Map overrides = JEIPressureChamberRecipeCategory.getMatchingCycle(ingredients, (IFocus<ItemStack>)recipeLayout.getFocus(VanillaTypes.ITEM)).map(recipe::getSyncForDisplay).orElseGet(ImmutableMap::of);
        List<List<ItemStack>> inputs = JEIPressureChamberRecipeCategory.applyOverrides(true, ingredients.getInputs(VanillaTypes.ITEM), overrides);
        for (int i = 0; i < inputs.size(); ++i) {
            int posX = 18 + i % 3 * 17;
            int posY = 78 - i / 3 * 17;
            recipeLayout.getItemStacks().init(i, true, posX, posY);
            recipeLayout.getItemStacks().set(i, inputs.get(i));
        }
        List<List<ItemStack>> outputs = JEIPressureChamberRecipeCategory.applyOverrides(false, ingredients.getOutputs(VanillaTypes.ITEM), overrides);
        for (int i = 0; i < outputs.size(); ++i) {
            recipeLayout.getItemStacks().init(inputs.size() + i, false, 100 + i % 3 * 18, 58 + i / 3 * 18);
            recipeLayout.getItemStacks().set(inputs.size() + i, outputs.get(i));
        }
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            String tooltipKey = recipe.getTooltipKey(input, slotIndex);
            if (!tooltipKey.isEmpty()) {
                tooltip.addAll(PneumaticCraftUtils.splitStringComponent(I18n.func_135052_a((String)tooltipKey, (Object[])new Object[0])));
            }
        });
    }

    public void draw(PressureChamberRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        float pressure = recipe.getCraftingPressure() * ((float)this.tickTimer.getValue() / (float)this.tickTimer.getMaxValue());
        PressureGaugeRenderer2D.drawPressureGauge(matrixStack, Minecraft.func_71410_x().field_71466_p, -1.0f, 7.0f, 5.0f, recipe.getCraftingPressure(), pressure, 130, 27);
    }

    public Class<? extends PressureChamberRecipe> getRecipeClass() {
        return PressureChamberRecipe.class;
    }

    public List<ITextComponent> getTooltipStrings(PressureChamberRecipe recipe, double mouseX, double mouseY) {
        if (mouseX >= 100.0 && mouseY >= 7.0 && mouseX <= 140.0 && mouseY <= 47.0) {
            return ImmutableList.of((Object)PneumaticCraftUtils.xlate("pneumaticcraft.gui.tooltip.pressure", Float.valueOf(recipe.getCraftingPressure())));
        }
        return Collections.emptyList();
    }
}

