/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.jei;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.ItemSpawnerCore;
import me.desht.pneumaticcraft.common.thirdparty.jei.JEIPlugin;
import me.desht.pneumaticcraft.common.thirdparty.jei.ModCategoryUid;
import me.desht.pneumaticcraft.lib.Textures;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class JEISpawnerExtractionCategory
implements IRecipeCategory<Recipe> {
    private final String localizedName = I18n.func_135052_a((String)"pneumaticcraft.gui.jei.title.spawnerExtraction", (Object[])new Object[0]);
    private final IDrawable background = JEIPlugin.jeiHelpers.getGuiHelper().createDrawable(Textures.GUI_JEI_SPAWNER_EXTRACTION, 0, 0, 120, 64);
    private final IDrawable icon = JEIPlugin.jeiHelpers.getGuiHelper().createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.SPAWNER_EXTRACTOR.get()));
    private static final List<EntityType<?>> ENTITY_TYPES = new ArrayList();

    public ResourceLocation getUid() {
        return ModCategoryUid.SPAWNER_EXTRACTION;
    }

    public Class<? extends Recipe> getRecipeClass() {
        return Recipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(Recipe recipe, IIngredients iIngredients) {
        iIngredients.setInputs(VanillaTypes.ITEM, (List)ImmutableList.of((Object)recipe.itemInput, (Object)new ItemStack((IItemProvider)Blocks.field_150474_ac)));
        iIngredients.setOutputLists(VanillaTypes.ITEM, (List)ImmutableList.of(recipe.cores, Collections.singletonList(recipe.itemOutput2)));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, Recipe recipe, IIngredients iIngredients) {
        iRecipeLayout.getItemStacks().init(0, true, 52, 2);
        iRecipeLayout.getItemStacks().set(0, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(0));
        iRecipeLayout.getItemStacks().init(1, true, 52, 33);
        iRecipeLayout.getItemStacks().set(1, (List)iIngredients.getInputs(VanillaTypes.ITEM).get(1));
        iRecipeLayout.getItemStacks().init(2, false, 17, 33);
        iRecipeLayout.getItemStacks().set(2, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(0));
        iRecipeLayout.getItemStacks().init(3, false, 87, 33);
        iRecipeLayout.getItemStacks().set(3, (List)iIngredients.getOutputs(VanillaTypes.ITEM).get(1));
    }

    public static Collection<?> getAllRecipes() {
        ArrayList<ItemStack> cores = new ArrayList<ItemStack>();
        for (EntityType<?> type : ENTITY_TYPES) {
            ItemStack core = new ItemStack((IItemProvider)ModItems.SPAWNER_CORE.get());
            ItemSpawnerCore.SpawnerCoreStats stats = ItemSpawnerCore.SpawnerCoreStats.forItemStack(core);
            if (stats == null) continue;
            stats.addAmount(type, 100);
            stats.serialize(core);
            cores.add(core);
        }
        return Collections.singletonList(new Recipe(new ItemStack((IItemProvider)ModBlocks.SPAWNER_EXTRACTOR.get()), cores, new ItemStack((IItemProvider)ModBlocks.EMPTY_SPAWNER.get())));
    }

    static {
        ENTITY_TYPES.add(EntityType.field_200725_aD);
        ENTITY_TYPES.add(EntityType.field_200741_ag);
        ENTITY_TYPES.add(EntityType.field_200797_k);
    }

    static class Recipe {
        final ItemStack itemInput;
        final List<ItemStack> cores;
        final ItemStack itemOutput2;

        Recipe(ItemStack itemInput, List<ItemStack> cores, ItemStack itemOutput2) {
            this.itemInput = itemInput;
            this.cores = cores;
            this.itemOutput2 = itemOutput2;
        }
    }
}

