/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import me.desht.pneumaticcraft.client.gui.widget.WidgetTank;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import vazkii.patchouli.api.IComponentRenderContext;
import vazkii.patchouli.api.ICustomComponent;
import vazkii.patchouli.api.IVariable;

public class ComponentFluid
implements ICustomComponent {
    private transient List<FluidStack> fluidStacks;
    private transient WidgetTank tankWidget;
    private transient int scaleParsed = 16000;
    public IVariable fluid;
    public IVariable scale;

    public void build(int componentX, int componentY, int pageNum) {
        this.tankWidget = new WidgetTank(componentX, componentY, 16, 64, this.fluidStacks.isEmpty() ? FluidStack.EMPTY : this.fluidStacks.get(0));
        this.tankWidget.getTank().setCapacity(this.scaleParsed);
    }

    public void render(MatrixStack matrixStack, IComponentRenderContext ctx, float pticks, int mouseX, int mouseY) {
        if (!this.fluidStacks.isEmpty()) {
            this.tankWidget.getTank().setFluid(this.fluidStacks.get(ctx.getTicksInBook() / 20 % this.fluidStacks.size()));
        }
        if (this.tankWidget.getTank().getCapacity() > 0 && !this.tankWidget.getTank().getFluid().isEmpty()) {
            this.tankWidget.func_230431_b_(matrixStack, mouseX, mouseY, pticks);
            if (ctx.isAreaHovered(mouseX, mouseY, this.tankWidget.field_230690_l_, this.tankWidget.field_230691_m_, this.tankWidget.func_230998_h_(), this.tankWidget.func_238483_d_())) {
                ArrayList<ITextComponent> tooltip = new ArrayList<ITextComponent>();
                this.tankWidget.addTooltip(mouseX, mouseY, tooltip, Screen.func_231173_s_());
                ctx.setHoverTooltipComponents(tooltip);
            }
        }
    }

    public void onVariablesAvailable(UnaryOperator<IVariable> lookup) {
        this.fluidStacks = ((IVariable)lookup.apply(this.fluid)).asStreamOrSingleton().map(x -> (FluidStack)x.as(FluidStack.class)).collect(Collectors.toList());
        this.scaleParsed = Integer.parseInt(((IVariable)lookup.apply(this.scale)).asString());
    }
}

