/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.patchouli;

import com.google.common.collect.ImmutableList;
import java.util.List;
import me.desht.pneumaticcraft.api.crafting.recipe.PressureChamberRecipe;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.thirdparty.patchouli.Patchouli;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorPressureChamber
implements IComponentProcessor {
    private PressureChamberRecipe recipe = null;
    private String header = null;

    public void setup(IVariableProvider iVariableProvider) {
        ResourceLocation recipeId = new ResourceLocation(iVariableProvider.get("recipe").asString());
        this.recipe = PneumaticCraftRecipeType.PRESSURE_CHAMBER.getRecipe((World)Minecraft.func_71410_x().field_71441_e, recipeId);
        this.header = iVariableProvider.has("header") ? iVariableProvider.get("header").asString() : "";
    }

    public IVariable process(String s) {
        if (this.recipe == null) {
            return null;
        }
        if (s.equals("header")) {
            return IVariable.wrap((String)(this.header.isEmpty() ? this.defaultHeader() : this.header));
        }
        if (s.startsWith("input")) {
            int index = Integer.parseInt(s.substring(5)) - 1;
            if (index >= 0 && index < this.recipe.getInputsForDisplay().size()) {
                return Patchouli.Util.getStacks(this.recipe.getInputsForDisplay().get(index));
            }
        } else if (s.startsWith("output")) {
            int index = Integer.parseInt(s.substring(6)) - 1;
            List<List<ItemStack>> results = this.recipe.getResultsForDisplay();
            if (index >= 0 && index < results.size()) {
                return IVariable.wrapList((Iterable)((Iterable)results.get(index).stream().map(IVariable::from).collect(ImmutableList.toImmutableList())));
            }
        } else if (s.equals("pressure")) {
            String pr = PneumaticCraftUtils.roundNumberTo(this.recipe.getCraftingPressure(), 1);
            return IVariable.wrap((String)I18n.func_135052_a((String)"pneumaticcraft.patchouli.processor.pressureChamber.desc", (Object[])new Object[]{pr}));
        }
        return null;
    }

    private String defaultHeader() {
        List<ItemStack> stacks;
        List<List<ItemStack>> results = this.recipe.getResultsForDisplay();
        if (!results.isEmpty() && !(stacks = results.get(0)).isEmpty()) {
            return stacks.get(0).func_200301_q().getString();
        }
        return "";
    }
}

