/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.waila;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerDataProvider;
import me.desht.pneumaticcraft.api.semiblock.IDirectionalSemiblock;
import me.desht.pneumaticcraft.api.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.entity.semiblock.EntitySemiblockBase;
import me.desht.pneumaticcraft.common.semiblock.SemiblockTracker;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class SemiblockProvider {

    public static class Component
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            CompoundNBT tag = accessor.getServerData().func_74775_l("semiBlocks");
            for (String name : tag.func_150296_c()) {
                try {
                    int entityId = Integer.parseInt(name);
                    ISemiBlock entity = ISemiBlock.byTrackingId(accessor.getWorld(), entityId);
                    if (!(entity instanceof EntitySemiblockBase) || entity instanceof IDirectionalSemiblock && ((IDirectionalSemiblock)((Object)entity)).getSide() != accessor.getSide()) continue;
                    IFormattableTextComponent title = new StringTextComponent(TextFormatting.YELLOW.toString() + "[").func_230529_a_(entity.getDisplayName()).func_240702_b_("]");
                    tooltip.add((ITextComponent)title);
                    entity.addTooltip(tooltip, accessor.getPlayer(), tag.func_74775_l(name), accessor.getPlayer().func_225608_bj_());
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public static class Data
    implements IServerDataProvider<TileEntity> {
        public void appendServerData(CompoundNBT compoundNBT, ServerPlayerEntity serverPlayerEntity, World world, TileEntity tileEntity) {
            CompoundNBT tag = new CompoundNBT();
            SemiblockTracker.getInstance().getAllSemiblocks(world, tileEntity.func_174877_v()).forEach(semiBlock -> {
                NonNullList<ItemStack> drops = semiBlock.getDrops();
                if (!drops.isEmpty()) {
                    tag.func_218657_a(Integer.toString(semiBlock.getTrackingId()), (INBT)semiBlock.serializeNBT(new CompoundNBT()));
                }
            });
            compoundNBT.func_218657_a("semiBlocks", (INBT)tag);
        }
    }
}

