/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

@FunctionalInterface
public interface IHeatExchangingTE {
    @Nullable
    public IHeatExchangerLogic getHeatExchanger(Direction var1);

    default public IHeatExchangerLogic getHeatExchanger() {
        return this.getHeatExchanger(null);
    }

    default public BiPredicate<IWorld, BlockPos> heatExchangerBlockFilter() {
        return IHeatExchangerLogic.ALL_BLOCKS;
    }

    default public void initHeatExchangersOnPlacement(World world, BlockPos pos) {
        IHeatExchangerLogic logic = this.getHeatExchanger();
        if (logic != null) {
            logic.setTemperature(HeatExchangerLogicAmbient.getAmbientTemperature((IWorld)world, pos));
        }
    }

    default public void initializeHullHeatExchangers(World world, BlockPos pos) {
        IdentityHashMap<IHeatExchangerLogic, List> map = new IdentityHashMap<IHeatExchangerLogic, List>();
        for (Direction side : DirectionUtil.VALUES) {
            IHeatExchangerLogic logic2 = this.getHeatExchanger(side);
            if (logic2 == null) continue;
            map.computeIfAbsent(logic2, k -> new ArrayList()).add(side);
        }
        map.forEach((logic, sides) -> logic.initializeAsHull(world, pos, this.heatExchangerBlockFilter(), sides.toArray(new Direction[0])));
    }
}

