/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import net.minecraft.fluid.Fluid;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class SmartSyncTank
extends FluidTank {
    @DescSynced
    private FluidStack syncedFluidStackDesc = FluidStack.EMPTY;
    @GuiSynced
    private FluidStack syncedFluidStackGui = FluidStack.EMPTY;
    private boolean pending = false;
    private int syncTimer = 0;
    private final WeakReference<TileEntity> owner;
    private final int threshold;

    SmartSyncTank(TileEntity owner, int capacity) {
        super(capacity);
        this.owner = new WeakReference<TileEntity>(owner);
        this.threshold = Math.min(1000, capacity / 100);
    }

    public void tick() {
        TileEntity te = (TileEntity)this.owner.get();
        if (te != null) {
            if (te.func_145831_w().field_72995_K) {
                if (ClientUtils.isGuiOpen(te)) {
                    super.setFluid(this.syncedFluidStackGui);
                } else {
                    int currAmount = this.getFluidAmount();
                    FluidStack tgt = this.syncedFluidStackDesc;
                    int delta = tgt.getAmount() - currAmount;
                    if (delta != 0) {
                        int newAmount = Math.abs(delta) < this.capacity / 200 ? tgt.getAmount() : currAmount + delta / 20;
                        Fluid newFluid = this.fluid.isEmpty() ? tgt.getFluid() : this.fluid.getFluid();
                        super.setFluid(new FluidStack(newFluid.getFluid(), newAmount));
                    }
                }
            } else if (this.syncTimer > 0) {
                --this.syncTimer;
            } else if (this.syncTimer == 0) {
                if (this.pending) {
                    this.syncedFluidStackDesc = this.getFluid().copy();
                    this.pending = false;
                    this.syncTimer = PNCConfig.Common.Advanced.fluidTankUpdateRate;
                } else {
                    this.syncTimer = -1;
                }
            }
        }
    }

    private void deferredSync(int ticks) {
        if (this.syncTimer == -1) {
            this.syncedFluidStackDesc = this.getFluid().copy();
            this.syncTimer = ticks;
        } else {
            this.pending = true;
        }
    }

    private void onFluidChange(FluidStack newFluid) {
        this.syncedFluidStackGui = newFluid.copy();
        int delta = Math.abs(this.syncedFluidStackDesc.getAmount() - newFluid.getAmount());
        if (delta >= this.threshold || this.syncedFluidStackDesc.getFluid() != newFluid.getFluid()) {
            this.deferredSync(PNCConfig.Common.Advanced.fluidTankUpdateRate);
        }
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        int filled = super.fill(resource, action);
        if (filled != 0 && action.execute()) {
            this.onFluidChange(this.getFluid());
        }
        return filled;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(resource, action);
        if (!drained.isEmpty() && action.execute()) {
            this.onFluidChange(this.getFluid());
        }
        return drained;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidStack drained = super.drain(maxDrain, action);
        if (!drained.isEmpty() && action.execute()) {
            this.onFluidChange(this.getFluid());
        }
        return drained;
    }

    protected void onContentsChanged() {
        super.onContentsChanged();
        if (this.owner.get() != null) {
            ((TileEntity)this.owner.get()).func_70296_d();
        }
    }

    public void setFluid(FluidStack stack) {
        this.onFluidChange(stack);
        super.setFluid(stack);
    }
}

