/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.BitSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.heat.IHeatExchangerLogic;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.api.item.IUpgradeAcceptor;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.heat.HeatExchangerLogicAmbient;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.IDescSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.NetworkUtils;
import me.desht.pneumaticcraft.common.network.PacketDescription;
import me.desht.pneumaticcraft.common.network.SyncedField;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethod;
import me.desht.pneumaticcraft.common.thirdparty.computer_common.LuaMethodRegistry;
import me.desht.pneumaticcraft.common.tileentity.CachedTileNeighbours;
import me.desht.pneumaticcraft.common.tileentity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.tileentity.ICamouflageableTE;
import me.desht.pneumaticcraft.common.tileentity.IGUIButtonSensitive;
import me.desht.pneumaticcraft.common.tileentity.IHeatExchangingTE;
import me.desht.pneumaticcraft.common.tileentity.ILuaMethodProvider;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.ISideConfigurable;
import me.desht.pneumaticcraft.common.tileentity.SideConfigurator;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.common.util.upgrade.ApplicableUpgradesDB;
import me.desht.pneumaticcraft.common.util.upgrade.IUpgradeHolder;
import me.desht.pneumaticcraft.common.util.upgrade.UpgradeCache;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public abstract class TileEntityBase
extends TileEntity
implements INameable,
IGUIButtonSensitive,
IDescSynced,
IUpgradeAcceptor,
IUpgradeHolder,
ILuaMethodProvider {
    private final UpgradeCache upgradeCache = new UpgradeCache(this);
    private final UpgradeHandler upgradeHandler;
    private boolean firstTick = true;
    private List<SyncedField<?>> descriptionFields;
    private final CachedTileNeighbours neighbourCache = new CachedTileNeighbours(this);
    private boolean preserveStateOnBreak = false;
    private float actualSpeedMult = 1.5f;
    private float actualUsageMult = 1.65f;
    private final LuaMethodRegistry luaMethodRegistry = new LuaMethodRegistry(this);
    private ITextComponent customName = null;
    private boolean forceFullSync;
    private BitSet fieldsToSync;

    public TileEntityBase(TileEntityType type) {
        this(type, 0);
    }

    public TileEntityBase(TileEntityType type, int upgradeSize) {
        super(type);
        this.upgradeHandler = new UpgradeHandler(upgradeSize);
    }

    @Override
    public String getUpgradeAcceptorTranslationKey() {
        return this.getBlockTranslationKey();
    }

    private String getBlockTranslationKey() {
        return "block.pneumaticcraft." + this.func_200662_C().getRegistryName().func_110623_a();
    }

    public ITextComponent func_200200_C_() {
        return this.customName == null ? new TranslationTextComponent(this.getBlockTranslationKey()) : this.customName;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public void setCustomName(ITextComponent customName) {
        this.customName = customName;
    }

    public ITextComponent func_145748_c_() {
        return this.func_200200_C_();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        return new PacketDescription(this, true).writeNBT(compound);
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        new PacketDescription(tag).process();
    }

    @Override
    public BlockPos getPosition() {
        return this.func_174877_v();
    }

    @Override
    public boolean shouldSyncField(int idx) {
        return this.fieldsToSync.get(idx);
    }

    @Override
    public List<SyncedField<?>> getDescriptionFields() {
        if (this.descriptionFields == null) {
            this.descriptionFields = NetworkUtils.getSyncedFields(this, DescSynced.class);
            this.fieldsToSync = new BitSet(this.descriptionFields.size());
            for (SyncedField<?> field : this.descriptionFields) {
                field.update();
            }
        }
        return this.descriptionFields;
    }

    public void sendDescriptionPacket() {
        PacketDescription descPacket = new PacketDescription(this, this.forceFullSync);
        if (descPacket.hasData()) {
            NetworkHandler.sendToAllTracking((Object)descPacket, this);
        }
        this.fieldsToSync.clear();
        this.forceFullSync = false;
    }

    void scheduleDescriptionPacket() {
        this.forceFullSync = true;
    }

    void tickImpl() {
        if (this.firstTick && !this.field_145850_b.field_72995_K) {
            this.onFirstServerTick();
        }
        this.firstTick = false;
        this.upgradeCache.validate();
        if (!this.field_145850_b.field_72995_K) {
            IHeatExchangerLogic logic;
            if (this instanceof IHeatExchangingTE && (logic = ((IHeatExchangingTE)((Object)this)).getHeatExchanger()) != null) {
                logic.tick();
            }
            if (this instanceof IAutoFluidEjecting && this.getUpgrades(EnumUpgrade.DISPENSER) > 0) {
                ((IAutoFluidEjecting)((Object)this)).autoExportFluid(this);
            }
            for (int i = 0; i < this.getDescriptionFields().size(); ++i) {
                if (!this.getDescriptionFields().get(i).update()) continue;
                this.fieldsToSync.set(i);
            }
            if (this.forceFullSync || !this.fieldsToSync.isEmpty()) {
                this.sendDescriptionPacket();
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getInventoryCap().isPresent()) {
            this.getInventoryCap().invalidate();
        }
        if (this.getHeatCap(null).isPresent()) {
            this.getHeatCap(null).invalidate();
        }
    }

    protected void onFirstServerTick() {
        if (this instanceof IHeatExchangingTE) {
            ((IHeatExchangingTE)((Object)this)).initializeHullHeatExchangers(this.field_145850_b, this.field_174879_c);
        }
    }

    protected void updateNeighbours() {
        this.field_145850_b.func_195593_d(this.func_174877_v(), this.func_195044_w().func_177230_c());
    }

    public void onBlockRotated() {
        if (this instanceof ISideConfigurable) {
            for (SideConfigurator<?> sc : ((ISideConfigurable)((Object)this)).getSideConfigurators()) {
                sc.setupFacingMatrix();
            }
        }
    }

    void rerenderTileEntity() {
        this.field_145850_b.func_184138_a(this.func_174877_v(), this.func_195044_w(), this.func_195044_w(), 0);
    }

    protected boolean shouldRerenderChunkOnDescUpdate() {
        return this instanceof ICamouflageableTE;
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        if (this instanceof ISideConfigurable) {
            tag.func_218657_a("SideConfiguration", (INBT)SideConfigurator.writeToNBT((ISideConfigurable)((Object)this)));
        }
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        if (this instanceof ISideConfigurable) {
            SideConfigurator.readFromNBT(tag.func_74775_l("SideConfiguration"), (ISideConfigurable)((Object)this));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        IHeatExchangerLogic logic;
        super.func_189515_b(tag);
        if (this.customName != null) {
            tag.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        if (this.getUpgradeHandler().getSlots() > 0) {
            tag.func_218657_a("UpgradeInventory", (INBT)this.getUpgradeHandler().serializeNBT());
        }
        if (this instanceof IHeatExchangingTE && (logic = ((IHeatExchangingTE)((Object)this)).getHeatExchanger()) != null) {
            tag.func_218657_a("HeatExchanger", (INBT)logic.serializeNBT());
        }
        if (this instanceof IRedstoneControl) {
            ((IRedstoneControl)((Object)this)).getRedstoneController().serialize(tag);
        }
        if (this instanceof ISerializableTanks) {
            tag.func_218657_a("SavedTanks", (INBT)((ISerializableTanks)((Object)this)).serializeTanks());
        }
        this.writeToPacket(tag);
        return tag;
    }

    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        IHeatExchangerLogic logic;
        super.func_230337_a_(state, tag);
        if (tag.func_150297_b("CustomName", 8)) {
            this.customName = ITextComponent.Serializer.func_240643_a_((String)tag.func_74779_i("CustomName"));
        }
        if (tag.func_74764_b("UpgradeInventory") && this.getUpgradeHandler() != null) {
            this.getUpgradeHandler().deserializeNBT(tag.func_74775_l("UpgradeInventory"));
        }
        if (this instanceof IHeatExchangingTE && (logic = ((IHeatExchangingTE)((Object)this)).getHeatExchanger()) != null) {
            logic.deserializeNBT(tag.func_74775_l("HeatExchanger"));
        }
        if (this instanceof IRedstoneControl) {
            ((IRedstoneControl)((Object)this)).getRedstoneController().deserialize(tag);
        }
        if (this instanceof ISerializableTanks) {
            ((ISerializableTanks)((Object)this)).deserializeTanks(tag.func_74775_l("SavedTanks"));
        }
        this.readFromPacket(tag);
    }

    @Override
    public void onDescUpdate() {
        if (this.shouldRerenderChunkOnDescUpdate()) {
            this.rerenderTileEntity();
            if (this instanceof ICamouflageableTE) {
                this.requestModelDataUpdate();
            }
        }
    }

    @Nonnull
    public IModelData getModelData() {
        if (this instanceof ICamouflageableTE) {
            return new ModelDataMap.Builder().withInitial(BlockPneumaticCraftCamo.BLOCK_ACCESS, (Object)this.field_145850_b).withInitial(BlockPneumaticCraftCamo.BLOCK_POS, (Object)this.field_174879_c).withInitial(BlockPneumaticCraftCamo.CAMO_STATE, (Object)((ICamouflageableTE)((Object)this)).getCamouflage()).build();
        }
        return super.getModelData();
    }

    public void onGuiUpdate() {
    }

    public Direction getRotation() {
        BlockState state = this.func_195044_w();
        return state.func_177230_c() instanceof BlockPneumaticCraft ? ((BlockPneumaticCraft)state.func_177230_c()).getRotation(state) : Direction.NORTH;
    }

    public void func_145836_u() {
        super.func_145836_u();
    }

    public int getUpgrades(EnumUpgrade upgrade) {
        return this.upgradeCache.getUpgrades(upgrade);
    }

    public float getSpeedMultiplierFromUpgrades() {
        return this.actualSpeedMult;
    }

    public float getSpeedUsageMultiplierFromUpgrades() {
        return this.actualUsageMult;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
    }

    public boolean isGuiUseableByPlayer(PlayerEntity player) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this && player.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.func_174877_v())) <= 64.0;
    }

    public TileEntity getCachedNeighbor(Direction dir) {
        return this.neighbourCache.getCachedNeighbour(dir);
    }

    public void onNeighborTileUpdate(BlockPos tilePos) {
    }

    public void onNeighborBlockUpdate(BlockPos fromPos) {
        if (this instanceof IHeatExchangingTE) {
            ((IHeatExchangingTE)((Object)this)).initializeHullHeatExchangers(this.field_145850_b, this.field_174879_c);
        }
        if (this instanceof IRedstoneControl) {
            ((IRedstoneControl)((Object)this)).getRedstoneController().updateRedstonePower();
        }
        this.neighbourCache.purge();
    }

    void processFluidItem(int inputSlot, int outputSlot) {
        this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
            ItemStack inputStack = itemHandler.getStackInSlot(inputSlot);
            if (inputStack.func_190916_E() != 1) {
                return;
            }
            FluidUtil.getFluidHandler((ItemStack)inputStack).ifPresent(fluidHandlerItem -> {
                FluidStack itemContents = fluidHandlerItem.drain(1000, IFluidHandler.FluidAction.SIMULATE);
                this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).ifPresent(fluidHandler -> {
                    FluidStack transferred;
                    if (!itemContents.isEmpty()) {
                        ItemStack emptyContainerStack;
                        ItemStack excess;
                        FluidStack transferred2 = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandler, (IFluidHandler)fluidHandlerItem, (int)itemContents.getAmount(), (boolean)true);
                        if (transferred2.getAmount() == itemContents.getAmount() && (excess = itemHandler.insertItem(outputSlot, emptyContainerStack = fluidHandlerItem.getContainer(), true)).func_190926_b()) {
                            itemHandler.extractItem(inputSlot, 1, false);
                            itemHandler.insertItem(outputSlot, emptyContainerStack, false);
                        }
                    } else if (itemHandler.getStackInSlot(outputSlot).func_190926_b() && !(transferred = FluidUtil.tryFluidTransfer((IFluidHandler)fluidHandlerItem, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, (boolean)true)).isEmpty()) {
                        itemHandler.extractItem(inputSlot, 1, false);
                        ItemStack filledContainerStack = fluidHandlerItem.getContainer();
                        itemHandler.insertItem(outputSlot, filledContainerStack, false);
                    }
                });
            });
        });
    }

    @Override
    public Map<EnumUpgrade, Integer> getApplicableUpgrades() {
        return ApplicableUpgradesDB.getInstance().getApplicableUpgrades(this);
    }

    @Override
    public void addLuaMethods(LuaMethodRegistry registry) {
        if (this instanceof IHeatExchangingTE) {
            registry.registerLuaMethod(new LuaMethod("getTemperature"){

                @Override
                public Object[] call(Object[] args) {
                    this.requireArgs(args, 0, 1, "face? (down/up/north/south/west/east)");
                    Direction dir = args.length == 0 ? null : this.getDirForString((String)args[0]);
                    IHeatExchangerLogic logic = ((IHeatExchangingTE)((Object)TileEntityBase.this)).getHeatExchanger(dir);
                    double temp = logic == null ? HeatExchangerLogicAmbient.getAmbientTemperature((IWorld)TileEntityBase.this.field_145850_b, TileEntityBase.this.field_174879_c) : logic.getTemperature();
                    return new Object[]{temp};
                }
            });
        }
    }

    @Override
    public LuaMethodRegistry getLuaMethodRegistry() {
        return this.luaMethodRegistry;
    }

    @Override
    public String getPeripheralType() {
        return this.func_200662_C().getRegistryName().toString();
    }

    public abstract IItemHandler getPrimaryInventory();

    public UpgradeHandler getUpgradeHandler() {
        return this.upgradeHandler;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getInventoryCap().cast();
        }
        if (cap == PNCCapabilities.HEAT_EXCHANGER_CAPABILITY) {
            return this.getHeatCap(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return LazyOptional.empty();
    }

    @Nonnull
    public LazyOptional<IHeatExchangerLogic> getHeatCap(Direction side) {
        return LazyOptional.empty();
    }

    public void getContentsToDrop(NonNullList<ItemStack> drops) {
        BlockState camoState;
        PneumaticCraftUtils.collectNonEmptyItems(this.getPrimaryInventory(), drops);
        if (!this.shouldPreserveStateOnBreak()) {
            UpgradeHandler uh = this.getUpgradeHandler();
            for (int i = 0; i < uh.getSlots(); ++i) {
                if (uh.getStackInSlot(i).func_190926_b()) continue;
                drops.add((Object)uh.getStackInSlot(i));
            }
        }
        if (this instanceof ICamouflageableTE && (camoState = ((ICamouflageableTE)((Object)this)).getCamouflage()) != null) {
            drops.add((Object)ICamouflageableTE.getStackForState(camoState));
        }
    }

    public boolean shouldPreserveStateOnBreak() {
        return this.preserveStateOnBreak;
    }

    public void setPreserveStateOnBreak(boolean preserveStateOnBreak) {
        this.preserveStateOnBreak = preserveStateOnBreak;
    }

    public String getCurrentRecipeIdSynced() {
        return "";
    }

    @Override
    public void onUpgradesChanged() {
        this.actualSpeedMult = (float)Math.pow(PNCConfig.Common.Machines.speedUpgradeSpeedMultiplier, Math.min(10, this.getUpgrades(EnumUpgrade.SPEED)));
        this.actualUsageMult = (float)Math.pow(PNCConfig.Common.Machines.speedUpgradeUsageMultiplier, Math.min(10, this.getUpgrades(EnumUpgrade.SPEED)));
    }

    public UpgradeCache getUpgradeCache() {
        return this.upgradeCache;
    }

    public void serializeExtraItemData(CompoundNBT blockEntityTag, boolean preserveState) {
    }

    public class UpgradeHandler
    extends BaseItemStackHandler {
        UpgradeHandler(int upgradeSize) {
            super(TileEntityBase.this, upgradeSize);
        }

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || this.isApplicable(itemStack) && this.isUnique(slot, itemStack);
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            EnumUpgrade upgrade = EnumUpgrade.from(stack);
            if (upgrade == null) {
                return 0;
            }
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(this.te, upgrade);
        }

        private boolean isUnique(int slot, ItemStack stack) {
            for (int i = 0; i < this.getSlots(); ++i) {
                if (i == slot || EnumUpgrade.from(stack) != EnumUpgrade.from(this.getStackInSlot(i))) continue;
                return false;
            }
            return true;
        }

        private boolean isApplicable(ItemStack stack) {
            EnumUpgrade upgrade = EnumUpgrade.from(stack);
            return ApplicableUpgradesDB.getInstance().getMaxUpgrades(TileEntityBase.this, upgrade) > 0;
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityBase.this.upgradeCache.invalidate();
        }
    }
}

