/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockElectrostaticCompressor;
import me.desht.pneumaticcraft.common.config.PNCConfig;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerElectrostaticCompressor;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

public class TileEntityElectrostaticCompressor
extends TileEntityPneumaticBase
implements IRedstoneControl<TileEntityElectrostaticCompressor>,
INamedContainerProvider {
    @ObjectHolder(value="chisel:ironpane")
    private static Block CHISELED_BARS = null;
    private static final List<RedstoneController.RedstoneMode<TileEntityElectrostaticCompressor>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<TileEntityElectrostaticCompressor>("standard.never", new ItemStack((IItemProvider)Items.field_151016_H), te -> false), new RedstoneController.EmittingRedstoneMode<TileEntityElectrostaticCompressor>("electrostaticCompressor.struckByLightning", Textures.JEI_EXPLOSION, te -> te.struckByLightningCooldown > 0));
    private static final int MAX_ELECTROSTATIC_GRID_SIZE = 500;
    private static final int MAX_BARS_ABOVE = 10;
    @GuiSynced
    public final RedstoneController<TileEntityElectrostaticCompressor> rsController = new RedstoneController<TileEntityElectrostaticCompressor>(this, REDSTONE_MODES);
    private boolean lastRedstoneState;
    public int ironBarsBeneath = 0;
    public int ironBarsAbove = 0;
    private int struckByLightningCooldown;

    public TileEntityElectrostaticCompressor() {
        super((TileEntityType)ModTileEntities.ELECTROSTATIC_COMPRESSOR.get(), 20.0f, 25.0f, 50000, 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if ((this.func_145831_w().func_82737_E() & 0x1FL) == 0L) {
            int max = 20;
            this.ironBarsBeneath = 0;
            while (this.ironBarsBeneath < max && TileEntityElectrostaticCompressor.isValidGridBlock(this.func_145831_w().func_180495_p(this.func_174877_v().func_177979_c(this.ironBarsBeneath + 1)).func_177230_c())) {
                ++this.ironBarsBeneath;
            }
            this.ironBarsAbove = 0;
            while (this.ironBarsAbove < 10 && TileEntityElectrostaticCompressor.isValidGridBlock(this.func_145831_w().func_180495_p(this.func_174877_v().func_177981_b(this.ironBarsAbove + 1)).func_177230_c())) {
                ++this.ironBarsAbove;
            }
        }
        if (!this.func_145831_w().field_72995_K) {
            this.maybeLightningStrike();
            if (this.lastRedstoneState != this.rsController.shouldEmit()) {
                this.lastRedstoneState = !this.lastRedstoneState;
                this.updateNeighbours();
            }
            --this.struckByLightningCooldown;
        }
    }

    public int getStrikeChance() {
        int strikeChance = PNCConfig.Common.Machines.electrostaticLightningChance;
        if (this.func_145831_w().func_72896_J()) {
            strikeChance = (int)((double)strikeChance * 0.5);
        }
        if (this.func_145831_w().func_72911_I()) {
            strikeChance = (int)((double)strikeChance * 0.2);
        }
        strikeChance = (int)((float)strikeChance * (1.0f - 0.02f * (float)this.ironBarsAbove));
        return strikeChance;
    }

    private void maybeLightningStrike() {
        Random rnd = this.func_145831_w().field_73012_v;
        if (rnd.nextInt(this.getStrikeChance()) == 0) {
            int dist = rnd.nextInt(6);
            float angle = rnd.nextFloat() * (float)Math.PI * 2.0f;
            int x = (int)((float)this.func_174877_v().func_177958_n() + (float)dist * MathHelper.func_76126_a((float)angle));
            int z = (int)((float)this.func_174877_v().func_177952_p() + (float)dist * MathHelper.func_76134_b((float)angle));
            for (int y = this.func_174877_v().func_177956_o() + 5; y > this.func_174877_v().func_177956_o() - 5; --y) {
                BlockPos hitPos = new BlockPos(x, y, z);
                BlockState state = this.func_145831_w().func_180495_p(hitPos);
                if (!(state.func_177230_c() instanceof BlockElectrostaticCompressor) && state.func_177230_c() != Blocks.field_150411_aY) continue;
                HashSet<BlockPos> gridSet = new HashSet<BlockPos>();
                HashSet<TileEntityElectrostaticCompressor> compressorSet = new HashSet<TileEntityElectrostaticCompressor>();
                this.getElectrostaticGrid(gridSet, compressorSet, hitPos);
                LightningBoltEntity bolt = new LightningBoltEntity(EntityType.field_200728_aG, this.func_145831_w());
                bolt.func_70107_b((double)x, (double)y, (double)z);
                this.func_145831_w().func_217376_c((Entity)bolt);
                for (TileEntityElectrostaticCompressor compressor : compressorSet) {
                    compressor.addAir(200000 / compressorSet.size());
                    compressor.onStruckByLightning();
                }
                AxisAlignedBB box = new AxisAlignedBB(this.func_174877_v()).func_72314_b(16.0, 16.0, 16.0);
                for (LivingEntity entity : this.func_145831_w().func_175647_a(LivingEntity.class, box, EntityPredicates.field_94557_a)) {
                    BlockPos pos = entity.func_233580_cy_();
                    if (!gridSet.contains(pos) && !gridSet.contains(pos.func_177977_b()) || ForgeEventFactory.onEntityStruckByLightning((Entity)entity, (LightningBoltEntity)bolt)) continue;
                    entity.func_241841_a((ServerWorld)this.func_145831_w(), bolt);
                }
                break;
            }
        }
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        return dir != Direction.UP;
    }

    public void onStruckByLightning() {
        this.struckByLightningCooldown = 10;
        if (this.getPressure() > 20.0f) {
            int maxRedirection = 10000 * this.ironBarsBeneath;
            int tooMuchAir = (int)((this.getPressure() - 20.0f) * (float)this.airHandler.getVolume());
            this.addAir(-Math.min(maxRedirection, tooMuchAir));
        }
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    public void getElectrostaticGrid(Set<BlockPos> grid, Set<TileEntityElectrostaticCompressor> compressors, BlockPos pos) {
        ArrayDeque<BlockPos> pendingPos = new ArrayDeque<BlockPos>(Collections.singleton(pos));
        grid.add(pos);
        PneumaticCraftUtils.getTileEntityAt((IBlockReader)this.field_145850_b, pos, TileEntityElectrostaticCompressor.class).ifPresent(compressors::add);
        while (!pendingPos.isEmpty()) {
            BlockPos checkingPos = (BlockPos)pendingPos.pop();
            for (Direction d : DirectionUtil.VALUES) {
                BlockPos newPos = checkingPos.func_177972_a(d);
                Block block = this.field_145850_b.func_180495_p(newPos).func_177230_c();
                if (!TileEntityElectrostaticCompressor.isValidGridBlock(block) && block != ModBlocks.ELECTROSTATIC_COMPRESSOR.get() || grid.size() >= 500 || !grid.add(newPos)) continue;
                if (block == ModBlocks.ELECTROSTATIC_COMPRESSOR.get()) {
                    PneumaticCraftUtils.getTileEntityAt((IBlockReader)this.field_145850_b, newPos, TileEntityElectrostaticCompressor.class).ifPresent(compressors::add);
                }
                pendingPos.push(newPos);
            }
        }
    }

    private static boolean isValidGridBlock(Block block) {
        return block == Blocks.field_150411_aY || block == CHISELED_BARS;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerElectrostaticCompressor(i, playerInventory, this.func_174877_v());
    }

    @Override
    public RedstoneController<TileEntityElectrostaticCompressor> getRedstoneController() {
        return this.rsController;
    }
}

