/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.crafting.recipe.FluidMixerRecipe;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerFluidMixer;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.inventory.handler.OutputItemHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.recipes.PneumaticCraftRecipeType;
import me.desht.pneumaticcraft.common.recipes.machine.FluidMixerRecipeImpl;
import me.desht.pneumaticcraft.common.tileentity.IAutoFluidEjecting;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityFluidMixer
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl<TileEntityFluidMixer>,
INamedContainerProvider,
ISerializableTanks,
IAutoFluidEjecting {
    private static final Map<Fluid, Set<Fluid>> FLUID_MATCHES = new HashMap<Fluid, Set<Fluid>>();
    private final ItemStackHandler outputInv = new BaseItemStackHandler(this, 1);
    private final OutputItemHandler outputInvWrapper = new OutputItemHandler((IItemHandlerModifiable)this.outputInv);
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.outputInvWrapper);
    @GuiSynced
    @DescSynced
    private final SmartSyncTank inputTank1 = new InputTank();
    @GuiSynced
    @DescSynced
    private final SmartSyncTank inputTank2 = new InputTank();
    @GuiSynced
    @DescSynced
    private final SmartSyncTank outputTank = new SmartSyncTank(this, 16000);
    @GuiSynced
    private float requiredPressure;
    @GuiSynced
    private int redstoneMode;
    @GuiSynced
    public int craftingProgress = 0;
    @GuiSynced
    public int maxProgress;
    @DescSynced
    public boolean didWork;
    @GuiSynced
    private final RedstoneController<TileEntityFluidMixer> rsController = new RedstoneController<TileEntityFluidMixer>(this);
    @GuiSynced
    private String currentRecipeIdSynced = "";
    private float airUsed;
    private FluidMixerRecipe currentRecipe = null;
    private boolean searchRecipes = true;
    private final MixerFluidHandler fluidHandler = new MixerFluidHandler();
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.fluidHandler);
    private final SmartSyncTank[] tanks = new SmartSyncTank[]{this.inputTank1, this.inputTank2, this.outputTank};

    public TileEntityFluidMixer() {
        super((TileEntityType)ModTileEntities.FLUID_MIXER.get(), 5.0f, 7.0f, 3000, 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.inputTank1.tick();
        this.inputTank2.tick();
        this.outputTank.tick();
        if (!this.field_145850_b.field_72995_K) {
            this.didWork = false;
            if (this.searchRecipes) {
                this.currentRecipe = this.findApplicableRecipe();
                this.currentRecipeIdSynced = this.currentRecipe == null ? "" : this.currentRecipe.func_199560_c().toString();
                this.requiredPressure = this.currentRecipe != null ? this.currentRecipe.getRequiredPressure() : 0.0f;
                this.maxProgress = this.currentRecipe != null ? this.currentRecipe.getProcessingTime() * 100 : 0;
                this.searchRecipes = false;
            }
            if (this.rsController.shouldRun() && this.currentRecipe != null && this.getPressure() >= this.requiredPressure && this.hasOutputSpace()) {
                this.craftingProgress = (int)((float)this.craftingProgress + 100.0f * (1.0f + Math.min(this.getPressure() - this.requiredPressure, 1.5f)));
                this.didWork = true;
                this.airUsed += 2.5f * this.getPressure();
                if (this.airUsed > 1.0f) {
                    int a = (int)this.airUsed;
                    this.airHandler.addAir(-a);
                    this.airUsed -= (float)a;
                }
                if (this.craftingProgress >= this.maxProgress && this.takeInputIngredients()) {
                    if (!this.currentRecipe.getOutputFluid().isEmpty()) {
                        this.outputTank.fill(this.currentRecipe.getOutputFluid().copy(), IFluidHandler.FluidAction.EXECUTE);
                    }
                    if (!this.currentRecipe.getOutputItem().func_190926_b()) {
                        this.outputInv.insertItem(0, this.currentRecipe.getOutputItem().func_77946_l(), false);
                    }
                    this.craftingProgress -= this.maxProgress;
                }
            }
        } else if (this.didWork && this.field_145850_b.field_73012_v.nextFloat() < 0.1f) {
            ClientUtils.emitParticles(this.field_145850_b, this.field_174879_c, (IParticleData)ParticleTypes.field_197600_K);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.outputInv.serializeNBT());
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.outputInv.deserializeNBT(tag.func_74775_l("Items"));
    }

    @Override
    public String getCurrentRecipeIdSynced() {
        return this.currentRecipeIdSynced;
    }

    private boolean takeInputIngredients() {
        if (this.currentRecipe.getInput1().testFluid(this.inputTank1.getFluid()) && this.currentRecipe.getInput2().testFluid(this.inputTank2.getFluid())) {
            this.inputTank1.drain(this.currentRecipe.getInput1().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.inputTank2.drain(this.currentRecipe.getInput2().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        if (this.currentRecipe.getInput2().testFluid(this.inputTank1.getFluid()) && this.currentRecipe.getInput1().testFluid(this.inputTank2.getFluid())) {
            this.inputTank1.drain(this.currentRecipe.getInput2().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            this.inputTank2.drain(this.currentRecipe.getInput1().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            return true;
        }
        return false;
    }

    public boolean hasOutputSpace() {
        if (!this.currentRecipe.getOutputItem().func_190926_b() && !this.outputInv.insertItem(0, this.currentRecipe.getOutputItem(), true).func_190926_b()) {
            return false;
        }
        return this.currentRecipe.getOutputFluid().isEmpty() || this.outputTank.fill(this.currentRecipe.getOutputFluid(), IFluidHandler.FluidAction.SIMULATE) >= this.currentRecipe.getOutputFluid().getAmount();
    }

    private FluidMixerRecipe findApplicableRecipe() {
        for (FluidMixerRecipe fluidMixerRecipe : PneumaticCraftRecipeType.FLUID_MIXER.getRecipes(this.field_145850_b).values()) {
            if (!fluidMixerRecipe.matches(this.inputTank1.getFluid(), this.inputTank2.getFluid())) continue;
            return fluidMixerRecipe;
        }
        return null;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.outputInvWrapper;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side != Direction.UP && side != this.getRotation();
    }

    public static void clearCachedFluids() {
        FLUID_MATCHES.clear();
    }

    public static void cacheRecipeFluids(List<FluidMixerRecipeImpl> values) {
        for (FluidMixerRecipeImpl recipe : values) {
            for (FluidStack input1 : recipe.getInput1().getFluidStacks()) {
                for (FluidStack input2 : recipe.getInput2().getFluidStacks()) {
                    Set fluidSet1 = FLUID_MATCHES.computeIfAbsent(input1.getFluid(), k -> new HashSet());
                    Set fluidSet2 = FLUID_MATCHES.computeIfAbsent(input2.getFluid(), k -> new HashSet());
                    fluidSet1.add(input2.getFluid());
                    fluidSet2.add(input1.getFluid());
                }
            }
        }
    }

    public static boolean isFluidAccepted(Fluid fluid) {
        return FLUID_MATCHES.containsKey(fluid);
    }

    public static boolean isFluidMatch(Fluid fluid1, Fluid fluid2) {
        Set<Fluid> fluids = FLUID_MATCHES.get(fluid1);
        return fluids != null && fluids.contains(fluid2);
    }

    @Override
    public float getMinWorkingPressure() {
        return this.requiredPressure;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerFluidMixer(windowId, inv, this.field_174879_c);
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (tag.startsWith("dump")) {
            try {
                this.moveOrDump((PlayerEntity)player, Integer.parseInt(tag.substring(4)), shiftHeld);
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            super.handleGUIButtonPress(tag, shiftHeld, player);
        }
    }

    private void moveOrDump(PlayerEntity player, int tank, boolean shiftHeld) {
        SmartSyncTank inputTank = tank == 1 ? this.inputTank1 : this.inputTank2;
        FluidStack moved = shiftHeld ? inputTank.drain(inputTank.getCapacity(), IFluidHandler.FluidAction.EXECUTE) : FluidUtil.tryFluidTransfer((IFluidHandler)this.outputTank, (IFluidHandler)inputTank, (int)inputTank.getFluidAmount(), (boolean)true);
        if (!moved.isEmpty() && player instanceof ServerPlayerEntity) {
            NetworkHandler.sendToPlayer(new PacketPlaySound(SoundEvents.field_187630_M, SoundCategory.BLOCKS, this.field_174879_c, 1.0f, 1.0f, false), (ServerPlayerEntity)player);
        }
    }

    @Override
    public RedstoneController<TileEntityFluidMixer> getRedstoneController() {
        return this.rsController;
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Input1", (Object)((Object)this.inputTank1), (Object)"Input2", (Object)((Object)this.inputTank2), (Object)"Output", (Object)((Object)this.outputTank));
    }

    public IFluidTank getInputTank1() {
        return this.inputTank1;
    }

    public IFluidTank getInputTank2() {
        return this.inputTank2;
    }

    public IFluidTank getOutputTank() {
        return this.outputTank;
    }

    public float getCraftingPercentage() {
        return this.maxProgress > 0 ? (float)this.craftingProgress / (float)this.maxProgress : 0.0f;
    }

    private class InputTank
    extends SmartSyncTank {
        InputTank() {
            super(TileEntityFluidMixer.this, 16000);
        }

        @Override
        protected void onContentsChanged() {
            super.onContentsChanged();
            TileEntityFluidMixer.this.searchRecipes = true;
        }
    }

    private class MixerFluidHandler
    implements IFluidHandler {
        private MixerFluidHandler() {
        }

        public int getTanks() {
            return 3;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return TileEntityFluidMixer.this.tanks[tank].getFluid();
        }

        public int getTankCapacity(int tank) {
            return TileEntityFluidMixer.this.tanks[tank].getCapacity();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return TileEntityFluidMixer.this.tanks[tank].isFluidValid(stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (TileEntityFluidMixer.isFluidAccepted(resource.getFluid())) {
                if (TileEntityFluidMixer.this.inputTank1.isEmpty() && TileEntityFluidMixer.this.inputTank2.isEmpty()) {
                    return TileEntityFluidMixer.this.inputTank1.fill(resource, action);
                }
                if (TileEntityFluidMixer.this.inputTank2.isEmpty()) {
                    if (resource.getFluid() == TileEntityFluidMixer.this.inputTank1.getFluid().getFluid()) {
                        return TileEntityFluidMixer.this.inputTank1.fill(resource, action);
                    }
                    if (TileEntityFluidMixer.isFluidMatch(resource.getFluid(), TileEntityFluidMixer.this.inputTank1.getFluid().getFluid())) {
                        return TileEntityFluidMixer.this.inputTank2.fill(resource, action);
                    }
                } else if (TileEntityFluidMixer.this.inputTank1.isEmpty()) {
                    if (resource.getFluid() == TileEntityFluidMixer.this.inputTank2.getFluid().getFluid()) {
                        return TileEntityFluidMixer.this.inputTank2.fill(resource, action);
                    }
                    if (TileEntityFluidMixer.isFluidMatch(resource.getFluid(), TileEntityFluidMixer.this.inputTank2.getFluid().getFluid())) {
                        return TileEntityFluidMixer.this.inputTank1.fill(resource, action);
                    }
                } else {
                    int filled = TileEntityFluidMixer.this.inputTank1.fill(resource, action);
                    return filled == 0 ? TileEntityFluidMixer.this.inputTank2.fill(resource, action) : filled;
                }
            }
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return TileEntityFluidMixer.this.outputTank.drain(resource, action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return TileEntityFluidMixer.this.outputTank.drain(maxDrain, action);
        }
    }
}

