/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.block.BlockFluidTank;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraft;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerFluidTank;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.LazySynced;
import me.desht.pneumaticcraft.common.tileentity.IComparatorSupport;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.IOHelper;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TileEntityFluidTank
extends TileEntityTickableBase
implements ISerializableTanks,
INamedContainerProvider,
IComparatorSupport {
    private static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    private static final int BASE_EJECT_RATE = 25;
    @LazySynced
    @DescSynced
    @GuiSynced
    private final StackableTank tank;
    private final LazyOptional<IFluidHandler> fluidCap;
    private final ItemStackHandler inventory = new BaseItemStackHandler(this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent();
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    TileEntityFluidTank(TileEntityType<?> type, BlockFluidTank.Size tankSize) {
        super(type, 4);
        this.tank = new StackableTank(tankSize.getCapacity());
        this.fluidCap = LazyOptional.of(() -> this.tank);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.tank.tick();
        if (!this.field_145850_b.field_72995_K) {
            Direction ejectDir;
            this.processFluidItem(0, 1);
            FluidStack stack = this.getTank().getFluid();
            if (!stack.isEmpty()) {
                TileEntity teOther;
                BlockState other;
                Direction dir;
                Direction direction = dir = stack.getFluid().getAttributes().getDensity() < 0 ? Direction.UP : Direction.DOWN;
                if (((Boolean)this.func_195044_w().func_177229_b((Property)BlockPneumaticCraft.connectionProperty(dir))).booleanValue() && (other = this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(dir))).func_177230_c() instanceof BlockFluidTank && ((Boolean)other.func_177229_b((Property)BlockPneumaticCraft.connectionProperty(dir.func_176734_d()))).booleanValue() && (teOther = this.getCachedNeighbor(dir)) instanceof TileEntityFluidTank) {
                    FluidUtil.tryFluidTransfer((IFluidHandler)((TileEntityFluidTank)teOther).getTank(), (IFluidHandler)this.tank, (int)(this.tank.getCapacity() / 32), (boolean)true);
                }
            }
            if (!((ejectDir = this.getUpgradeCache().getEjectDirection()) == null || ejectDir.func_176740_k() == Direction.Axis.Y && ((Boolean)this.func_195044_w().func_177229_b((Property)BlockPneumaticCraft.connectionProperty(ejectDir))).booleanValue())) {
                IOHelper.getFluidHandlerForTE(this.getCachedNeighbor(ejectDir), ejectDir.func_176734_d()).ifPresent(h -> {
                    int amount = 25 << this.getUpgrades(EnumUpgrade.SPEED);
                    FluidUtil.tryFluidTransfer((IFluidHandler)h, (IFluidHandler)this.tank, (int)amount, (boolean)true);
                });
            }
        }
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.orEmpty(cap, this.fluidCap);
        }
        return super.getCapability(cap, side);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)((Object)this.tank));
    }

    public SmartSyncTank getTank() {
        return this.tank;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerFluidTank(windowId, inv, this.func_174877_v());
    }

    public boolean isNeighbourCompatible(FluidStack stack, Direction dir) {
        BlockState state = this.func_195044_w();
        TileEntityFluidTank curTank = this;
        while (state.func_177230_c() instanceof BlockFluidTank) {
            if (!((Boolean)state.func_177229_b((Property)BlockPneumaticCraft.connectionProperty(dir))).booleanValue()) {
                return true;
            }
            TileEntity teOther = curTank.getCachedNeighbor(dir);
            if (teOther instanceof TileEntityFluidTank) {
                curTank = (TileEntityFluidTank)teOther;
                state = curTank.func_195044_w();
                if (this.isFluidCompatible(stack, (IFluidTank)curTank.getTank())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean isFluidCompatible(FluidStack stack, IFluidTank tank) {
        return stack.isEmpty() || tank.getFluid().isEmpty() || stack.getFluid() == tank.getFluid().getFluid();
    }

    @Override
    public int getComparatorValue() {
        return this.tank.isEmpty() ? 0 : 1 + this.tank.getFluidAmount() * 14 / this.tank.getCapacity();
    }

    public static class Huge
    extends TileEntityFluidTank {
        public Huge() {
            super((TileEntityType)ModTileEntities.TANK_HUGE.get(), BlockFluidTank.Size.HUGE);
        }
    }

    public static class Large
    extends TileEntityFluidTank {
        public Large() {
            super((TileEntityType)ModTileEntities.TANK_LARGE.get(), BlockFluidTank.Size.LARGE);
        }
    }

    public static class Medium
    extends TileEntityFluidTank {
        public Medium() {
            super((TileEntityType)ModTileEntities.TANK_MEDIUM.get(), BlockFluidTank.Size.MEDIUM);
        }
    }

    public static class Small
    extends TileEntityFluidTank {
        public Small() {
            super((TileEntityType)ModTileEntities.TANK_SMALL.get(), BlockFluidTank.Size.SMALL);
        }
    }

    public class StackableTank
    extends SmartSyncTank {
        StackableTank(int capacity) {
            super(TileEntityFluidTank.this, capacity);
        }

        public boolean isFluidValid(FluidStack stack) {
            return TileEntityFluidTank.this.isNeighbourCompatible(stack, Direction.UP) && TileEntityFluidTank.this.isNeighbourCompatible(stack, Direction.DOWN);
        }
    }
}

