/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.fluid.FuelRegistry;
import me.desht.pneumaticcraft.common.inventory.ContainerLiquidCompressor;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.ISerializableTanks;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.SmartSyncTank;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityLiquidCompressor
extends TileEntityPneumaticBase
implements IRedstoneControl<TileEntityLiquidCompressor>,
ISerializableTanks,
INamedContainerProvider {
    public static final int INVENTORY_SIZE = 2;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    @GuiSynced
    private final SmartSyncTank tank = new SmartSyncTank(this, 16000){

        public boolean isFluidValid(FluidStack stack) {
            return FuelRegistry.getInstance().getFuelValue(TileEntityLiquidCompressor.this.field_145850_b, stack.getFluid()) > 0;
        }
    };
    private final ItemStackHandler itemHandler = new BaseItemStackHandler(this, 2){

        public boolean isItemValid(int slot, ItemStack itemStack) {
            return itemStack.func_190926_b() || FluidUtil.getFluidHandler((ItemStack)itemStack) != null;
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.itemHandler);
    private final LazyOptional<IFluidHandler> fluidCap = LazyOptional.of(() -> this.tank);
    private double internalFuelBuffer;
    private float burnMultiplier = 1.0f;
    @GuiSynced
    public final RedstoneController<TileEntityLiquidCompressor> rsController = new RedstoneController<TileEntityLiquidCompressor>(this);
    @GuiSynced
    public float airPerTick;
    private float airBuffer;
    @DescSynced
    @GuiSynced
    public boolean isProducing;

    public TileEntityLiquidCompressor() {
        this((TileEntityType)ModTileEntities.LIQUID_COMPRESSOR.get(), 5.0f, 7.0f, 5000);
    }

    TileEntityLiquidCompressor(TileEntityType type, float dangerPressure, float criticalPressure, int volume) {
        super(type, dangerPressure, criticalPressure, volume, 4);
    }

    public FluidTank getTank() {
        return this.tank;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.tank.tick();
        if (!this.func_145831_w().field_72995_K) {
            this.processFluidItem(0, 1);
            this.isProducing = false;
            this.airPerTick = (float)this.getBaseProduction() * this.burnMultiplier * this.getSpeedMultiplierFromUpgrades() * ((float)this.getHeatEfficiency() / 100.0f);
            if (this.rsController.shouldRun()) {
                double fuelValue;
                double usageRate = (float)this.getBaseProduction() * this.getSpeedUsageMultiplierFromUpgrades() * this.burnMultiplier;
                if (this.internalFuelBuffer < usageRate && (fuelValue = (double)FuelRegistry.getInstance().getFuelValue(this.field_145850_b, this.tank.getFluid().getFluid()) / 1000.0) > 0.0) {
                    int usedFuel = Math.min(this.tank.getFluidAmount(), (int)(usageRate / fuelValue) + 1);
                    this.tank.drain(usedFuel, IFluidHandler.FluidAction.EXECUTE);
                    this.internalFuelBuffer += (double)usedFuel * fuelValue;
                    this.burnMultiplier = FuelRegistry.getInstance().getBurnRateMultiplier(this.field_145850_b, this.tank.getFluid().getFluid());
                }
                if (this.internalFuelBuffer >= usageRate) {
                    this.isProducing = true;
                    this.internalFuelBuffer -= usageRate;
                    this.airBuffer += this.airPerTick;
                    if (this.airBuffer >= 1.0f) {
                        int toAdd = (int)this.airBuffer;
                        this.addAir(toAdd);
                        this.airBuffer -= (float)toAdd;
                        this.addHeatForAir(toAdd);
                    }
                }
            }
        } else if (this.isProducing && this.field_145850_b.field_73012_v.nextInt(5) == 0) {
            ClientUtils.emitParticles(this.func_145831_w(), this.func_174877_v(), (IParticleData)ParticleTypes.field_197601_L);
        }
    }

    protected void addHeatForAir(int air) {
    }

    public int getHeatEfficiency() {
        return 100;
    }

    public int getBaseProduction() {
        return 10;
    }

    @Override
    public boolean canConnectPneumatic(Direction dir) {
        Direction orientation = this.getRotation();
        return orientation == dir || orientation == dir.func_176734_d() || dir == Direction.UP;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Items", (INBT)this.itemHandler.serializeNBT());
        tag.func_74780_a("internalFuelBuffer", this.internalFuelBuffer);
        tag.func_74776_a("burnMultiplier", this.burnMultiplier);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.itemHandler.deserializeNBT(tag.func_74775_l("Items"));
        this.internalFuelBuffer = tag.func_74769_h("internalFuelBuffer");
        this.burnMultiplier = tag.func_74760_g("burnMultiplier");
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.itemHandler;
    }

    @Override
    public RedstoneController<TileEntityLiquidCompressor> getRedstoneController() {
        return this.rsController;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidCap.cast();
        }
        return super.getCapability(cap, facing);
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.inventoryCap;
    }

    @Override
    @Nonnull
    public Map<String, FluidTank> getSerializableTanks() {
        return ImmutableMap.of((Object)"Tank", (Object)((Object)this.tank));
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerLiquidCompressor(i, playerInventory, this.func_174877_v());
    }
}

