/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerPressurizedSpawner;
import me.desht.pneumaticcraft.common.item.ItemSpawnerCore;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.IRangedTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.RangeManager;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityVacuumTrap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;

public class TileEntityPressurizedSpawner
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
IRedstoneControl<TileEntityPressurizedSpawner>,
INamedContainerProvider,
IRangedTE {
    public static final int BASE_SPAWN_INTERVAL = 200;
    private final ItemSpawnerCore.SpawnerCoreItemHandler inventory = new ItemSpawnerCore.SpawnerCoreItemHandler();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    @GuiSynced
    public TileEntityVacuumTrap.Problems problem = TileEntityVacuumTrap.Problems.OK;
    @GuiSynced
    private final RedstoneController<TileEntityPressurizedSpawner> rsController = new RedstoneController<TileEntityPressurizedSpawner>(this);
    private int counter = 200;
    @DescSynced
    private boolean running;
    private final RangeManager rangeManager = new RangeManager(this, 0x60400040).withCustomExtents(this::buildCustomExtents);

    public TileEntityPressurizedSpawner() {
        super((TileEntityType)ModTileEntities.PRESSURIZED_SPAWNER.get(), 20.0f, 25.0f, 5000, 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        this.rangeManager.setRange(2 + this.getUpgrades(EnumUpgrade.RANGE));
        if (!this.field_145850_b.field_72995_K) {
            ItemSpawnerCore.SpawnerCoreStats stats = this.inventory.getStats();
            this.running = false;
            this.problem = TileEntityVacuumTrap.Problems.OK;
            if (stats == null) {
                this.problem = TileEntityVacuumTrap.Problems.NO_CORE;
            } else if (this.getPressure() > this.getMinWorkingPressure() && this.rsController.shouldRun()) {
                this.running = true;
                if (--this.counter <= 0) {
                    if (!this.trySpawnSomething(stats)) {
                        ((ServerWorld)this.field_145850_b).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)this.field_174879_c.func_177958_n() + 0.5, (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p() + 0.5, 5, 0.0, 0.0, 0.0, 0.0);
                    }
                    this.addAir(-this.getAirUsage());
                    this.counter = this.getSpawnInterval();
                }
            }
        } else if (this.running) {
            double x = (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble();
            double y = (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble();
            double z = (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble();
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197601_L, x, y, z, 0.0, 0.0, 0.0);
            this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private AxisAlignedBB buildCustomExtents() {
        AxisAlignedBB aabb = new AxisAlignedBB(this.func_174877_v(), this.func_174877_v());
        return aabb.func_72314_b((double)this.getRange(), 0.0, (double)this.getRange()).func_72321_a(0.0, 2.0, 0.0).func_72321_a(0.0, -1.0, 0.0);
    }

    private boolean trySpawnSomething(ItemSpawnerCore.SpawnerCoreStats stats) {
        EntityType<?> type = stats.pickEntity(true);
        if (type != null && this.field_145850_b instanceof ServerWorld) {
            double z;
            double y;
            ServerWorld serverworld = (ServerWorld)this.field_145850_b;
            int spawnRange = this.getRange();
            int maxNearbyEntities = 32;
            double x = (double)this.field_174879_c.func_177958_n() + (serverworld.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange + 0.5;
            if (serverworld.func_226664_a_(type.func_220328_a(x, y = (double)(this.field_174879_c.func_177956_o() + serverworld.field_73012_v.nextInt(3) - 1), z = (double)this.field_174879_c.func_177952_p() + (serverworld.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange + 0.5))) {
                MobEntity mobentity;
                Entity entity = type.func_200721_a((World)serverworld);
                if (entity == null) {
                    return false;
                }
                int entityCount = serverworld.func_217357_a(MobEntity.class, this.rangeManager.getExtents()).size();
                if (entityCount >= maxNearbyEntities) {
                    return false;
                }
                entity.func_70012_b(x, y, z, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
                if (entity instanceof MobEntity && !ForgeEventFactory.doSpecialSpawn((MobEntity)(mobentity = (MobEntity)entity), (World)this.field_145850_b, (float)((float)entity.func_226277_ct_()), (float)((float)entity.func_226278_cu_()), (float)((float)entity.func_226281_cx_()), null, (SpawnReason)SpawnReason.SPAWNER)) {
                    mobentity.func_213386_a((IServerWorld)serverworld, this.field_145850_b.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                }
                if (!serverworld.func_242106_g(entity)) {
                    return false;
                }
                this.field_145850_b.func_217379_c(2004, this.field_174879_c, 0);
                if (entity instanceof MobEntity) {
                    ((MobEntity)entity).func_70656_aK();
                }
                return true;
            }
        }
        return false;
    }

    public int getSpawnInterval() {
        return (int)(200.0f / this.getSpeedMultiplierFromUpgrades());
    }

    public int getAirUsage() {
        return 150 * (this.getUpgrades(EnumUpgrade.SPEED) + 1);
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    @Nonnull
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public float getMinWorkingPressure() {
        return 10.0f;
    }

    @Override
    public RedstoneController<TileEntityPressurizedSpawner> getRedstoneController() {
        return this.rsController;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        this.rsController.parseRedstoneMode(tag);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerPressurizedSpawner(windowId, inv, this.func_174877_v());
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_218657_a("Inventory", (INBT)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.inventory.deserializeNBT(tag.func_74775_l("Inventory"));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.rangeManager.shouldShowRange() ? this.rangeManager.getExtents() : super.getRenderBoundingBox();
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }
}

