/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import com.google.common.collect.ImmutableList;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModSounds;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.hacking.secstation.HackSimulation;
import me.desht.pneumaticcraft.common.hacking.secstation.ISimulationController;
import me.desht.pneumaticcraft.common.hacking.secstation.SimulationController;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationHacking;
import me.desht.pneumaticcraft.common.inventory.ContainerSecurityStationMain;
import me.desht.pneumaticcraft.common.inventory.handler.BaseItemStackHandler;
import me.desht.pneumaticcraft.common.item.ItemNetworkComponent;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketPlaySound;
import me.desht.pneumaticcraft.common.tileentity.IRangedTE;
import me.desht.pneumaticcraft.common.tileentity.IRedstoneControl;
import me.desht.pneumaticcraft.common.tileentity.RangeManager;
import me.desht.pneumaticcraft.common.tileentity.RedstoneController;
import me.desht.pneumaticcraft.common.tileentity.TileEntityTickableBase;
import me.desht.pneumaticcraft.common.util.GlobalTileEntityCacheManager;
import me.desht.pneumaticcraft.common.util.ITranslatableEnum;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.concurrent.TickDelayedTask;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.IItemHandler;

public class TileEntitySecurityStation
extends TileEntityTickableBase
implements IRedstoneControl<TileEntitySecurityStation>,
INamedContainerProvider,
IRangedTE {
    private static final List<RedstoneController.RedstoneMode<TileEntitySecurityStation>> REDSTONE_MODES = ImmutableList.of(new RedstoneController.EmittingRedstoneMode<TileEntitySecurityStation>("standard.never", new ItemStack((IItemProvider)Items.field_151016_H), te -> false), new RedstoneController.EmittingRedstoneMode<TileEntitySecurityStation>("securityStation.hacked", EnumUpgrade.SECURITY.getItemStack(), TileEntitySecurityStation::isHacked), new RedstoneController.EmittingRedstoneMode<TileEntitySecurityStation>("securityStation.doneRebooting", new ItemStack((IItemProvider)ModBlocks.SECURITY_STATION.get()), te -> te.getRebootTime() <= 0));
    public static final int INV_ROWS = 7;
    public static final int INV_COLS = 5;
    private static final int INVENTORY_SIZE = 35;
    private final SecurityStationHandler inventory = new SecurityStationHandler();
    private final LazyOptional<IItemHandler> invCap = LazyOptional.of(() -> this.inventory);
    public final List<GameProfile> hackedUsers = new ArrayList<GameProfile>();
    public final List<GameProfile> sharedUsers = new ArrayList<GameProfile>();
    @GuiSynced
    private int rebootTimer;
    @GuiSynced
    public final RedstoneController<TileEntitySecurityStation> rsController = new RedstoneController<TileEntitySecurityStation>(this, REDSTONE_MODES);
    private final RangeManager rangeManager = new RangeManager(this, 0x60FF0000);
    private boolean oldRedstoneStatus;
    private boolean validNetwork;
    private ISimulationController simulationController = null;

    public TileEntitySecurityStation() {
        super((TileEntityType)ModTileEntities.SECURITY_STATION.get(), 4);
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        GlobalTileEntityCacheManager.getInstance().securityStations.remove(this);
    }

    public void func_145829_t() {
        super.func_145829_t();
        GlobalTileEntityCacheManager.getInstance().securityStations.add(this);
    }

    @Override
    public void func_73660_a() {
        if (this.rebootTimer > 0) {
            --this.rebootTimer;
            if (!this.func_145831_w().field_72995_K && this.rebootTimer == 0) {
                this.hackedUsers.clear();
                NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.HUD_ENTITY_LOCK.get(), SoundCategory.BLOCKS, this.func_174877_v(), 1.0f, 1.0f, false), this.func_145831_w(), this.func_174877_v());
            }
        } else if (this.simulationController != null) {
            this.simulationController.tick();
            PlayerEntity hacker = this.simulationController.getHacker();
            if (!(hacker.field_71070_bA instanceof ContainerSecurityStationHacking)) {
                if (this.simulationController.isSimulationDone()) {
                    this.simulationController = null;
                } else if (this.simulationController.getSimulation(ISimulationController.HackingSide.AI).isAwake() && !this.simulationController.isJustTesting()) {
                    this.retaliate(hacker);
                }
                this.simulationController = null;
            }
        }
        if (this.oldRedstoneStatus != this.rsController.shouldEmit()) {
            this.oldRedstoneStatus = this.rsController.shouldEmit();
            this.updateNeighbours();
        }
        this.rangeManager.setRange(Math.min(2 + this.getUpgrades(EnumUpgrade.RANGE), 16));
        super.func_73660_a();
    }

    public void rebootStation() {
        this.rebootTimer = 1200;
        NetworkHandler.sendToAllTracking(new PacketPlaySound((SoundEvent)ModSounds.MINIGUN_STOP.get(), SoundCategory.BLOCKS, this.func_174877_v(), 1.0f, 1.0f, false), this.func_145831_w(), this.func_174877_v());
    }

    public int getRebootTime() {
        return this.rebootTimer;
    }

    @Override
    protected LazyOptional<IItemHandler> getInventoryCap() {
        return this.invCap;
    }

    @Override
    public void handleGUIButtonPress(String tag, boolean shiftHeld, ServerPlayerEntity player) {
        if (this.rsController.parseRedstoneMode(tag)) {
            return;
        }
        if (player.field_71070_bA instanceof ContainerSecurityStationMain && this.isPlayerOnWhiteList((PlayerEntity)player)) {
            if (tag.equals("reboot")) {
                this.rebootStation();
            } else if (tag.equals("test")) {
                if (this.hasValidNetwork()) {
                    this.initiateHacking((PlayerEntity)player);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("pneumaticcraft.message.securityStation.outOfOrder"), false);
                }
            } else if (tag.startsWith("remove:")) {
                String name = tag.split(":", 2)[1];
                this.removeTrustedUser(name);
            } else if (tag.startsWith("add:")) {
                String name = tag.split(":", 2)[1];
                this.addTrustedUser(new GameProfile(null, name));
            }
        } else if (player.field_71070_bA instanceof ContainerSecurityStationHacking && this.isPlayerHacking((PlayerEntity)player)) {
            if (tag.equals("end_test") && this.simulationController.isJustTesting()) {
                NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)this, (BlockPos)this.func_174877_v());
            } else if (tag.startsWith("nuke:")) {
                this.tryNukeVirus(tag, (PlayerEntity)player);
            } else if (tag.equals("stop_worm")) {
                this.tryStopWorm((PlayerEntity)player);
            } else if (tag.startsWith("fortify:")) {
                this.tryFortify(tag, (PlayerEntity)player);
            } else if (tag.startsWith("hack:")) {
                this.tryHack(tag, (PlayerEntity)player);
            }
        }
        this.sendDescriptionPacket();
    }

    private boolean isPlayerHacking(PlayerEntity player) {
        return this.simulationController != null && this.simulationController.getHacker().func_70089_S() && this.simulationController.getHacker().equals((Object)player);
    }

    private void tryHack(String tag, PlayerEntity player) {
        try {
            int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
            HackSimulation playerSim = this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER);
            HackSimulation.Node node = playerSim.getNodeAt(nodePos);
            if (node != null && !node.isHacked() && playerSim.getHackedNeighbour(nodePos) >= 0) {
                this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).startHack(nodePos);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ %s: ignoring bad message %s from %s", PneumaticCraftUtils.posToString(this.field_174879_c), tag, player.func_146103_bH().getName());
        }
    }

    private void tryFortify(String tag, PlayerEntity player) {
        try {
            int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
            HackSimulation.Node node = this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).getNodeAt(nodePos);
            if (node != null && node.isHacked()) {
                this.simulationController.getSimulation(ISimulationController.HackingSide.AI).fortify(nodePos);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ %s: ignoring bad message %s from %s", PneumaticCraftUtils.posToString(this.field_174879_c), tag, player.func_146103_bH().getName());
        }
    }

    private void tryStopWorm(PlayerEntity player) {
        if (!this.simulationController.getSimulation(ISimulationController.HackingSide.AI).isStopWormed()) {
            if (PneumaticCraftUtils.consumeInventoryItem(player.field_71071_by, (Item)ModItems.STOP_WORM.get())) {
                int r = 80 + this.func_145831_w().field_73012_v.nextInt(40);
                this.simulationController.getSimulation(ISimulationController.HackingSide.AI).applyStopWorm(r);
            } else {
                player.func_70097_a(DamageSource.field_76380_i, 10000.0f);
            }
        }
    }

    private void tryNukeVirus(String tag, PlayerEntity player) {
        try {
            if (PneumaticCraftUtils.consumeInventoryItem(player.field_71071_by, (Item)ModItems.NUKE_VIRUS.get())) {
                int nodePos = Integer.parseInt(tag.split(":", 2)[1]);
                this.simulationController.getSimulation(ISimulationController.HackingSide.PLAYER).initiateNukeVirus(nodePos);
            } else {
                player.func_70097_a(DamageSource.field_76380_i, 10000.0f);
            }
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException e) {
            Log.warning("security station @ %s: ignoring bad message %s from %s", PneumaticCraftUtils.posToString(this.field_174879_c), tag, player.func_146103_bH().getName());
        }
    }

    public HackingContainerProvider getHackingContainerProvider() {
        return new HackingContainerProvider();
    }

    public void addTrustedUser(GameProfile user) {
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.sharedUsers.add(user);
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    private void removeTrustedUser(String name) {
        this.sharedUsers.removeIf(prof -> name.equals(prof.getName()));
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    public void addHacker(GameProfile user) {
        for (GameProfile hackedUser : this.hackedUsers) {
            if (!this.gameProfileEquals(hackedUser, user)) continue;
            return;
        }
        for (GameProfile sharedUser : this.sharedUsers) {
            if (!this.gameProfileEquals(sharedUser, user)) continue;
            return;
        }
        this.hackedUsers.add(user);
        if (!this.field_145850_b.field_72995_K) {
            this.sendDescriptionPacket();
        }
    }

    private boolean gameProfileEquals(GameProfile profile1, GameProfile profile2) {
        return profile1.getId() != null && profile2.getId() != null ? profile1.getId().equals(profile2.getId()) : profile1.getName().equals(profile2.getName());
    }

    public boolean isHacked() {
        return !this.hackedUsers.isEmpty();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return this.rangeManager.shouldShowRange() ? this.getSecurityCoverage() : super.getRenderBoundingBox();
    }

    public AxisAlignedBB getSecurityCoverage() {
        return this.rangeManager.getExtents();
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.rebootTimer = tag.func_74762_e("startupTimer");
        this.inventory.deserializeNBT(tag.func_74775_l("Items"));
        this.checkForNetworkValidity();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("startupTimer", this.rebootTimer);
        tag.func_218657_a("Items", (INBT)this.inventory.serializeNBT());
        return tag;
    }

    @Override
    public void writeToPacket(CompoundNBT tag) {
        super.writeToPacket(tag);
        tag.func_218657_a("SharedUsers", (INBT)this.toNBTList(this.sharedUsers));
        tag.func_218657_a("HackedUsers", (INBT)this.toNBTList(this.hackedUsers));
    }

    @Override
    public void readFromPacket(CompoundNBT tag) {
        super.readFromPacket(tag);
        this.sharedUsers.clear();
        this.sharedUsers.addAll(this.fromNBTList(tag.func_150295_c("SharedUsers", 10)));
        this.hackedUsers.clear();
        this.hackedUsers.addAll(this.fromNBTList(tag.func_150295_c("HackedUsers", 10)));
    }

    private ListNBT toNBTList(Collection<GameProfile> profiles) {
        ListNBT res = new ListNBT();
        for (GameProfile profile : profiles) {
            CompoundNBT tagCompound = new CompoundNBT();
            tagCompound.func_74778_a("name", profile.getName());
            if (profile.getId() != null) {
                tagCompound.func_74778_a("uuid", profile.getId().toString());
            }
            res.add((Object)tagCompound);
        }
        return res;
    }

    private Collection<GameProfile> fromNBTList(ListNBT list) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT tagCompound = list.func_150305_b(i);
            builder.add((Object)new GameProfile(tagCompound.func_74764_b("uuid") ? UUID.fromString(tagCompound.func_74779_i("uuid")) : null, tagCompound.func_74779_i("name")));
        }
        return builder.build();
    }

    public boolean doesAllowPlayer(PlayerEntity player) {
        return this.rebootTimer > 0 || this.isPlayerOnWhiteList(player) || this.hasPlayerHacked(player);
    }

    public boolean isPlayerOnWhiteList(PlayerEntity player) {
        for (int i = 0; i < this.sharedUsers.size(); ++i) {
            GameProfile user = this.sharedUsers.get(i);
            if (!this.gameProfileEquals(user, player.func_146103_bH())) continue;
            if (user.getId() == null && player.func_146103_bH().getId() != null) {
                this.sharedUsers.set(i, player.func_146103_bH());
                Log.info("Legacy conversion: Security Station shared username '" + player.func_200200_C_().getString() + "' is now using UUID '" + player.func_146103_bH().getId() + "'.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean hasPlayerHacked(PlayerEntity player) {
        for (int i = 0; i < this.hackedUsers.size(); ++i) {
            GameProfile user = this.hackedUsers.get(i);
            if (!this.gameProfileEquals(user, player.func_146103_bH())) continue;
            if (user.getId() == null && player.func_146103_bH().getId() != null) {
                this.hackedUsers.set(i, player.func_146103_bH());
                Log.info("Legacy conversion: Security Station hacked username '" + player.func_200200_C_().getString() + "' is now using UUID '" + player.func_146103_bH().getId() + "'.", new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean connects(int firstSlot, int secondSlot) {
        if (firstSlot < 0 || secondSlot < 0 || firstSlot >= 35 || secondSlot >= 35 || firstSlot == secondSlot || this.inventory.getStackInSlot(firstSlot).func_190926_b() || this.inventory.getStackInSlot(secondSlot).func_190926_b()) {
            return false;
        }
        for (int column = -1; column <= 1; ++column) {
            for (int row = -1; row <= 1; ++row) {
                if (firstSlot + row * 5 + column != secondSlot || !(firstSlot % 5 > 0 && firstSlot % 5 < 4 || secondSlot % 5 > 0 && secondSlot % 5 < 4) && secondSlot % 5 != firstSlot % 5) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasValidNetwork() {
        return this.validNetwork;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new ContainerSecurityStationMain(i, playerInventory, this.func_174877_v());
    }

    public void initiateHacking(PlayerEntity hacker) {
        if (this.simulationController != null) {
            hacker.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.hackInProgress", new Object[0]).func_240699_a_(TextFormatting.GOLD), false);
        } else {
            this.simulationController = new SimulationController(this, hacker, this.isPlayerOnWhiteList(hacker));
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)hacker), (INamedContainerProvider)this.getHackingContainerProvider(), buf -> this.simulationController.toBytes((PacketBuffer)buf));
        }
    }

    public int findComponent(ItemNetworkComponent.NetworkComponentType type) {
        for (int i = 0; i < 35; ++i) {
            if (ItemNetworkComponent.getType(this.inventory.getStackInSlot(i)) != type) continue;
            return i;
        }
        return -1;
    }

    public ISimulationController getSimulationController() {
        return this.simulationController;
    }

    public void setSimulationController(ISimulationController newController) {
        this.simulationController = newController;
    }

    public void retaliate(PlayerEntity hacker) {
        hacker.func_70097_a(DamageSource.field_76380_i, hacker.func_110138_aP() - 0.5f);
        hacker.func_195064_c(new EffectInstance(Effects.field_76431_k, 100));
        hacker.func_195064_c(new EffectInstance(Effects.field_76440_q, 200));
        hacker.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 3));
    }

    @Override
    public RangeManager getRangeManager() {
        return this.rangeManager;
    }

    public EnumNetworkValidityProblem checkForNetworkValidity() {
        this.validNetwork = false;
        int ioPortSlot = -1;
        int registrySlot = -1;
        int subroutineSlot = -1;
        block5: for (int i = 0; i < 35; ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ItemNetworkComponent.NetworkComponentType type = ItemNetworkComponent.getType(this.inventory.getStackInSlot(i));
            assert (type != null);
            switch (type) {
                case DIAGNOSTIC_SUBROUTINE: {
                    if (subroutineSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_SUBROUTINES;
                    }
                    subroutineSlot = i;
                    continue block5;
                }
                case NETWORK_IO_PORT: {
                    if (ioPortSlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_IO_PORTS;
                    }
                    ioPortSlot = i;
                    continue block5;
                }
                case NETWORK_REGISTRY: {
                    if (registrySlot != -1) {
                        return EnumNetworkValidityProblem.TOO_MANY_REGISTRIES;
                    }
                    registrySlot = i;
                }
            }
        }
        if (subroutineSlot == -1) {
            return EnumNetworkValidityProblem.NO_SUBROUTINE;
        }
        if (ioPortSlot == -1) {
            return EnumNetworkValidityProblem.NO_IO_PORT;
        }
        if (registrySlot == -1) {
            return EnumNetworkValidityProblem.NO_REGISTRY;
        }
        if (!this.traceComponent(subroutineSlot, ioPortSlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_SUB_AND_IO_PORT;
        }
        if (!this.traceComponent(ioPortSlot, registrySlot, new boolean[35])) {
            return EnumNetworkValidityProblem.NO_CONNECTION_IO_PORT_AND_REGISTRY;
        }
        this.validNetwork = true;
        return EnumNetworkValidityProblem.NONE;
    }

    private boolean traceComponent(int startSlot, int targetSlot, boolean[] slotsDone) {
        for (int i = 0; i < 35; ++i) {
            if (slotsDone[i] || !this.connects(startSlot, i)) continue;
            if (i == targetSlot) {
                return true;
            }
            slotsDone[i] = true;
            if (!this.traceComponent(i, targetSlot, slotsDone)) continue;
            return true;
        }
        return false;
    }

    public int getDetectionChance() {
        double n = 1.0 - Math.pow(0.7, this.getUpgrades(EnumUpgrade.ENTITY_TRACKER) + 1);
        return MathHelper.func_76125_a((int)((int)(n * 100.0)), (int)0, (int)100);
    }

    public int getSecurityLevel() {
        return Math.min(64, 1 + this.getUpgrades(EnumUpgrade.SECURITY));
    }

    @Override
    public boolean isGuiUseableByPlayer(PlayerEntity par1EntityPlayer) {
        return this.func_145831_w().func_175625_s(this.func_174877_v()) == this;
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return this.inventory;
    }

    @Override
    public RedstoneController<TileEntitySecurityStation> getRedstoneController() {
        return this.rsController;
    }

    public static int getProtectingSecurityStations(PlayerEntity player, BlockPos pos, boolean isPlacingSecurityStation) {
        return (int)TileEntitySecurityStation.getSecurityStations(player.func_130014_f_(), pos, isPlacingSecurityStation).filter(teSS -> !teSS.doesAllowPlayer(player)).count();
    }

    public static boolean isProtectedFromPlayer(PlayerEntity player, BlockPos pos, boolean isPlacingSecurityStation) {
        return TileEntitySecurityStation.getSecurityStations(player.func_130014_f_(), pos, isPlacingSecurityStation).anyMatch(teSS -> !teSS.doesAllowPlayer(player));
    }

    static Stream<TileEntitySecurityStation> getSecurityStations(World world, BlockPos pos, boolean isPlacingSecurityStation) {
        return GlobalTileEntityCacheManager.getInstance().securityStations.stream().filter(station -> TileEntitySecurityStation.isValidAndInRange(world, pos, isPlacingSecurityStation, station));
    }

    private static boolean isValidAndInRange(World world, BlockPos pos, boolean isPlacingSecurityStation, TileEntitySecurityStation teSS) {
        if (!teSS.func_145837_r() && teSS.func_145831_w().func_234923_W_().compareTo(world.func_234923_W_()) == 0 && teSS.hasValidNetwork()) {
            AxisAlignedBB aabb = teSS.getSecurityCoverage();
            if (isPlacingSecurityStation) {
                aabb = aabb.func_186662_g(16.0);
            }
            return aabb.field_72340_a <= (double)pos.func_177958_n() && aabb.field_72336_d >= (double)pos.func_177958_n() && aabb.field_72338_b <= (double)pos.func_177956_o() && aabb.field_72337_e >= (double)pos.func_177956_o() && aabb.field_72339_c <= (double)pos.func_177952_p() && aabb.field_72334_f >= (double)pos.func_177952_p();
        }
        return false;
    }

    private static boolean isPlayerExempt(PlayerEntity player) {
        return player.func_184812_l_() || player.func_146103_bH().getId() != null && player.func_195051_bN().func_197034_c(2);
    }

    @Mod.EventBusSubscriber(modid="pneumaticcraft")
    public static class Listener {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onPlayerInteract(PlayerInteractEvent event) {
            if (event instanceof PlayerInteractEvent.RightClickEmpty || event.getWorld().field_72995_K) {
                return;
            }
            PlayerEntity player = event.getPlayer();
            if (TileEntitySecurityStation.isPlayerExempt(player)) {
                return;
            }
            ItemStack heldItem = player.func_184586_b(event.getHand());
            BlockState interactedBlockState = event.getWorld().func_180495_p(event.getPos());
            Block interactedBlock = interactedBlockState.func_177230_c();
            if (interactedBlock != ModBlocks.SECURITY_STATION.get() || event instanceof PlayerInteractEvent.LeftClickBlock) {
                boolean tryingToPlaceSecurityStation;
                boolean bl = tryingToPlaceSecurityStation = heldItem.func_77973_b() instanceof BlockItem && ((BlockItem)heldItem.func_77973_b()).func_179223_d() == ModBlocks.SECURITY_STATION.get();
                if (TileEntitySecurityStation.isProtectedFromPlayer(player, event.getPos(), tryingToPlaceSecurityStation)) {
                    event.setCanceled(true);
                    player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate(tryingToPlaceSecurityStation ? "pneumaticcraft.message.securityStation.stationPlacementPrevented" : "pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).func_240699_a_(TextFormatting.RED), true);
                    if (player instanceof ServerPlayerEntity && heldItem.func_77973_b() instanceof BlockItem) {
                        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-2, player.field_71071_by.field_70461_c, heldItem));
                    }
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
            PlayerEntity player;
            if (event.getEntity() instanceof PlayerEntity && !event.getWorld().func_201670_d() && !TileEntitySecurityStation.isPlayerExempt(player = (PlayerEntity)event.getEntity())) {
                if (event instanceof BlockEvent.EntityMultiPlaceEvent) {
                    for (BlockSnapshot snapshot : ((BlockEvent.EntityMultiPlaceEvent)event).getReplacedBlockSnapshots()) {
                        if (!Listener.isPlacementPrevented(event, player, snapshot.getPos())) continue;
                        return;
                    }
                } else {
                    Listener.isPlacementPrevented(event, player, event.getPos());
                }
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            PlayerEntity player = event.getPlayer();
            if (!TileEntitySecurityStation.isPlayerExempt(player) && TileEntitySecurityStation.isProtectedFromPlayer(player, event.getPos(), false)) {
                event.setCanceled(true);
                player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).func_240699_a_(TextFormatting.RED), true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onBlockExplode(ExplosionEvent event) {
            PlayerEntity player = Listener.getPlayerForExplosion(event);
            if (player != null && !TileEntitySecurityStation.isPlayerExempt(player) && event.getWorld() != null && !event.getWorld().field_72995_K) {
                event.getExplosion().func_180343_e().removeIf(pos -> TileEntitySecurityStation.isProtectedFromPlayer(player, pos, false));
            }
        }

        private static boolean isPlacementPrevented(BlockEvent.EntityPlaceEvent event, PlayerEntity player, BlockPos pos) {
            boolean tryingToPlaceSecurityStation;
            boolean bl = tryingToPlaceSecurityStation = event.getPlacedBlock().func_177230_c() == ModBlocks.SECURITY_STATION.get();
            if (TileEntitySecurityStation.isProtectedFromPlayer(player, pos, tryingToPlaceSecurityStation)) {
                event.setCanceled(true);
                player.func_146105_b((ITextComponent)PneumaticCraftUtils.xlate(tryingToPlaceSecurityStation ? "pneumaticcraft.message.securityStation.stationPlacementPrevented" : "pneumaticcraft.message.securityStation.accessPrevented", new Object[0]).func_240699_a_(TextFormatting.RED), true);
                return true;
            }
            return false;
        }

        private static PlayerEntity getPlayerForExplosion(ExplosionEvent event) {
            LivingEntity entity = event.getExplosion().func_94613_c();
            return entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
        }

        @SubscribeEvent
        public static void onContainerClose(PlayerContainerEvent.Close event) {
            ServerPlayerEntity player;
            TileEntitySecurityStation teSS;
            if (event.getPlayer() instanceof ServerPlayerEntity && event.getContainer() instanceof ContainerSecurityStationHacking && (teSS = (TileEntitySecurityStation)((ContainerSecurityStationHacking)event.getContainer()).te).getSimulationController() != null && teSS.getSimulationController().isJustTesting() && (player = (ServerPlayerEntity)event.getPlayer()).func_184102_h() != null) {
                player.func_184102_h().func_212871_a_((Runnable)new TickDelayedTask(1, () -> NetworkHooks.openGui((ServerPlayerEntity)player, (INamedContainerProvider)teSS, (BlockPos)teSS.func_174877_v())));
            }
        }
    }

    private class HackingContainerProvider
    implements INamedContainerProvider {
        private HackingContainerProvider() {
        }

        public ITextComponent func_145748_c_() {
            return TileEntitySecurityStation.this.func_200200_C_().func_230531_f_().func_240702_b_(" ").func_230529_a_((ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.hacking", new Object[0]));
        }

        @Nullable
        public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
            return new ContainerSecurityStationHacking(windowId, playerInventory, TileEntitySecurityStation.this.func_174877_v());
        }
    }

    private class SecurityStationHandler
    extends BaseItemStackHandler {
        private SecurityStationHandler() {
            super(TileEntitySecurityStation.this, 35);
        }

        @Override
        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntitySecurityStation.this.checkForNetworkValidity();
        }
    }

    public static enum EnumNetworkValidityProblem implements ITranslatableEnum
    {
        NONE,
        NO_SUBROUTINE,
        NO_IO_PORT,
        NO_REGISTRY,
        TOO_MANY_SUBROUTINES,
        TOO_MANY_IO_PORTS,
        TOO_MANY_REGISTRIES,
        NO_CONNECTION_SUB_AND_IO_PORT,
        NO_CONNECTION_IO_PORT_AND_REGISTRY;


        @Override
        public String getTranslationKey() {
            return "pneumaticcraft.gui.tab.problems.security_station." + this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

