/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tileentity;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import me.desht.pneumaticcraft.common.block.BlockEmptySpawner;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.core.ModTileEntities;
import me.desht.pneumaticcraft.common.inventory.ContainerSpawnerExtractor;
import me.desht.pneumaticcraft.common.item.ItemSpawnerCore;
import me.desht.pneumaticcraft.common.network.DescSynced;
import me.desht.pneumaticcraft.common.network.GuiSynced;
import me.desht.pneumaticcraft.common.tileentity.IMinWorkingPressure;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPneumaticBase;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SpawnerBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.MobSpawnerTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.AbstractSpawner;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;

public class TileEntitySpawnerExtractor
extends TileEntityPneumaticBase
implements IMinWorkingPressure,
INamedContainerProvider {
    private static final int MAX_ENTITY_RANGE = 6;
    private Entity cachedEntity;
    @DescSynced
    private Mode mode = Mode.INIT;
    @DescSynced
    private float targetSpeed;
    private float rotationDegrees;
    private float prevRotationDegrees;
    @GuiSynced
    private float progress;
    private float currentSpeed;
    private int spawnFailures;

    public TileEntitySpawnerExtractor() {
        super((TileEntityType)ModTileEntities.SPAWNER_EXTRACTOR.get(), 5.0f, 7.0f, 4000, 4);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (Math.abs(this.currentSpeed - this.targetSpeed) < 0.015f) {
            this.currentSpeed = this.targetSpeed;
        } else if (this.currentSpeed < this.targetSpeed) {
            this.currentSpeed += Math.max(0.005f, (this.targetSpeed - this.currentSpeed) / 20.0f);
        } else if (this.currentSpeed > this.targetSpeed) {
            this.currentSpeed -= Math.max(0.01f, (this.targetSpeed - this.currentSpeed) / 10.0f);
        }
        if (this.mode == Mode.INIT) {
            this.updateMode();
        }
        switch (this.mode) {
            case RUNNING: {
                float incr = this.currentSpeed / 1200.0f;
                this.progress = Math.min(1.0f, this.progress + incr);
                break;
            }
            case FINISHED: {
                this.progress = 1.0f;
                this.targetSpeed = 0.0f;
                this.rotationDegrees = this.prevRotationDegrees;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            int defenderChance;
            int n = defenderChance = this.field_145850_b.func_175659_aa() == Difficulty.EASY ? 40 : 20;
            if (this.mode == Mode.RUNNING) {
                this.addAir(1);
                if (this.progress >= 1.0f) {
                    this.extractSpawnerCore();
                } else if (this.currentSpeed > 0.1f && this.field_145850_b.field_73012_v.nextInt(defenderChance) == 0) {
                    PneumaticCraftUtils.getTileEntityAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b(), MobSpawnerTileEntity.class).ifPresent(te -> {
                        if (!this.trySpawnDefender((MobSpawnerTileEntity)te)) {
                            ++this.spawnFailures;
                        }
                    });
                }
            }
            if ((this.field_145850_b.func_82737_E() & 0xFL) == 3L) {
                this.targetSpeed = this.getTargetSpeed();
            }
            if ((this.field_145850_b.func_82737_E() & 0x3FL) == 3L) {
                this.spawnFailures = Math.max(0, this.spawnFailures - 1);
            }
        } else {
            this.prevRotationDegrees = this.rotationDegrees;
            this.rotationDegrees += this.currentSpeed * 18.0f;
        }
    }

    private boolean trySpawnDefender(MobSpawnerTileEntity te) {
        double z;
        AbstractSpawner spawner = te.func_145881_a();
        int spawnRange = 4;
        int maxNearbyEntities = 16;
        CompoundNBT nbt = spawner.field_98282_f.func_185277_b();
        Optional optional = EntityType.func_220347_a((CompoundNBT)nbt);
        if (!optional.isPresent()) {
            return false;
        }
        BlockPos pos = te.func_174877_v();
        ListNBT listnbt = nbt.func_150295_c("Pos", 6);
        int size = listnbt.size();
        double x = size >= 1 ? listnbt.func_150309_d(0) : (double)pos.func_177958_n() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange + 0.5;
        double y = size >= 2 ? listnbt.func_150309_d(1) : (double)(pos.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(3) - 1);
        double d = z = size >= 3 ? listnbt.func_150309_d(2) : (double)pos.func_177952_p() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * (double)spawnRange + 0.5;
        if (this.field_145850_b.func_226664_a_(((EntityType)optional.get()).func_220328_a(x, y, z))) {
            ServerWorld serverworld = (ServerWorld)this.field_145850_b;
            Entity entity = EntityType.func_220335_a((CompoundNBT)nbt, (World)this.field_145850_b, e1 -> {
                e1.func_70012_b(x, y, z, e1.field_70177_z, e1.field_70125_A);
                return e1;
            });
            if (entity == null) {
                return false;
            }
            int entityCount = this.field_145850_b.func_217357_a(entity.getClass(), new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 1), (double)(pos.func_177952_p() + 1)).func_186662_g((double)spawnRange)).size();
            if (entityCount >= maxNearbyEntities) {
                return false;
            }
            entity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (entity instanceof MobEntity) {
                MobEntity mobentity = (MobEntity)entity;
                if (spawner.field_98282_f.func_185277_b().func_186856_d() == 1 && spawner.field_98282_f.func_185277_b().func_150297_b("id", 8) && !ForgeEventFactory.doSpecialSpawn((MobEntity)mobentity, (World)this.field_145850_b, (float)((float)entity.func_226277_ct_()), (float)((float)entity.func_226278_cu_()), (float)((float)entity.func_226281_cx_()), (AbstractSpawner)spawner, (SpawnReason)SpawnReason.SPAWNER)) {
                    mobentity.func_213386_a((IServerWorld)serverworld, this.field_145850_b.func_175649_E(entity.func_233580_cy_()), SpawnReason.SPAWNER, null, null);
                    if (this.field_145850_b.func_175659_aa() == Difficulty.HARD) {
                        this.getRandomEffects(this.field_145850_b.field_73012_v).forEach(effect -> mobentity.func_195064_c(new EffectInstance(effect, Integer.MAX_VALUE, 2)));
                    }
                }
            }
            if (!serverworld.func_242106_g(entity)) {
                return false;
            }
            this.field_145850_b.func_217379_c(2004, pos, 0);
            if (entity instanceof MobEntity) {
                ((MobEntity)entity).func_70656_aK();
            }
        }
        return true;
    }

    private List<Effect> getRandomEffects(Random rand) {
        ArrayList<Effect> l = new ArrayList<Effect>();
        int n = rand.nextInt(100);
        if (n > 50) {
            l.add(Effects.field_76426_n);
        }
        if (n > 75) {
            l.add(Effects.field_76424_c);
        }
        if (n > 82) {
            l.add(Effects.field_76420_g);
        }
        if (n > 92) {
            l.add(Effects.field_76428_l);
        }
        if (n > 96) {
            l.add(Effects.field_76441_p);
        }
        return l;
    }

    private void extractSpawnerCore() {
        PneumaticCraftUtils.getTileEntityAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b(), MobSpawnerTileEntity.class).ifPresent(te -> {
            ItemStack spawnerCore = new ItemStack((IItemProvider)ModItems.SPAWNER_CORE.get());
            ItemSpawnerCore.SpawnerCoreStats stats = ItemSpawnerCore.SpawnerCoreStats.forItemStack(spawnerCore);
            Entity e = this.getCachedEntity((MobSpawnerTileEntity)te);
            if (e != null && stats != null) {
                stats.addAmount(e.func_200600_R(), 100);
                stats.serialize(spawnerCore);
                ItemEntity item = new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5);
                item.func_92058_a(spawnerCore);
                this.field_145850_b.func_217376_c((Entity)item);
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 0.5f);
                this.field_145850_b.func_180501_a(this.field_174879_c.func_177977_b(), ((BlockEmptySpawner)ModBlocks.EMPTY_SPAWNER.get()).func_176223_P(), 3);
                this.field_145850_b.func_217379_c(2001, this.field_174879_c, Block.func_196246_j((BlockState)Blocks.field_150474_ac.func_176223_P()));
            }
        });
    }

    private float getTargetSpeed() {
        if (this.getPressure() > this.getMinWorkingPressure()) {
            return 0.0f;
        }
        return PneumaticCraftUtils.getTileEntityAt((IBlockReader)this.field_145850_b, this.field_174879_c.func_177977_b(), MobSpawnerTileEntity.class).map(te -> {
            int players = 0;
            int matches = 0;
            Entity e0 = this.getCachedEntity((MobSpawnerTileEntity)te);
            if (e0 == null) {
                return Float.valueOf(0.0f);
            }
            List l = this.field_145850_b.func_175647_a(LivingEntity.class, new AxisAlignedBB(this.field_174879_c).func_186662_g(6.0), e -> true);
            for (LivingEntity e2 : l) {
                if (e2 instanceof PlayerEntity && !(e2 instanceof FakePlayer)) {
                    ++players;
                }
                if (e2.func_200600_R() != e0.func_200600_R()) continue;
                ++matches;
            }
            int n = players > 0 ? Math.min(10, matches + this.spawnFailures) : 10;
            return Float.valueOf(1.0f - (float)n / 10.0f);
        }).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public Entity getCachedEntity(MobSpawnerTileEntity te) {
        if (this.cachedEntity == null) {
            this.cachedEntity = EntityType.func_220335_a((CompoundNBT)te.func_145881_a().field_98282_f.func_185277_b(), (World)this.func_145831_w(), Function.identity());
        }
        return this.cachedEntity;
    }

    public float getRotationDegrees() {
        return this.rotationDegrees;
    }

    public float getPrevRotationDegrees() {
        return this.prevRotationDegrees;
    }

    public float getProgress() {
        return this.progress;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74776_a("progress", this.progress);
        tag.func_74774_a("mode", (byte)this.mode.ordinal());
        tag.func_74776_a("targetSpeed", this.targetSpeed);
        tag.func_74768_a("spawnFailures", this.spawnFailures);
        return tag;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tag) {
        super.func_230337_a_(state, tag);
        this.progress = tag.func_74760_g("progress");
        this.mode = Mode.values()[tag.func_74771_c("mode")];
        this.targetSpeed = tag.func_74760_g("targetSpeed");
        this.spawnFailures = tag.func_74762_e("spawnFailures");
    }

    @Override
    public IItemHandler getPrimaryInventory() {
        return null;
    }

    @Override
    public boolean canConnectPneumatic(Direction side) {
        return side.func_176740_k().func_176722_c();
    }

    @Override
    public float getMinWorkingPressure() {
        return this.mode == Mode.RUNNING ? -0.5f : 0.0f;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inv, PlayerEntity player) {
        return new ContainerSpawnerExtractor(windowId, inv, this.field_174879_c);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (double)(this.field_174879_c.func_177958_n() + 1), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 1));
    }

    public void updateMode() {
        BlockState below = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        this.mode = below.func_177230_c() instanceof SpawnerBlock ? Mode.RUNNING : Mode.FINISHED;
    }

    public static enum Mode {
        INIT,
        RUNNING,
        FINISHED;

    }
}

