/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAerialInterface;
import me.desht.pneumaticcraft.common.tileentity.TileEntityChargingStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.tileentity.TileEntityUniversalSensor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.thread.EffectiveSide;

@Mod.EventBusSubscriber(modid="pneumaticcraft")
public class GlobalTileEntityCacheManager {
    private static final GlobalTileEntityCacheManager CLIENT_INSTANCE = new GlobalTileEntityCacheManager();
    private static final GlobalTileEntityCacheManager SERVER_INSTANCE = new GlobalTileEntityCacheManager();
    public final GlobalTileEntityCache<TileEntityUniversalSensor> universalSensors = new GlobalTileEntityCache();
    public final GlobalTileEntityCache<TileEntityChargingStation> chargingStations = new GlobalTileEntityCache();
    public final GlobalTileEntityCache<TileEntitySecurityStation> securityStations = new GlobalTileEntityCache();
    public final GlobalTileEntityCache<TileEntityAerialInterface> aerialInterfaces = new GlobalTileEntityCache();

    public static GlobalTileEntityCacheManager getInstance() {
        return EffectiveSide.get() == LogicalSide.CLIENT ? CLIENT_INSTANCE : SERVER_INSTANCE;
    }

    @SubscribeEvent
    public static void onWorldUnloaded(WorldEvent.Unload event) {
        GlobalTileEntityCacheManager.getInstance().removeFromWorld(event.getWorld());
    }

    private void removeFromWorld(IWorld world) {
        this.universalSensors.removeFromWorld(world);
        this.chargingStations.removeFromWorld(world);
        this.securityStations.removeFromWorld(world);
        this.aerialInterfaces.removeFromWorld(world);
    }

    public static class GlobalTileEntityCache<T extends TileEntity>
    implements Iterable<T> {
        private final Set<T> tileEntities = Collections.newSetFromMap(new WeakHashMap());

        public void add(T te) {
            this.tileEntities.add(te);
        }

        public void remove(T te) {
            this.tileEntities.remove(te);
        }

        public void removeFromWorld(IWorld world) {
            this.tileEntities.removeIf(te -> te.func_145831_w() == world);
        }

        public Stream<T> stream() {
            return this.tileEntities.stream();
        }

        @Override
        public Iterator<T> iterator() {
            return this.tileEntities.iterator();
        }
    }
}

