/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.variables;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.progwidgets.IVariableProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.thread.EffectiveSide;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class GlobalVariableManager
extends WorldSavedData
implements IVariableProvider {
    public static final int MAX_VARIABLE_LEN = 64;
    private static final String DATA_KEY = "PneumaticCraftGlobalVariables";
    private static final GlobalVariableManager CLIENT_INSTANCE = new GlobalVariableManager();
    private final Map<String, BlockPos> globalVars = new HashMap<String, BlockPos>();
    private final Map<String, ItemStack> globalItemVars = new HashMap<String, ItemStack>();
    private static ServerWorld overworld;

    public static GlobalVariableManager getInstance() {
        if (EffectiveSide.get() == LogicalSide.CLIENT) {
            return CLIENT_INSTANCE;
        }
        return (GlobalVariableManager)GlobalVariableManager.getOverworld().func_217481_x().func_215752_a(GlobalVariableManager::new, DATA_KEY);
    }

    private GlobalVariableManager() {
        super(DATA_KEY);
    }

    private static ServerWorld getOverworld() {
        if (overworld == null && (overworld = ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_)) == null) {
            throw new IllegalStateException("Overworld not initialized!");
        }
        return overworld;
    }

    public void set(String varName, boolean value) {
        this.set(varName, value ? 1 : 0);
    }

    public void set(String varName, int value) {
        this.set(varName, value, 0, 0);
    }

    public void set(String varName, int x, int y, int z) {
        this.set(varName, new BlockPos(x, y, z));
    }

    public void set(String varName, BlockPos pos) {
        this.globalVars.put(varName, pos);
        this.func_76185_a();
    }

    public void set(String varName, ItemStack item) {
        this.globalItemVars.put(varName, item);
        this.func_76185_a();
    }

    public boolean getBoolean(String varName) {
        return this.getInteger(varName) != 0;
    }

    public int getInteger(String varName) {
        return this.getPos(varName).func_177958_n();
    }

    public boolean hasPos(String varName) {
        return this.globalVars.containsKey(varName);
    }

    public boolean hasItem(String varName) {
        return this.globalItemVars.containsKey(varName);
    }

    public BlockPos getPos(String varName) {
        return this.globalVars.getOrDefault(varName, BlockPos.field_177992_a);
    }

    public ItemStack getItem(String varName) {
        return this.globalItemVars.getOrDefault(varName, ItemStack.field_190927_a);
    }

    public void func_76184_a(CompoundNBT tag) {
        this.globalVars.clear();
        ListNBT list = tag.func_150295_c("globalVars", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT t = list.func_150305_b(i);
            this.globalVars.put(t.func_74779_i("varName"), new BlockPos(t.func_74762_e("x"), t.func_74762_e("y"), t.func_74762_e("z")));
        }
        GlobalVariableManager.readItemVars(tag, this.globalItemVars);
    }

    public static void readItemVars(CompoundNBT tag, Map<String, ItemStack> map) {
        map.clear();
        ListNBT list = tag.func_150295_c("globalItemVars", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT t = list.func_150305_b(i);
            map.put(t.func_74779_i("varName"), ItemStack.func_199557_a((CompoundNBT)t.func_74775_l("item")));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        for (Map.Entry<String, BlockPos> entry : this.globalVars.entrySet()) {
            CompoundNBT t = new CompoundNBT();
            t.func_74778_a("varName", entry.getKey());
            BlockPos pos = entry.getValue();
            t.func_74768_a("x", pos.func_177958_n());
            t.func_74768_a("y", pos.func_177956_o());
            t.func_74768_a("z", pos.func_177952_p());
            list.add((Object)t);
        }
        tag.func_218657_a("globalVars", (INBT)list);
        this.writeItemVars(tag);
        return tag;
    }

    public void writeItemVars(CompoundNBT tag) {
        ListNBT list = new ListNBT();
        for (Map.Entry<String, ItemStack> entry : this.globalItemVars.entrySet()) {
            CompoundNBT t = new CompoundNBT();
            t.func_74778_a("varName", entry.getKey());
            CompoundNBT itemTag = new CompoundNBT();
            entry.getValue().func_77955_b(itemTag);
            t.func_218657_a("item", (INBT)itemTag);
            list.add((Object)t);
        }
        tag.func_218657_a("globalItemVars", (INBT)list);
    }

    public String[] getAllActiveVariableNames() {
        HashSet<String> varNames = new HashSet<String>();
        varNames.addAll(this.globalVars.keySet());
        varNames.addAll(this.globalItemVars.keySet());
        return varNames.toArray(new String[0]);
    }

    @Override
    public boolean hasCoordinate(String varName) {
        return this.globalVars.containsKey(varName);
    }

    @Override
    public BlockPos getCoordinate(String varName) {
        return this.getPos(varName);
    }

    @Override
    public boolean hasStack(String varName) {
        return this.globalItemVars.containsKey(varName);
    }

    @Override
    @Nonnull
    public ItemStack getStack(String varName) {
        return this.getItem(varName);
    }
}

