/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.datagen;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import me.desht.pneumaticcraft.api.item.EnumUpgrade;
import me.desht.pneumaticcraft.common.advancements.AdvancementTriggers;
import me.desht.pneumaticcraft.common.advancements.CustomTrigger;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.block.Blocks;
import net.minecraft.data.AdvancementProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import org.apache.commons.lang3.Validate;

public class ModAdvancementProvider
extends AdvancementProvider {
    private static final ResourceLocation BACKGROUND_TEXTURE = PneumaticCraftUtils.RL("textures/gui/advancement_bg.png");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public ModAdvancementProvider(DataGenerator generatorIn) {
        super(generatorIn);
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = advancement -> {
            if (!set.add(advancement.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + advancement.func_192067_g());
            }
            Path path1 = ModAdvancementProvider.getPath(path, advancement);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)advancement.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException e) {
                Log.error("Couldn't save advancement {}", path1, e);
            }
        };
        this.register(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    private static String id(String s) {
        return "pneumaticcraft:" + s;
    }

    public void register(Consumer<Advancement> t) {
        Advancement root = this.itemAdvancement("root", FrameType.TASK, (IItemProvider)ModItems.COMPRESSED_IRON_INGOT.get()).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("root"));
        Advancement oilBucket = this.itemAdvancement("oil_bucket", FrameType.TASK, (IItemProvider)ModItems.OIL_BUCKET.get()).func_203905_a(root).func_203904_a(t, ModAdvancementProvider.id("oil_bucket"));
        Advancement refinery = this.itemAdvancement("refinery", FrameType.GOAL, (IItemProvider)ModBlocks.REFINERY.get(), new ItemPredicate[]{this.itemPredicate((IItemProvider)ModBlocks.REFINERY.get(), 1), this.itemPredicate((IItemProvider)ModBlocks.REFINERY_OUTPUT.get(), 2)}).func_203905_a(oilBucket).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)20)).func_203904_a(t, ModAdvancementProvider.id("refinery"));
        this.itemAdvancement("liquid_compressor", FrameType.TASK, (IItemProvider)ModBlocks.LIQUID_COMPRESSOR.get()).func_203905_a(refinery).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("liquid_compressor"));
        Advancement vortexTube = this.itemAdvancement("vortex_tube", FrameType.TASK, (IItemProvider)ModBlocks.VORTEX_TUBE.get()).func_203905_a(refinery).func_203904_a(t, ModAdvancementProvider.id("vortex_tube"));
        Advancement lpgBucket = this.itemAdvancement("lpg_bucket", FrameType.TASK, (IItemProvider)ModItems.LPG_BUCKET.get()).func_203905_a(vortexTube).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)20)).func_203904_a(t, ModAdvancementProvider.id("lpg_bucket"));
        Advancement tpp = this.itemAdvancement("tp_plant", FrameType.TASK, (IItemProvider)ModBlocks.THERMOPNEUMATIC_PROCESSING_PLANT.get()).func_203905_a(lpgBucket).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("tp_plant"));
        Advancement plastic = this.itemAdvancement("plastic", FrameType.GOAL, (IItemProvider)ModItems.PLASTIC.get()).func_203905_a(tpp).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("plastic"));
        Advancement jackhammer = this.itemAdvancement("jackhammer", FrameType.GOAL, (IItemProvider)ModItems.JACKHAMMER.get()).func_203905_a(plastic).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)20)).func_203904_a(t, ModAdvancementProvider.id("jackhammer"));
        this.itemAdvancement("drill_bit_netherite", FrameType.CHALLENGE, (IItemProvider)ModItems.NETHERITE_DRILL_BIT.get()).func_203905_a(jackhammer).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)50)).func_203904_a(t, ModAdvancementProvider.id("drill_bit_netherite"));
        Advancement amadronTablet = this.itemAdvancement("amadron_tablet", FrameType.TASK, (IItemProvider)ModItems.AMADRON_TABLET.get()).func_203905_a(plastic).func_203904_a(t, ModAdvancementProvider.id("amadron_tablet"));
        Advancement pcbBlueprint = this.itemAdvancement("pcb_blueprint", FrameType.TASK, (IItemProvider)ModItems.PCB_BLUEPRINT.get()).func_203905_a(amadronTablet).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)20)).func_203904_a(t, ModAdvancementProvider.id("pcb_blueprint"));
        this.itemAdvancement("uv_light_box", FrameType.TASK, (IItemProvider)ModBlocks.UV_LIGHT_BOX.get()).func_203905_a(pcbBlueprint).func_203904_a(t, ModAdvancementProvider.id("uv_light_box"));
        Advancement lubricant = this.itemAdvancement("lubricant_bucket", FrameType.TASK, (IItemProvider)ModItems.LUBRICANT_BUCKET.get()).func_203905_a(tpp).func_203904_a(t, ModAdvancementProvider.id("lubricant_bucket"));
        this.itemAdvancement("speed_upgrade", FrameType.TASK, new IItemProvider[]{EnumUpgrade.SPEED.getItem()}).func_203905_a(lubricant).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)15)).func_203904_a(t, ModAdvancementProvider.id("speed_upgrade"));
        Advancement yeast = this.itemAdvancement("yeast_culture", FrameType.TASK, (IItemProvider)ModItems.YEAST_CULTURE_BUCKET.get()).func_203905_a(tpp).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("yeast_culture"));
        Advancement ethanol = this.itemAdvancement("ethanol", FrameType.TASK, (IItemProvider)ModItems.ETHANOL_BUCKET.get()).func_203905_a(yeast).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("ethanol"));
        this.itemAdvancement("biodiesel", FrameType.GOAL, (IItemProvider)ModItems.BIODIESEL_BUCKET.get()).func_203905_a(ethanol).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)25)).func_203904_a(t, ModAdvancementProvider.id("biodiesel"));
        Advancement pressureTube = this.itemAdvancement("pressure_tube", FrameType.TASK, (IItemProvider)ModBlocks.PRESSURE_TUBE.get()).func_203905_a(root).func_203904_a(t, ModAdvancementProvider.id("pressure_tube"));
        this.itemAdvancement("air_compressor", FrameType.TASK, (IItemProvider)ModBlocks.AIR_COMPRESSOR.get()).func_203905_a(pressureTube).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("air_compressor"));
        this.itemAdvancement("minigun", FrameType.TASK, (IItemProvider)ModItems.MINIGUN.get()).func_203905_a(pressureTube).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("minigun"));
        Advancement wrench = this.itemAdvancement("pneumatic_wrench", FrameType.TASK, (IItemProvider)ModItems.PNEUMATIC_WRENCH.get(), new ItemPredicate[]{this.itemPredicateNoNBT((IItemProvider)ModItems.PNEUMATIC_WRENCH.get(), 1)}).func_203905_a(pressureTube).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("pneumatic_wrench"));
        this.customAdvancement(AdvancementTriggers.CHARGED_WRENCH, "pneumatic_wrench_charged", FrameType.TASK, (IItemProvider)ModItems.PNEUMATIC_WRENCH.get()).func_203905_a(wrench).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("pneumatic_wrench_charged"));
        this.customAdvancement(AdvancementTriggers.MACHINE_VANDAL, "machine_vandal", FrameType.TASK, (IItemProvider)Items.field_151035_b).func_203905_a(wrench).func_203904_a(t, ModAdvancementProvider.id("machine_vandal"));
        Advancement frames = this.itemAdvancement("logistics_frame", FrameType.TASK, (IItemProvider)ModItems.LOGISTICS_FRAME_PASSIVE_PROVIDER.get(), new ItemPredicate[]{this.itemPredicate((IItemProvider)ModItems.LOGISTICS_FRAME_PASSIVE_PROVIDER.get(), 1), this.itemPredicate((IItemProvider)ModItems.LOGISTICS_FRAME_REQUESTER.get(), 1)}).func_203905_a(root).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)20)).func_203904_a(t, ModAdvancementProvider.id("logistics_frame"));
        Advancement configurator = this.itemAdvancement("logistics_configurator", FrameType.TASK, (IItemProvider)ModItems.LOGISTICS_CONFIGURATOR.get()).func_203905_a(frames).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("logistics_configurator"));
        this.customAdvancement(AdvancementTriggers.LOGISTICS_DRONE_DEPLOYED, "logistics_drone", FrameType.GOAL, (IItemProvider)ModItems.LOGISTICS_DRONE.get()).func_203905_a(configurator).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("logistics_drone"));
        Advancement pressureChamber = this.customAdvancement(AdvancementTriggers.PRESSURE_CHAMBER, "pressure_chamber", FrameType.GOAL, (IItemProvider)ModBlocks.PRESSURE_CHAMBER_WALL.get()).func_203905_a(root).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)20)).func_203904_a(t, ModAdvancementProvider.id("pressure_chamber"));
        Advancement etchingAcid = this.itemAdvancement("etchacid_bucket", FrameType.TASK, (IItemProvider)ModItems.ETCHING_ACID_BUCKET.get()).func_203905_a(pressureChamber).func_203904_a(t, ModAdvancementProvider.id("etchacid_bucket"));
        Advancement emptyPCB = this.itemAdvancement("empty_pcb", FrameType.TASK, (IItemProvider)ModItems.EMPTY_PCB.get()).func_203905_a(etchingAcid).func_203904_a(t, ModAdvancementProvider.id("empty_pcb"));
        Advancement unassembledPCB = this.itemAdvancement("unassembled_pcb", FrameType.TASK, (IItemProvider)ModItems.UNASSEMBLED_PCB.get()).func_203905_a(emptyPCB).func_203904_a(t, ModAdvancementProvider.id("unassembled_pcb"));
        Advancement pcb = this.itemAdvancement("printed_circuit_board", FrameType.GOAL, (IItemProvider)ModItems.PRINTED_CIRCUIT_BOARD.get()).func_203905_a(unassembledPCB).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)20)).func_203904_a(t, ModAdvancementProvider.id("printed_circuit_board"));
        Advancement armor = this.customAdvancement(AdvancementTriggers.PNEUMATIC_ARMOR, "pneumatic_armor", FrameType.TASK, (IItemProvider)ModItems.PNEUMATIC_HELMET.get()).func_203905_a(pcb).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)20)).func_203904_a(t, ModAdvancementProvider.id("pneumatic_armor"));
        Advancement jetBoots = this.customAdvancement(AdvancementTriggers.FLIGHT, "flight", FrameType.CHALLENGE, (IItemProvider)EnumUpgrade.JET_BOOTS.getItem()).func_203905_a(armor).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)50)).func_203904_a(t, ModAdvancementProvider.id("flight"));
        this.customAdvancement(AdvancementTriggers.FLY_INTO_WALL, "fly_into_wall", FrameType.TASK, (IItemProvider)Blocks.field_196584_bK).func_203905_a(jetBoots).func_203904_a(t, ModAdvancementProvider.id("fly_into_wall"));
        this.customAdvancement(AdvancementTriggers.BLOCK_HACK, "block_hack", FrameType.TASK, (IItemProvider)EnumUpgrade.BLOCK_TRACKER.getItem()).func_203905_a(armor).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("block_hack"));
        this.customAdvancement(AdvancementTriggers.ENTITY_HACK, "entity_hack", FrameType.TASK, (IItemProvider)EnumUpgrade.ENTITY_TRACKER.getItem()).func_203905_a(armor).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("entity_hack"));
        Advancement assembly = this.itemAdvancement("assembly_controller", FrameType.GOAL, (IItemProvider)ModBlocks.ASSEMBLY_CONTROLLER.get()).func_203905_a(pcb).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)30)).func_203904_a(t, ModAdvancementProvider.id("assembly_controller"));
        Advancement advancedTube = this.itemAdvancement("advanced_pressure_tube", FrameType.TASK, (IItemProvider)ModBlocks.ADVANCED_PRESSURE_TUBE.get()).func_203905_a(assembly).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("advanced_pressure_tube"));
        this.itemAdvancement("aerial_interface", FrameType.TASK, (IItemProvider)ModBlocks.AERIAL_INTERFACE.get()).func_203905_a(advancedTube).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("aerial_interface"));
        this.itemAdvancement("programmable_controller", FrameType.TASK, (IItemProvider)ModBlocks.PROGRAMMABLE_CONTROLLER.get()).func_203905_a(advancedTube).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("programmable_controller"));
        this.itemAdvancement("flux_compressor", FrameType.TASK, (IItemProvider)ModBlocks.FLUX_COMPRESSOR.get()).func_203905_a(advancedTube).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)10)).func_203904_a(t, ModAdvancementProvider.id("flux_compressor"));
        this.itemAdvancement("aphorism_tile", FrameType.TASK, (IItemProvider)ModBlocks.APHORISM_TILE.get()).func_203905_a(assembly).func_203904_a(t, ModAdvancementProvider.id("aphorism_tile"));
        Advancement programmer = this.itemAdvancement("programmer", FrameType.TASK, (IItemProvider)ModBlocks.PROGRAMMER.get()).func_203905_a(pcb).func_203904_a(t, ModAdvancementProvider.id("programmer"));
        Advancement puzzle = this.itemAdvancement("programming_puzzle", FrameType.TASK, (IItemProvider)ModItems.PROGRAMMING_PUZZLE.get()).func_203905_a(programmer).func_203904_a(t, ModAdvancementProvider.id("programming_puzzle"));
        this.customAdvancement(AdvancementTriggers.PROGRAM_DRONE, "program_drone", FrameType.CHALLENGE, (IItemProvider)ModItems.DRONE.get()).func_203905_a(puzzle).func_200271_a(AdvancementRewards.Builder.func_203907_a((int)50)).func_203904_a(t, ModAdvancementProvider.id("program_drone"));
    }

    private Advancement.Builder customAdvancement(CustomTrigger trigger, String name, FrameType type, IItemProvider itemDisp) {
        return Advancement.Builder.func_200278_a().func_203902_a(itemDisp, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name, new Object[0]), (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).func_200275_a("0", (ICriterionInstance)trigger.getInstance());
    }

    private Advancement.Builder itemAdvancement(String name, FrameType type, IItemProvider ... items) {
        Validate.isTrue((items.length > 0 ? 1 : 0) != 0);
        return Advancement.Builder.func_200278_a().func_203902_a(items[0], (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name, new Object[0]), (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).func_200275_a("0", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])items));
    }

    private Advancement.Builder itemAdvancement(String name, FrameType type, IItemProvider item, ItemPredicate[] predicates) {
        return Advancement.Builder.func_200278_a().func_203902_a(item, (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name, new Object[0]), (ITextComponent)PneumaticCraftUtils.xlate("pneumaticcraft.advancement." + name + ".desc", new Object[0]), BACKGROUND_TEXTURE, type, true, true, false).func_200275_a("0", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])predicates));
    }

    private ItemPredicate itemPredicate(IItemProvider item, int minCount) {
        return new ItemPredicate(null, item.func_199767_j(), MinMaxBounds.IntBound.func_211340_b((int)minCount), MinMaxBounds.IntBound.field_211347_e, new EnchantmentPredicate[0], new EnchantmentPredicate[0], null, NBTPredicate.field_193479_a);
    }

    private ItemPredicate itemPredicateNoNBT(IItemProvider item, int minCount) {
        return new ItemPredicate(null, item.func_199767_j(), MinMaxBounds.IntBound.func_211340_b((int)minCount), MinMaxBounds.IntBound.field_211347_e, new EnchantmentPredicate[0], new EnchantmentPredicate[0], null, new NBTPredicate(null));
    }
}

