/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.command.CommandSource;
import net.minecraft.data.IDataProvider;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.marstonconnell.randomloot.entity.RLPointOfInterestTypes;
import xyz.marstonconnell.randomloot.entity.RLVillagerProfession;
import xyz.marstonconnell.randomloot.init.ItemUtils;
import xyz.marstonconnell.randomloot.init.RLCommands;
import xyz.marstonconnell.randomloot.init.RLEntities;
import xyz.marstonconnell.randomloot.init.RLItems;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.TextureProxy;
import xyz.marstonconnell.randomloot.utils.Config;
import xyz.marstonconnell.randomloot.utils.DataCollection;
import xyz.marstonconnell.randomloot.utils.LootSystem;
import xyz.marstonconnell.randomloot.utils.RLUtils;
import xyz.marstonconnell.randomloot.utils.RandomTradeBuilder;
import xyz.marstonconnell.randomloot.utils.Registration;
import xyz.marstonconnell.randomloot.utils.WeightedChooser;
import xyz.marstonconnell.randomloot.utils.handlers.NetworkHandler;
import xyz.marstonconnell.randomloot.utils.loot.AutoSmeltModifier;
import xyz.marstonconnell.randomloot.utils.loot.DataProvider;

@Mod(value="randomloot")
public class RandomLootMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "randomloot";
    public static Random rand;
    public static WeightedChooser<Item> wc;
    public static final boolean DEBUG = false;
    private static final DeferredRegister<GlobalLootModifierSerializer<?>> GLM;
    public static final RegistryObject<AutoSmeltModifier.Serializer> SMELTING;

    public RandomLootMod() {
        new ItemUtils();
        rand = new Random();
        wc = new WeightedChooser();
        TagHelper.finalizeActiveTraits();
        GLM.register(FMLJavaModLoadingContext.get().getModEventBus());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        Registration.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent event) {
        RLUtils.fixPOITypeBlockStates(RLPointOfInterestTypes.LOOTER);
        NetworkHandler.registerMessage();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        TextureProxy.init();
        RenderTypeLookup.setRenderLayer((Block)((Block)Registration.LIGHT_BALL.get()), (RenderType)RenderType.func_228643_e_());
    }

    @SubscribeEvent
    public void entityDrop(LivingDropsEvent event) {
        if (event.getEntity().func_130014_f_().func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            if (!(event.getSource() instanceof EntityDamageSource && ((EntityDamageSource)event.getSource()).func_76346_g() instanceof PlayerEntity && ((EntityDamageSource)event.getSource()).func_76346_g() instanceof PlayerEntity)) {
                return;
            }
            int choice = rand.nextInt(1000);
            int range = 0;
            if (event.getEntity() instanceof MonsterEntity) {
                range = (Integer)Config.MONSTERS_DROP.get();
            } else if (event.getEntity() instanceof AnimalEntity) {
                range = (Integer)Config.ANIMAL_DROP.get();
            }
            if (!event.getEntity().func_184222_aU()) {
                range = (Integer)Config.BOSS_DROP.get();
            }
            if (choice < range) {
                WeightedChooser<Item> cases = new WeightedChooser<Item>();
                cases.addChoice(RLItems.BASIC_ITEM_CASE, (Integer)Config.BASIC_CHANCE.get());
                cases.addChoice(RLItems.BETTER_ITEM_CASE, (Integer)Config.GOLD_CHANCE.get());
                cases.addChoice(RLItems.BEST_ITEM_CASE, (Integer)Config.TITAN_CHANCE.get());
                event.getEntity().func_199701_a_(new ItemStack((IItemProvider)cases.getRandomObject()));
            }
        }
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
        RLCommands.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
        LootSystem.init();
    }

    @SubscribeEvent
    public void onServerStopping(FMLServerStoppingEvent event) {
        DataCollection.goOffline(event.getServer().func_71233_x());
    }

    @SubscribeEvent
    public void onPlayerLeave(EntityLeaveWorldEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (!event.getWorld().func_201670_d()) {
            DataCollection.goOffline(1);
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        if (!event.getWorld().func_201670_d()) {
            DataCollection.goOnline();
        }
        System.out.println("Player joined world");
        PlayerEntity player = (PlayerEntity)event.getEntity();
        LOGGER.info("HELLO from server starting");
        World world = event.getWorld();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (!(stack.func_77973_b() instanceof IRLTool)) continue;
            System.out.println("Found a tool.");
            List<BasicTag> tags = TagHelper.getTagList(stack);
            for (BasicTag tag : tags) {
                tag.onTagAdded(stack, world, player);
            }
        }
    }

    static {
        GLM = DeferredRegister.create((IForgeRegistry)ForgeRegistries.LOOT_MODIFIER_SERIALIZERS, (String)MODID);
        SMELTING = GLM.register("smelting", AutoSmeltModifier.Serializer::new);
    }

    @Mod.EventBusSubscriber(modid="randomloot")
    public static class VillagerEvents {
        @SubscribeEvent
        public static void villagerTrades(VillagerTradesEvent event) {
            if (event.getType() == RLVillagerProfession.LOOTER) {
                for (int i = 0; i < TagHelper.allTags.size(); ++i) {
                    ItemStack s = new ItemStack((IItemProvider)RLItems.TRAIT_HOLDER);
                    TagHelper.addTag(s, TagHelper.allTags.get(i), null);
                    s.func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.WHITE + TagHelper.convertToTitleCaseIteratingChars(TagHelper.allTags.get((int)i).name) + " Essence"));
                    ((List)event.getTrades().get(4)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 24), s, 3, 10, 0.0f));
                }
                ((List)event.getTrades().get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 16), new ItemStack((IItemProvider)RLItems.basic_shard), 8, 2, 0.0f));
                ((List)event.getTrades().get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)RLItems.BASIC_ITEM_CASE), new ItemStack((IItemProvider)Items.field_151166_bC), 8, 2, 0.0f));
                ((List)event.getTrades().get(1)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)RLItems.better_shard), new ItemStack((IItemProvider)Items.field_151166_bC, 2), 5, 2, 0.5f));
                ((List)event.getTrades().get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)RLItems.BETTER_ITEM_CASE), new ItemStack((IItemProvider)Items.field_151166_bC, 3), 8, 2, 0.0f));
                ((List)event.getTrades().get(2)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 32), new ItemStack((IItemProvider)RLItems.better_shard), 3, 2, 0.0f));
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)RLItems.BEST_ITEM_CASE), new ItemStack((IItemProvider)Items.field_151166_bC, 12), 8, 2, 0.0f));
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 32), new ItemStack((IItemProvider)RLItems.BASIC_ITEM_CASE), 3, 2, 0.0f));
                ((List)event.getTrades().get(3)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 32), new ItemStack((IItemProvider)RLItems.best_shard), 5, 2, 0.0f));
                ((List)event.getTrades().get(4)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 48), new ItemStack((IItemProvider)RLItems.BETTER_ITEM_CASE), 2, 1, 0.0f));
                ((List)event.getTrades().get(5)).add((entity, random) -> new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, 64), new ItemStack((IItemProvider)RLItems.BEST_ITEM_CASE), 2, 1, 0.0f));
                RandomTradeBuilder.forEachLevel((level, tradeBuild) -> ((List)event.getTrades().get(level.intValue())).add(tradeBuild.build()));
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onItemRegistry(RegistryEvent.Register<Item> event) {
            for (Item item : RLItems.ITEMS) {
                event.getRegistry().register((IForgeRegistryEntry)item);
            }
            wc.addChoice((Item)RLItems.random_sword, (Integer)Config.SWORD_CHANCE.get());
            wc.addChoice((Item)RLItems.random_pick, (Integer)Config.PICK_CHANCE.get());
            wc.addChoice((Item)RLItems.random_axe, (Integer)Config.AXE_CHANCE.get());
            wc.addChoice((Item)RLItems.random_spade, (Integer)Config.SPADE_CHANCE.get());
            wc.addChoice((Item)RLItems.random_bow, (Integer)Config.BOW_CHANCE.get());
            wc.addChoice(RLItems.HEAVY_BOOTS, (Integer)Config.ARMOR_CHANCE.get());
            wc.addChoice(RLItems.HEAVY_CHEST, (Integer)Config.ARMOR_CHANCE.get());
            wc.addChoice(RLItems.HEAVY_HELMET, (Integer)Config.ARMOR_CHANCE.get());
            wc.addChoice(RLItems.HEAVY_LEGS, (Integer)Config.ARMOR_CHANCE.get());
            wc.addChoice(RLItems.TITANIUM_BOOTS, (Integer)Config.ARMOR_CHANCE.get());
            wc.addChoice(RLItems.TITANIUM_CHEST, (Integer)Config.ARMOR_CHANCE.get());
            wc.addChoice(RLItems.TITANIUM_HELMET, (Integer)Config.ARMOR_CHANCE.get());
            wc.addChoice(RLItems.TITANIUM_LEGS, (Integer)Config.ARMOR_CHANCE.get());
        }

        @SubscribeEvent
        public static void onEntityRegistry(RegistryEvent.Register<EntityType<?>> event) {
            for (EntityType<? extends Entity> entity : RLEntities.ENTITIES) {
                Preconditions.checkNotNull((Object)entity.getRegistryName(), (Object)"registryName");
                event.getRegistry().register(entity);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="randomloot", bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class EventHandlers {
        @SubscribeEvent
        public static void runData(GatherDataEvent event) {
            event.getGenerator().func_200390_a((IDataProvider)new DataProvider(event.getGenerator(), RandomLootMod.MODID));
        }
    }
}

