/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.container;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xyz.marstonconnell.randomloot.init.RLItems;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;
import xyz.marstonconnell.randomloot.utils.Config;
import xyz.marstonconnell.randomloot.utils.Pair;
import xyz.marstonconnell.randomloot.utils.Registration;

public class RLRepairContainer
extends Container {
    protected List<BasicTag> tagsToDrop = new ArrayList<BasicTag>();
    protected final IInventory craftResult = new CraftResultInventory();
    protected final IInventory slots = new Inventory(3){

        public void func_70296_d() {
            super.func_70296_d();
            RLRepairContainer.this.func_75130_a((IInventory)this);
        }
    };
    protected final IWorldPosCallable worldPos;
    protected final PlayerEntity player;
    private int toShrinkMod = 1;

    public RLRepairContainer(int p_i231590_1_, PlayerInventory p_i231590_2_) {
        this((ContainerType)Registration.EDITOR_CONTAINER.get(), p_i231590_1_, p_i231590_2_, IWorldPosCallable.field_221489_a);
    }

    public RLRepairContainer(@Nullable ContainerType<?> containerType, int id, PlayerInventory playerInv, IWorldPosCallable worldPos) {
        super(containerType, id);
        this.worldPos = worldPos;
        this.player = playerInv.field_70458_d;
        this.func_75146_a(new Slot(this.slots, 0, 27, 47));
        this.func_75146_a(new Slot(this.slots, 1, 76, 47));
        this.func_75146_a(new Slot(this.slots, 2, 8, 47){

            public boolean func_75214_a(ItemStack stack) {
                Item i = stack.func_77973_b();
                return i.equals(RLItems.best_shard);
            }
        });
        this.func_75146_a(new Slot(this.craftResult, 3, 134, 47){

            public boolean func_75214_a(ItemStack stack) {
                return false;
            }

            public boolean func_82869_a(PlayerEntity playerIn) {
                return RLRepairContainer.this.isRecipe(playerIn);
            }

            public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
                return RLRepairContainer.this.craftOutput(thePlayer, stack);
            }
        });
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.func_75146_a(new Slot((IInventory)playerInv, k, 8 + k * 18, 142));
        }
    }

    private void shrinkSlot(int slot) {
        ItemStack itemstack = this.slots.func_70301_a(slot);
        itemstack.func_190918_g(1);
        this.slots.func_70299_a(slot, itemstack);
    }

    protected boolean isRecipe(PlayerEntity player) {
        boolean isItemTool = this.slots.func_70301_a(0).func_77973_b() instanceof IRLTool;
        return isItemTool;
    }

    protected boolean func_75135_a(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        if (stack.func_77973_b() instanceof IRLTool) {
            ToolUtilities.setLore(stack, null);
        }
        return super.func_75135_a(stack, startIndex, endIndex, reverseDirection);
    }

    protected ItemStack craftOutput(PlayerEntity player, ItemStack stack) {
        int i;
        ItemStack out = this.slots.func_70301_a(0).func_77946_l();
        double shardsNeeded = Math.pow((double)ToolUtilities.getIntNBT(out, "rl_level") / 10.0, 2.0) + 1.0;
        this.shrinkSlot(0);
        for (i = 0; i < this.toShrinkMod; ++i) {
            this.shrinkSlot(1);
        }
        this.toShrinkMod = 1;
        i = 0;
        while ((double)i < Math.floor(shardsNeeded)) {
            this.shrinkSlot(2);
            ++i;
        }
        System.out.println("Crafting: " + stack.func_200301_q());
        this.worldPos.func_221486_a((p_234653_0_, p_234653_1_) -> p_234653_0_.func_217379_c(1044, p_234653_1_, 0));
        if (stack.func_77973_b() instanceof IRLTool) {
            ToolUtilities.setLore(stack, player.func_130014_f_());
        }
        for (BasicTag tag : this.tagsToDrop) {
            ItemStack s = new ItemStack((IItemProvider)RLItems.TRAIT_HOLDER);
            TagHelper.addTag(s, tag.setLevel(0), player.func_130014_f_());
            s.func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.WHITE + tag.toString() + " Essence"));
            player.func_191521_c(s);
        }
        return stack;
    }

    public void func_75130_a(IInventory inventoryIn) {
        super.func_75130_a(inventoryIn);
        if (inventoryIn == this.slots) {
            this.updateRepairOutput(this.player.func_130014_f_());
        }
    }

    public void updateRepairOutput(World worldIn) {
        if (this.isRecipe(this.player)) {
            ItemStack out = this.slots.func_70301_a(0).func_77946_l();
            ItemStack mod = this.slots.func_70301_a(1);
            if (!mod.func_190926_b()) {
                this.tagsToDrop.clear();
                if (mod.func_77973_b().equals(RLItems.TRAIT_HOLDER)) {
                    this.toShrinkMod = 1;
                    List<BasicTag> tags = TagHelper.getTagList(mod);
                    for (BasicTag tag : tags) {
                        List<BasicTag> comps = TagHelper.getCompatibleTags(out);
                        if (comps.contains(tag)) {
                            TagHelper.addTag(out, tag, worldIn);
                            continue;
                        }
                        this.craftResult.func_70299_a(0, new ItemStack((IItemProvider)Items.field_190931_a));
                        return;
                    }
                } else {
                    boolean foundMaterial = false;
                    List<BasicTag> tags = TagHelper.getCompatibleTags(out);
                    List<BasicTag> existingTags = TagHelper.getTagList(out);
                    for (BasicTag tag : tags) {
                        Pair<Boolean, Integer> p;
                        boolean hasTag = TagHelper.checkForTag(out, tag);
                        BasicTag copy = null;
                        if (hasTag) {
                            BasicTag bt = null;
                            for (BasicTag t : existingTags) {
                                if (!t.sameTag(tag)) continue;
                                bt = t;
                            }
                            if (bt == null) {
                                this.craftResult.func_70299_a(0, new ItemStack((IItemProvider)Items.field_190931_a));
                                return;
                            }
                            copy = TagHelper.convertToTag(TagHelper.convertToNBT(bt));
                        }
                        if (!(p = (copy = TagHelper.convertToTag(TagHelper.convertToNBT(tag)).setLevel(-1)).canMaterialsCauseLevelUp(mod)).getLeft().booleanValue()) continue;
                        System.out.println("Adding trait! " + (hasTag ? "Already had it..." : "Adding new!"));
                        TagHelper.addTag(out, tag, worldIn);
                        this.toShrinkMod = p.getRight();
                        if (((Boolean)Config.TRAIT_CRAFTING.get()).booleanValue()) continue;
                        this.craftResult.func_70299_a(0, new ItemStack((IItemProvider)Items.field_190931_a));
                        return;
                    }
                }
                ToolUtilities.setLore(out, worldIn);
            } else {
                ItemStack edit = this.slots.func_70301_a(2);
                this.toShrinkMod = 1;
                if (edit.func_77973_b().equals(RLItems.best_shard)) {
                    this.tagsToDrop.clear();
                    double shardsNeeded = Math.pow((double)ToolUtilities.getIntNBT(out, "rl_level") / 10.0, 2.0) + 1.0;
                    if ((double)edit.func_190916_E() < Math.floor(shardsNeeded)) {
                        this.craftResult.func_70299_a(0, new ItemStack((IItemProvider)Items.field_190931_a));
                        return;
                    }
                    int oldXp = ToolUtilities.getXP(out);
                    ToolUtilities.changeXP(out, ToolUtilities.getMaxXP(out), this.player.func_130014_f_(), this.player.func_233580_cy_());
                    ToolUtilities.changeXP(out, oldXp, this.player.func_130014_f_(), this.player.func_233580_cy_());
                    CompoundNBT nbt = out.func_77942_o() ? out.func_77978_p() : new CompoundNBT();
                    ListNBT lore = new ListNBT();
                    lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + TextFormatting.DARK_PURPLE + "Upgraded stats hidden.\"}")));
                    CompoundNBT display = nbt.func_74775_l("display");
                    display.func_218657_a("Lore", (INBT)lore);
                    nbt.func_218657_a("display", (INBT)display);
                    out.func_77982_d(nbt);
                } else if (edit.func_190926_b()) {
                    CompoundNBT nbt = out.func_77942_o() ? out.func_77978_p() : new CompoundNBT();
                    ListNBT lore = new ListNBT();
                    lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + TextFormatting.RED + "All traits will be popped from this tool and it will be heavily damaged.\"}")));
                    CompoundNBT display = nbt.func_74775_l("display");
                    display.func_218657_a("Lore", (INBT)lore);
                    nbt.func_218657_a("display", (INBT)display);
                    out.func_77982_d(nbt);
                    out.func_196085_b((out.func_77958_k() - out.func_77952_i()) / 2 + out.func_77952_i());
                    this.tagsToDrop = TagHelper.getTagList(out);
                    TagHelper.removeAllTags(out);
                }
            }
            this.craftResult.func_70299_a(0, out);
            return;
        }
        this.craftResult.func_70299_a(0, new ItemStack((IItemProvider)Items.field_190931_a));
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.worldPos.func_221486_a((p_234647_2_, p_234647_3_) -> this.func_193327_a(playerIn, (World)p_234647_2_, this.slots));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return (Boolean)this.worldPos.func_221485_a((p_234646_2_, p_234646_3_) -> !this.checkBlock(p_234646_2_.func_180495_p(p_234646_3_)) ? false : playerIn.func_70092_e((double)p_234646_3_.func_177958_n() + 0.5, (double)p_234646_3_.func_177956_o() + 0.5, (double)p_234646_3_.func_177952_p() + 0.5) <= 64.0, (Object)true);
    }

    protected boolean checkBlock(BlockState blockState) {
        return blockState.func_203425_a((Block)Registration.EDITOR.get());
    }

    protected boolean checkItem(ItemStack stack) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index == 3) {
                if (!this.func_75135_a(itemstack1, 4, 40, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index != 0 && index != 1 && index != 2) {
                if (index >= 4 && index < 40) {
                    int i = 0;
                    if (itemstack.func_77973_b().equals(RLItems.best_shard)) {
                        i = 2;
                    } else if (itemstack.func_77973_b().equals(RLItems.TRAIT_HOLDER)) {
                        i = 1;
                    }
                    if (!this.func_75135_a(itemstack1, i, 3, false)) {
                        return ItemStack.field_190927_a;
                    }
                }
            } else if (!this.func_75135_a(itemstack1, 4, 40, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, itemstack1);
        }
        return itemstack;
    }
}

