/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.init;

import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xyz.marstonconnell.randomloot.init.ItemUtils;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;
import xyz.marstonconnell.randomloot.utils.Config;
import xyz.marstonconnell.randomloot.utils.DataCollection;
import xyz.marstonconnell.randomloot.utils.WeightedChooser;

public class ItemFactory {
    public static final int CURRENT_TOOL_VERSION = 1;
    public static final String RL_FOUND_IN = "rl_found_in";
    static Random rand = new Random();

    public static void applyToken(ItemStack stack, World worldIn) {
        if (rand.nextInt((Integer)Config.TRAIT_RATIO.get()) <= 1) {
            ItemFactory.giftNewTrait(stack, worldIn);
        } else {
            ItemFactory.buffItemStats(stack, worldIn);
        }
    }

    private static void buffItemStats(ItemStack stack, World worldIn) {
        if (stack.func_77973_b() instanceof IRLTool) {
            ((IRLTool)stack.func_77973_b()).upgradeTool(stack, worldIn);
        }
    }

    private static void giftNewTrait(ItemStack stack, World worldIn) {
        List<BasicTag> allTags = TagHelper.getCompatibleTags(stack);
        List<BasicTag> currentTags = TagHelper.getTagList(stack);
        for (BasicTag tag : currentTags) {
            if (!tag.natural) continue;
            BasicTag newTag = TagHelper.copyTag(tag).setLevel(0);
            allTags.add(newTag);
        }
        BasicTag t = allTags.get(rand.nextInt(allTags.size()));
        TagHelper.addTag(stack, t, worldIn);
    }

    public static ItemStack forgeItem(ItemStack stack, int rarity, World worldIn, BlockPos pos) {
        WeightedChooser<Integer> wc = new WeightedChooser<Integer>();
        switch (rarity) {
            case 0: {
                wc.addChoice(0, (Integer)Config.BASIC_COMMON.get());
                wc.addChoice(1, (Integer)Config.BASIC_RARE.get());
                wc.addChoice(2, (Integer)Config.BASIC_LEGEND.get());
                break;
            }
            case 1: {
                wc.addChoice(0, (Integer)Config.BETTER_COMMON.get());
                wc.addChoice(1, (Integer)Config.BETTER_RARE.get());
                wc.addChoice(2, (Integer)Config.BETTER_LEGEND.get());
                break;
            }
            case 2: {
                wc.addChoice(0, (Integer)Config.TITAN_COMMON.get());
                wc.addChoice(1, (Integer)Config.TITAN_RARE.get());
                wc.addChoice(2, (Integer)Config.TITAN_LEGEND.get());
                break;
            }
            default: {
                wc.addChoice(0, 1);
            }
        }
        int toolRaririty = (Integer)wc.getRandomObject();
        int totalRolls = 0;
        TextFormatting color = TextFormatting.GRAY;
        switch (toolRaririty) {
            case 0: {
                totalRolls = (Integer)Config.BASIC_ROLLS.get();
                color = TextFormatting.WHITE;
                break;
            }
            case 1: {
                totalRolls = (Integer)Config.GOLD_ROLLS.get();
                color = TextFormatting.GOLD;
                break;
            }
            case 2: {
                totalRolls = (Integer)Config.TITAN_ROLLS.get();
                color = TextFormatting.LIGHT_PURPLE;
            }
        }
        ((IRLTool)stack.func_77973_b()).setStats(stack);
        System.out.println("Rolling for item " + totalRolls + " times...");
        for (int i = 0; i < totalRolls; ++i) {
            ItemFactory.applyToken(stack, worldIn);
        }
        ((IRLTool)stack.func_77973_b()).updateStats(stack);
        ToolUtilities.setIntNBT(stack, "rl_tool_version", 1);
        ToolUtilities.setStringNBT(stack, RL_FOUND_IN, TagHelper.convertToTitleCaseIteratingChars(worldIn.func_226691_t_(pos).getRegistryName().func_110623_a()));
        ToolUtilities.setName(stack, ItemUtils.nameItem(((IRLTool)stack.func_77973_b()).getItemType()));
        ToolUtilities.setTexture(stack, rand.nextInt(((IRLTool)stack.func_77973_b()).getVariants() - 1) + 1);
        ToolUtilities.setMaxXP(stack, (Integer)Config.STARTING_XP.get());
        ToolUtilities.setLore(stack, worldIn);
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        CompoundNBT display = nbt.func_74775_l("display");
        display.func_74778_a("Name", "{\"text\":\"" + ToolUtilities.getName(stack) + "\", \"color\":\"" + color.name().toLowerCase() + "\",\"italic\":false}");
        stack.func_77982_d(nbt);
        DataCollection.uploadTool(stack);
        return stack;
    }
}

