/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.utils.Pair;
import xyz.marstonconnell.randomloot.utils.RomanNumber;

public class BasicTag {
    public String name;
    public TextFormatting color;
    public int level;
    public int maxLevel;
    public List<String> incompatibleTags;
    public String description;
    public boolean offensive = false;
    public boolean forWeapons = false;
    public boolean forTools = false;
    public boolean forArmor = false;
    public boolean forBows = false;
    public boolean natural = true;
    public boolean active = false;
    private Map<Integer, Pair<Item, Integer>> levelingMaterials;
    Map<String, Float> extraValues;

    public boolean onTagAdded(ItemStack s, World worldIn, PlayerEntity player) {
        return worldIn != null;
    }

    public BasicTag setDescription(String desc) {
        this.description = desc;
        return this;
    }

    public BasicTag setUnnatural() {
        this.natural = false;
        return this;
    }

    public BasicTag setActive() {
        this.active = true;
        return this;
    }

    public BasicTag setBowTag() {
        this.forBows = true;
        return this;
    }

    public BasicTag addCraftMaterial(Item i, int count, int level) {
        this.levelingMaterials.put(level, new Pair<Item, Integer>(i, count));
        return this;
    }

    public Pair<Boolean, Integer> canMaterialsCauseLevelUp(ItemStack material) {
        if (!this.levelingMaterials.containsKey(this.level + 1)) {
            return new Pair<Boolean, Integer>(false, 0);
        }
        Pair<Item, Integer> p = this.levelingMaterials.get(this.level + 1);
        if (p.getLeft().equals(material.func_77973_b()) && p.getRight() <= material.func_190916_E()) {
            return new Pair<Boolean, Integer>(true, p.getRight());
        }
        return new Pair<Boolean, Integer>(false, 0);
    }

    public BasicTag addValue(String s, float f) {
        this.extraValues.put(s, Float.valueOf(f));
        return this;
    }

    public float getValue(String s) {
        return this.extraValues.get(s).floatValue();
    }

    public BasicTag(String name, TextFormatting color) {
        this.name = name;
        this.color = color;
        this.level = 0;
        this.maxLevel = 0;
        this.incompatibleTags = new ArrayList<String>();
        TagHelper.allTags.add(this);
        TagHelper.tagNames.add(name);
        TagHelper.tagMap.put(name, this);
        this.extraValues = new HashMap<String, Float>();
        this.levelingMaterials = new HashMap<Integer, Pair<Item, Integer>>();
    }

    public BasicTag setUniversal() {
        return this.forObjects(true, true, true, true);
    }

    public BasicTag forObjects(boolean forWeaponsIn, boolean forToolsIn, boolean forArmorIn, boolean forBowsIn) {
        this.forWeapons = forWeaponsIn;
        this.forTools = forToolsIn;
        this.forArmor = forArmorIn;
        this.forBows = forBowsIn;
        return this;
    }

    public BasicTag addBlackTags(String ... tags) {
        for (String t : tags) {
            this.incompatibleTags.add(t);
        }
        return this;
    }

    public BasicTag(BasicTag clone) {
        this.name = clone.name;
        this.color = clone.color;
        this.level = clone.level;
        this.maxLevel = clone.maxLevel;
        this.incompatibleTags = clone.incompatibleTags;
        this.extraValues = clone.extraValues;
        this.levelingMaterials = clone.levelingMaterials;
        this.active = clone.active;
        this.forArmor = clone.forArmor;
        this.forTools = clone.forTools;
        this.forWeapons = clone.forWeapons;
        this.offensive = clone.offensive;
        this.forBows = clone.forBows;
    }

    public boolean sameTag(BasicTag tag) {
        return this.name.equals(tag.name);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BasicTag) {
            BasicTag compareTo = (BasicTag)obj;
            return compareTo.level == this.level && this.sameTag(compareTo);
        }
        return false;
    }

    public BasicTag setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
        return this;
    }

    public BasicTag setLevel(int lvlIn) {
        this.level = lvlIn;
        return this;
    }

    public String toString() {
        String newName = this.name.replaceAll("_", " ");
        newName = TagHelper.convertToTitleCaseIteratingChars(newName);
        if (this.level >= 1) {
            String roman = RomanNumber.toRoman(this.level + 1);
            newName = newName + " " + roman;
        }
        return newName;
    }

    public BasicTag get() {
        return this;
    }

    public boolean onTagAdded(ItemStack stack, World worldIn, LivingEntity entityLiving, BlockState state, BlockPos pos, LivingEntity target) {
        return false;
    }
}

