/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tags;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.EffectTag;
import xyz.marstonconnell.randomloot.tags.StatBoost.LowDurabilityBoostEvent;
import xyz.marstonconnell.randomloot.tags.StatBoost.WeatherBoostEvent;
import xyz.marstonconnell.randomloot.tags.StatBoostTag;
import xyz.marstonconnell.randomloot.tags.WorldInteractTag;
import xyz.marstonconnell.randomloot.tags.worldinteract.AutoSmeltEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.BeanStalkEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.BeeSummonEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.BurningEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.ChargingEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.CriticalStrikeEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.DamageEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.ExplosionEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.FindEntitiesEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.FloatEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.GangBangEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.InstaKillEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.LaserArrowEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.LightBoostEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.LongLeggedEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.LowDurabilityAttackEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.MultiBreakEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.MultiShotEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.OreFindEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.PlaceLightEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.RaisingEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.ReplenishEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.TeleportItemsEvent;
import xyz.marstonconnell.randomloot.tags.worldinteract.UnbreakingEvent;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.utils.Config;

public abstract class TagHelper {
    private static final String TAG_LIST = "rl_tag_data";
    private static final String TAG_LEVEL = "tag_level";
    private static final String TAG_NAME = "tag_name";
    public static List<BasicTag> allTags = new ArrayList<BasicTag>();
    public static List<String> tagNames = new ArrayList<String>();
    public static HashMap<String, BasicTag> tagMap = new HashMap();
    public static final BasicTag NULL_TAG = new BasicTag("", TextFormatting.WHITE);
    public static final BasicTag SPEED = new EffectTag("speedy", TextFormatting.AQUA, Effects.field_76424_c, false, false, true).setMaxLevel(2);
    public static final BasicTag JUMP = new EffectTag("bouncy", TextFormatting.GREEN, Effects.field_76430_j, false, false, false).setMaxLevel(1).addBlackTags("cloud_walker");
    public static final BasicTag RESISTANCE = new EffectTag("resistant", TextFormatting.GRAY, Effects.field_76429_m, false, false, false).setMaxLevel(3);
    public static final BasicTag FIRE_RESISTANCE = new EffectTag("fire_resistant", TextFormatting.YELLOW, Effects.field_76426_n, false, false, false).setMaxLevel(1);
    public static final BasicTag HASTE = new EffectTag("hastey", TextFormatting.YELLOW, Effects.field_76422_e, false, true, false).setMaxLevel(1);
    public static final BasicTag LUCK = new EffectTag("lucky", TextFormatting.GREEN, Effects.field_188425_z, false, true, false);
    public static final BasicTag STRENGTH = new EffectTag("strong", TextFormatting.DARK_RED, Effects.field_76420_g, false, false, true).setMaxLevel(4);
    public static final BasicTag NIGHT_VISION = new EffectTag("insightful", TextFormatting.BLUE, new EffectInstance(Effects.field_76439_r, 500, 0), false, false, false);
    public static final BasicTag WATER_BREATHING = new EffectTag("deep_breathing", TextFormatting.DARK_BLUE, Effects.field_76427_o, false, false, false).setMaxLevel(1);
    public static final BasicTag REGENERATION = new EffectTag("regenerating", TextFormatting.RED, Effects.field_76428_l, false, false, true).setMaxLevel(2);
    public static final BasicTag POISON = new EffectTag("poisonous", TextFormatting.DARK_GREEN, Effects.field_76436_u, true, false, true).setMaxLevel(3).addBlackTags("withering");
    public static final BasicTag WITHER = new EffectTag("withering", TextFormatting.DARK_GRAY, Effects.field_82731_v, true, false, true).setMaxLevel(1).addBlackTags("poisonous");
    public static final BasicTag SLOWING = new EffectTag("webbed", TextFormatting.WHITE, Effects.field_76421_d, true, false, true).setMaxLevel(3).addCraftMaterial(Items.field_151007_F, 10, 0).addCraftMaterial(Items.field_151007_F, 10, 1).addCraftMaterial(Items.field_151007_F, 15, 2).addCraftMaterial(Items.field_151007_F, 20, 3);
    public static final BasicTag BLINDING = new EffectTag("blinding", TextFormatting.DARK_PURPLE, Effects.field_76440_q, true, false, true);
    public static final BasicTag GLOWING = new EffectTag("glittering", TextFormatting.GOLD, Effects.field_188423_x, true, false, true);
    public static final BasicTag DAMAGE = new EffectTag("blood_thirst", TextFormatting.DARK_RED, Effects.field_76433_i, true, false, true).setMaxLevel(3);
    public static final BasicTag WEAKNESS = new EffectTag("weakening", TextFormatting.GRAY, Effects.field_76437_t, true, false, true).setMaxLevel(1);
    public static final EffectTag FLOATING = new EffectTag("floating", TextFormatting.AQUA, Effects.field_188424_y, true, false, true);
    public static final BasicTag EXPLOSION = new WorldInteractTag(new String[]{"explosive"}, TextFormatting.RED, new ExplosionEvent(), true, false, false).addBlackTags("phasing", "sun_bathing", "auto-smelt").addCraftMaterial(Items.field_221649_bM, 1, 0);
    public static final BasicTag REPLENISH = new WorldInteractTag(new String[]{"filling"}, TextFormatting.DARK_GREEN, new ReplenishEvent(), true, false, true).addBlackTags("fortified");
    public static final BasicTag TELEPORT_ITEMS = new WorldInteractTag(new String[]{"phasing"}, TextFormatting.AQUA, new TeleportItemsEvent(), true, false, false).addBlackTags("explosive");
    public static final BasicTag FIND_ENTITIES = new WorldInteractTag(new String[]{"soul_searching"}, TextFormatting.YELLOW, new FindEntitiesEvent(), false, true, false);
    public static final BasicTag CLOUD_WALKER = new WorldInteractTag(new String[]{"cloud_walker"}, TextFormatting.YELLOW, new FloatEvent(), false, true, false).addBlackTags("bouncy");
    public static final BasicTag GIANT_SLAYER = new WorldInteractTag(new String[]{"giant_slayer", "titan_slayer"}, TextFormatting.BLUE, new DamageEvent(), false, false, true).setMaxLevel(1).addBlackTags("sharper_edge", "enraged");
    public static final BasicTag CRITICAL_STRIKE = new WorldInteractTag(new String[]{"sharper_edge", "gilded_edge", "infinity_edge"}, TextFormatting.YELLOW, new CriticalStrikeEvent(), false, false, true).setMaxLevel(2).addBlackTags("enraged", "giant_slayer");
    public static final BasicTag INSTA_KILL = new WorldInteractTag(new String[]{"enraged", "exasperating", "exodian"}, TextFormatting.DARK_BLUE, new InstaKillEvent(), false, false, true).setMaxLevel(2).addBlackTags("sharper_edge", "giant_slayer");
    public static final BasicTag MOB_RAISE = new WorldInteractTag(new String[]{"taming", "automotonizing"}, TextFormatting.DARK_GREEN, new RaisingEvent(), false, false, true).setMaxLevel(1).addBlackTags("hailey's_wrath", "taming");
    public static final BasicTag HAMMER_MODE;
    public static final BasicTag SUN_BEAMS;
    public static final BasicTag RAINY_DAY;
    public static final BasicTag GROUP_HARM;
    public static final BasicTag DAMAGE_BOOST;
    public static final BasicTag DAMAGE_DEAL;
    public static final BasicTag BEANSTALK;
    public static final BasicTag BEE_KEEPER;
    public static final BasicTag ORE_SIGHT;
    public static final BasicTag CHARGING;
    public static final BasicTag STEPPING;
    public static final BasicTag BURNING;
    public static final BasicTag UNBREAKING;
    public static final BasicTag AUTOSMELT;
    public static final BasicTag MULTI_SHOT;
    public static final BasicTag LASER_ARROW;
    public static final BasicTag PLACE_LIGHT;
    public static final BasicTag LOCKED;

    public static void finalizeActiveTraits() {
        for (BasicTag t : allTags) {
            if (!t.equals(LOCKED)) {
                LOCKED.addBlackTags(t.name);
            }
            if (!t.active) continue;
            for (BasicTag t2 : allTags) {
                if (!t2.active || t2 == t) continue;
                t.addBlackTags(t2.name);
            }
        }
    }

    public static void removeTagFromList(List<BasicTag> list, BasicTag toRemove) {
        int i = 0;
        while (i < list.size() && !list.get(i).sameTag(toRemove)) {
            ++i;
        }
        list.remove(i);
    }

    public static void removeTagsFromList(List<BasicTag> list, List<BasicTag> toRemove) {
        for (BasicTag t : toRemove) {
            TagHelper.removeTagFromList(list, t);
        }
    }

    public static BasicTag convertToTag(CompoundNBT tag) {
        Set keys = tag.func_150296_c();
        for (BasicTag t : allTags) {
            if (!tag.func_74781_a(TAG_NAME).func_150285_a_().equals(t.name)) continue;
            t = t instanceof EffectTag ? new EffectTag((EffectTag)t) : (t instanceof WorldInteractTag ? new WorldInteractTag((WorldInteractTag)t) : (t instanceof StatBoostTag ? new StatBoostTag((StatBoostTag)t) : new BasicTag(t)));
            for (String s : keys) {
                if (s.equals(TAG_LEVEL) || s.equals(TAG_NAME)) continue;
                t.addValue(s, tag.func_74760_g(s));
            }
            return t.setLevel(tag.func_74762_e(TAG_LEVEL));
        }
        return new BasicTag(NULL_TAG);
    }

    public static CompoundNBT convertToNBT(BasicTag tag) {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_218657_a(TAG_NAME, (INBT)StringNBT.func_229705_a_((String)tag.name));
        nbt.func_74768_a(TAG_LEVEL, tag.level);
        Set<String> keys = tag.extraValues.keySet();
        for (String s : keys) {
            nbt.func_74776_a(s, tag.extraValues.get(s).floatValue());
        }
        return nbt;
    }

    public static List<BasicTag> getCompatibleTags(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IRLTool)) {
            return allTags;
        }
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag t : ((IRLTool)stack.func_77973_b()).getAllowedTags()) {
            allowedTags.add(t);
        }
        ListNBT heldTags = nbt.func_150295_c(TAG_LIST, 10);
        for (int i = 0; i < heldTags.size(); ++i) {
            BasicTag tg = TagHelper.convertToTag(heldTags.func_150305_b(i));
            for (String toRemove : tg.incompatibleTags) {
                allowedTags.remove(tagMap.get(toRemove));
            }
        }
        return allowedTags;
    }

    public static ItemStack addTag(ItemStack stack, String tagName, World worldIn) {
        TagHelper.addTag(stack, tagMap.get(tagName), worldIn);
        return stack;
    }

    public static ItemStack addTag(ItemStack stack, BasicTag tag, World worldIn) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        if (!((Boolean)Config.traitsEnabled.get(tag.name).get()).booleanValue()) {
            return stack;
        }
        ListNBT heldTags = nbt.func_150295_c(TAG_LIST, 10);
        ListNBT newList = new ListNBT();
        boolean upgraded = false;
        for (int i = 0; i < heldTags.size(); ++i) {
            BasicTag newTag = TagHelper.convertToTag(heldTags.func_150305_b(i));
            CompoundNBT tagAsNBT = heldTags.func_150305_b(i);
            System.out.println("Tool already has: " + newTag.name + " at level " + newTag.level);
            if (newTag.sameTag(tag)) {
                int lvl = newTag.level;
                if (newTag.level < newTag.maxLevel) {
                    ++lvl;
                }
                tagAsNBT.func_74768_a(TAG_LEVEL, lvl);
                upgraded = true;
            }
            newList.add((Object)tagAsNBT);
        }
        if (!upgraded && TagHelper.getCompatibleTags(stack).contains(tag)) {
            tag.onTagAdded(stack, worldIn, null, null, null, null);
            newList.add((Object)TagHelper.convertToNBT(tag));
        }
        nbt.func_218657_a(TAG_LIST, (INBT)newList);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack removeTag(ItemStack stack, String tagName) {
        for (BasicTag tag : allTags) {
            if (!tag.name.equals(tagName)) continue;
            TagHelper.removeTag(stack, tag);
            return stack;
        }
        return stack;
    }

    public static ItemStack removeTag(ItemStack stack, BasicTag tag) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ListNBT heldTags = nbt.func_150295_c(TAG_LIST, 10);
        ListNBT newList = new ListNBT();
        for (int i = 0; i < heldTags.size(); ++i) {
            if (TagHelper.convertToTag(heldTags.func_150305_b(i)).sameTag(tag)) continue;
            newList.add((Object)heldTags.func_150305_b(i));
        }
        nbt.func_218657_a(TAG_LIST, (INBT)newList);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static ItemStack removeAllTags(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ListNBT heldTags = nbt.func_150295_c(TAG_LIST, 10);
        heldTags.clear();
        stack.func_77982_d(nbt);
        return stack;
    }

    public static boolean checkForTag(ItemStack stack, BasicTag tag) {
        List<BasicTag> tags = TagHelper.getTagList(stack);
        for (BasicTag t : tags) {
            if (!t.sameTag(tag)) continue;
            return true;
        }
        return false;
    }

    public static List<BasicTag> getTagList(ItemStack stack) {
        ArrayList<BasicTag> tags = new ArrayList<BasicTag>();
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ListNBT heldTags = nbt.func_150295_c(TAG_LIST, 10);
        for (int i = 0; i < heldTags.size(); ++i) {
            CompoundNBT tag = heldTags.func_150305_b(i);
            tags.add(TagHelper.convertToTag(tag));
        }
        return tags;
    }

    public static BasicTag copyTag(BasicTag t) {
        return TagHelper.convertToTag(TagHelper.convertToNBT(t));
    }

    public static String convertToTitleCaseIteratingChars(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        text = text.replaceAll("_", " ");
        StringBuilder converted = new StringBuilder();
        boolean convertNext = true;
        for (char ch : text.toCharArray()) {
            if (Character.isSpaceChar(ch)) {
                convertNext = true;
            } else if (convertNext) {
                ch = Character.toTitleCase(ch);
                convertNext = false;
            } else {
                ch = Character.toLowerCase(ch);
            }
            converted.append(ch);
        }
        return converted.toString();
    }

    public static void main(String[] args) {
    }

    static {
        UNBREAKING = new WorldInteractTag(new String[]{"fortified", "reinforced", "plated", "everlasting"}, TextFormatting.BLUE, new UnbreakingEvent(), true, true, true).addBlackTags("filling", "excavating").setMaxLevel(3);
        AUTOSMELT = new WorldInteractTag(new String[]{"auto_smelt"}, TextFormatting.DARK_RED, new AutoSmeltEvent(), true, false, false).addBlackTags("excavating", "explosive").addCraftMaterial(Items.field_151072_bj, 32, 0);
        HAMMER_MODE = new WorldInteractTag(new String[]{"excavating", "world_breaking"}, TextFormatting.DARK_BLUE, new MultiBreakEvent(), true, false, false).setMaxLevel(1).addBlackTags("fortified", "explosive", "auto-smelt");
        SUN_BEAMS = new WorldInteractTag(new String[]{"sun_bathing"}, TextFormatting.YELLOW, new LightBoostEvent(), true, false, true);
        RAINY_DAY = new StatBoostTag(new String[]{"rained_out"}, TextFormatting.DARK_AQUA, new WeatherBoostEvent(), true, false, true);
        GROUP_HARM = new WorldInteractTag(new String[]{"crowd_pleaser"}, TextFormatting.DARK_PURPLE, new GangBangEvent(), false, false, true);
        DAMAGE_BOOST = new StatBoostTag(new String[]{"sturdy"}, TextFormatting.GOLD, new LowDurabilityBoostEvent(), true, false, false);
        DAMAGE_DEAL = new WorldInteractTag(new String[]{"fierce", "feisty"}, TextFormatting.RED, new LowDurabilityAttackEvent(), false, false, true).setMaxLevel(1);
        BEANSTALK = new WorldInteractTag(new String[]{"stalky"}, TextFormatting.GREEN, new BeanStalkEvent(), false, false, true).addBlackTags("hailey's_wrath", "taming");
        BEE_KEEPER = new WorldInteractTag(new String[]{"hailey's_wrath"}, TextFormatting.YELLOW, new BeeSummonEvent(), false, false, true).addBlackTags("taming", "stalky");
        ORE_SIGHT = new WorldInteractTag(new String[]{"ore_sight"}, TextFormatting.AQUA, new OreFindEvent(), true, false, false);
        ChargingEvent ce = new ChargingEvent();
        CHARGING = new WorldInteractTag(new String[]{"charged"}, TextFormatting.AQUA, ce, false, false, true).addValue("rl_charge", 0.0f);
        STEPPING = new WorldInteractTag(new String[]{"long_legged", "elastic_legs", "stilted"}, TextFormatting.DARK_GREEN, new LongLeggedEvent(), false, true, false).setMaxLevel(2);
        BURNING = new WorldInteractTag(new String[]{"fire_storm", "solar_flare"}, TextFormatting.RED, new BurningEvent(), false, true, false).setMaxLevel(1);
        MULTI_SHOT = new WorldInteractTag(new String[]{"twin_shooter", "triple_shot"}, TextFormatting.DARK_BLUE, new MultiShotEvent(), false, false, false).setBowTag().setMaxLevel(1);
        LASER_ARROW = new WorldInteractTag(new String[]{"end_arrows"}, TextFormatting.LIGHT_PURPLE, new LaserArrowEvent(), false, false, false).setBowTag();
        PLACE_LIGHT = new WorldInteractTag(new String[]{"illuminated"}, TextFormatting.YELLOW, new PlaceLightEvent(), true, false, false).setActive();
        LOCKED = new BasicTag("locked", TextFormatting.WHITE).addCraftMaterial(Items.field_151156_bN, 1, 0).setUniversal().setUnnatural();
    }
}

