/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tags.worldinteract;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import xyz.marstonconnell.randomloot.tags.WorldInteractEvent;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;

@Mod.EventBusSubscriber(modid="randomloot")
public class ChargingEvent
extends WorldInteractEvent {
    static int maxCharge = 5;
    static int time = 0;
    static int maxTime = 100;
    static Map<String, Float> extras;
    static ArrayList<ItemStack> items;

    public void addExtras(Map<String, Float> extrasIn) {
        extras = extrasIn;
    }

    @SubscribeEvent
    public static void tickEvent(TickEvent.ServerTickEvent event) {
        if (event.side == LogicalSide.SERVER && ++time > maxTime) {
            time = 0;
            for (ItemStack s : items) {
                if (!(s.func_77973_b() instanceof IRLTool)) continue;
                float charge = ToolUtilities.getFloatNBT(s, "rl_charge") + 1.0f;
                if (charge > (float)maxCharge) {
                    charge = maxCharge;
                }
                ToolUtilities.setFloatNBT(s, "rl_charge", charge);
                DecimalFormat df = new DecimalFormat("#0");
                ToolUtilities.setLore(s, TextFormatting.AQUA + df.format(charge / (float)maxCharge * 100.0f) + "% charged", null);
            }
        }
    }

    @Override
    public void effect(int level, ItemStack stack, World worldIn, LivingEntity entityLiving, BlockState state, BlockPos pos, Entity t) {
        if (!(t instanceof LivingEntity)) {
            return;
        }
        LivingEntity target = (LivingEntity)t;
        if (!items.contains(stack)) {
            this.onAdd(level, stack, worldIn, entityLiving, state, pos, (Entity)target);
        }
        float chargeLevel = ToolUtilities.getFloatNBT(stack, "rl_charge");
        target.field_70172_ad = 0;
        target.field_70737_aN = 0;
        target.func_70097_a(new IndirectEntityDamageSource("indirectMagic", (Entity)entityLiving, null).func_76348_h().func_82726_p(), chargeLevel);
        ToolUtilities.setFloatNBT(stack, "rl_charge", 0.0f);
    }

    @Override
    public void onAdd(int level, ItemStack stack, World worldIn, LivingEntity entityLiving, BlockState state, BlockPos pos, Entity target) {
        items.add(stack);
        ToolUtilities.setFloatNBT(stack, "rl_charge", 0.0f);
    }

    static {
        items = new ArrayList();
    }
}

