/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tags.worldinteract;

import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import xyz.marstonconnell.randomloot.tags.WorldInteractEvent;
import xyz.marstonconnell.randomloot.tools.RLToolItem;

public class MultiBreakEvent
extends WorldInteractEvent {
    @Override
    public void effect(int level, ItemStack stack, World worldIn, LivingEntity entityLiving, BlockState state, BlockPos pos, Entity targetEntity) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        if (!(stack.func_77973_b() instanceof RLToolItem)) {
            return;
        }
        RLToolItem item = (RLToolItem)stack.func_77973_b();
        PlayerEntity player = (PlayerEntity)entityLiving;
        worldIn.func_175656_a(pos, state);
        RayTraceResult trace = MultiBreakEvent.calcRayTrace(worldIn, player, RayTraceContext.FluidMode.ANY);
        if (trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            for (int a = -level; a <= level; ++a) {
                for (int b = -level; b <= level; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.func_177982_a(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.func_177982_a(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.func_177982_a(0, a, b);
                    }
                    MultiBreakEvent.attemptBreak(worldIn, target, pos, player, item.getEffectiveMaterials(), item.getEffectiveOn(), true);
                }
            }
        }
    }

    public static void attemptBreak(World world, BlockPos target, BlockPos origin, PlayerEntity player, Set<Material> effectiveMaterials, Set<Block> effectiveOn, boolean checkHarvestLevel) {
        float targetHard;
        BlockState originState;
        float originHard;
        BlockState state = world.func_180495_p(target);
        if (checkHarvestLevel && !ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)target)) {
            return;
        }
        if (!effectiveMaterials.contains(state.func_185904_a()) && !effectiveOn.contains(state.func_177230_c())) {
            return;
        }
        if (origin != null && (originHard = (originState = world.func_180495_p(origin)).func_185903_a(player, (IBlockReader)world, origin)) / (targetHard = state.func_185903_a(player, (IBlockReader)world, target)) > 10.0f) {
            return;
        }
        ServerPlayerEntity spe = (ServerPlayerEntity)player;
        int expDropped = ForgeHooks.onBlockBreakEvent((World)world, (GameType)spe.field_71134_c.func_73081_b(), (ServerPlayerEntity)spe, (BlockPos)target);
        Block block = state.func_177230_c();
        if (block.removedByPlayer(state, world, target, player, true, world.func_204610_c(target))) {
            block.func_176206_d((IWorld)world, target, state);
            block.func_180657_a(world, player, target, state, world.func_175625_s(target), player.func_184614_ca());
            block.func_180637_b((ServerWorld)world, target, expDropped);
        }
    }

    public static void attemptBreak(World world, BlockPos target, PlayerEntity player, Set<Material> effectiveMaterials, Set<Block> effectiveOn, boolean checkHarvestLevel) {
        MultiBreakEvent.attemptBreak(world, target, null, player, effectiveMaterials, effectiveOn, checkHarvestLevel);
    }

    public static RayTraceResult calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vector3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }

    @Override
    public void onAdd(int level, ItemStack stack, World worldIn, LivingEntity entityLiving, BlockState state, BlockPos pos, Entity target) {
    }
}

