/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tags.worldinteract;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import xyz.marstonconnell.randomloot.blocks.LightBall;
import xyz.marstonconnell.randomloot.tags.WorldInteractEvent;
import xyz.marstonconnell.randomloot.utils.Registration;

public class PlaceLightEvent
extends WorldInteractEvent {
    @Override
    public void effect(int level, ItemStack stack, World worldIn, LivingEntity entityLiving, BlockState state, BlockPos pos, Entity target) {
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityLiving;
        RayTraceResult trace = PlaceLightEvent.calcRayTrace(worldIn, player, RayTraceContext.FluidMode.ANY);
        if (trace.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockRayTraceResult blockTrace = (BlockRayTraceResult)trace;
            Direction face = blockTrace.func_216354_b();
            BlockPos p = blockTrace.func_216350_a();
            switch (face) {
                case DOWN: {
                    p = p.func_177982_a(0, -1, 0);
                    break;
                }
                case UP: {
                    p = p.func_177982_a(0, 1, 0);
                    break;
                }
                case WEST: {
                    p = p.func_177982_a(-1, 0, 0);
                    break;
                }
                case EAST: {
                    p = p.func_177982_a(1, 0, 0);
                    break;
                }
                case NORTH: {
                    p = p.func_177982_a(0, 0, -1);
                    break;
                }
                case SOUTH: {
                    p = p.func_177982_a(0, 0, 1);
                    break;
                }
            }
            worldIn.func_175656_a(p, ((LightBall)Registration.LIGHT_BALL.get()).func_176223_P());
            stack.func_196085_b(stack.func_77952_i() + 4 + (int)(Math.random() * 3.0));
        }
    }

    @Override
    public void onAdd(int level, ItemStack stack, World worldIn, LivingEntity entityLiving, BlockState state, BlockPos pos, Entity target) {
    }

    public static RayTraceResult calcRayTrace(World worldIn, PlayerEntity player, RayTraceContext.FluidMode fluidMode) {
        float f = player.field_70125_A;
        float f1 = player.field_70177_z;
        Vector3d vector3d = player.func_174824_e(1.0f);
        float f2 = MathHelper.func_76134_b((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = MathHelper.func_76126_a((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
        float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get()).func_111126_e();
        Vector3d vector3d1 = vector3d.func_72441_c((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.func_217299_a(new RayTraceContext(vector3d, vector3d1, RayTraceContext.BlockMode.OUTLINE, fluidMode, (Entity)player));
    }
}

