/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.EffectTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tags.WorldInteractTag;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.RLToolItem;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;
import xyz.marstonconnell.randomloot.utils.Config;

public class RLAxeItem
extends RLToolItem
implements IRLTool {
    private static final Set<Material> EFFECTIVE_ON_MATERIALS = Sets.newHashSet((Object[])new Material[]{Material.field_151575_d, Material.field_237214_y_, Material.field_151585_k, Material.field_151582_l, Material.field_215713_z, Material.field_151572_C});
    public static final Set<Block> EFFECTIVE_ON_BLOCKS = Sets.newHashSet((Object[])new Block[]{Blocks.field_150468_ap, Blocks.field_222420_lI, Blocks.field_196689_eF, Blocks.field_196691_eG, Blocks.field_196693_eH, Blocks.field_196695_eI, Blocks.field_196699_eK, Blocks.field_196697_eJ, Blocks.field_235358_mQ_, Blocks.field_235359_mR_});
    protected static final Map<Block, Block> BLOCK_STRIPPING_MAP = new ImmutableMap.Builder().put((Object)Blocks.field_196626_Q, (Object)Blocks.field_209389_ab).put((Object)Blocks.field_196617_K, (Object)Blocks.field_203204_R).put((Object)Blocks.field_196639_V, (Object)Blocks.field_209394_ag).put((Object)Blocks.field_196623_P, (Object)Blocks.field_203209_W).put((Object)Blocks.field_196637_U, (Object)Blocks.field_209393_af).put((Object)Blocks.field_196621_O, (Object)Blocks.field_203208_V).put((Object)Blocks.field_196631_S, (Object)Blocks.field_209391_ad).put((Object)Blocks.field_196619_M, (Object)Blocks.field_203206_T).put((Object)Blocks.field_196634_T, (Object)Blocks.field_209392_ae).put((Object)Blocks.field_196620_N, (Object)Blocks.field_203207_U).put((Object)Blocks.field_196629_R, (Object)Blocks.field_209390_ac).put((Object)Blocks.field_196618_L, (Object)Blocks.field_203205_S).put((Object)Blocks.field_235368_mh_, (Object)Blocks.field_235369_mi_).put((Object)Blocks.field_235370_mj_, (Object)Blocks.field_235371_mk_).put((Object)Blocks.field_235377_mq_, (Object)Blocks.field_235378_mr_).put((Object)Blocks.field_235379_ms_, (Object)Blocks.field_235380_mt_).build();

    @Override
    public Set<Material> getEffectiveMaterials() {
        return EFFECTIVE_ON_MATERIALS;
    }

    public RLAxeItem(String name) {
        super(name, EFFECTIVE_ON_BLOCKS, 5.0f, -3.0f);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        HashSet<ToolType> hs = new HashSet<ToolType>();
        hs.add(ToolType.AXE);
        return hs;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        BlockPos blockpos;
        World world = context.func_195991_k();
        BlockState blockstate = world.func_180495_p(blockpos = context.func_195995_a());
        Block block = BLOCK_STRIPPING_MAP.get(blockstate.func_177230_c());
        if (block != null) {
            PlayerEntity playerentity = context.func_195999_j();
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_203255_y, SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, (BlockState)block.func_176223_P().func_206870_a((Property)RotatedPillarBlock.field_176298_M, blockstate.func_177229_b((Property)RotatedPillarBlock.field_176298_M)), 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220040_1_ -> p_220040_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Override
    public String getItemType() {
        return "axe";
    }

    public boolean func_150897_b(BlockState blockIn) {
        int i = 4;
        if (blockIn.getHarvestTool() == ToolType.AXE) {
            return i >= blockIn.getHarvestLevel();
        }
        Material material = blockIn.func_185904_a();
        return EFFECTIVE_ON_MATERIALS.contains(material);
    }

    @Override
    public float func_150893_a(ItemStack stack, BlockState state) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        float speedBonus = nbt.func_74760_g("rl_dig_speed");
        Material material = state.func_185904_a();
        return EFFECTIVE_ON_MATERIALS.contains(material) ? super.func_150893_a(stack, state) + speedBonus - 1.0f : super.func_150893_a(stack, state);
    }

    @Override
    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        ToolUtilities.changeXP(stack, 1, attacker.func_130014_f_(), attacker.func_233580_cy_());
        ToolUtilities.setLore(stack, attacker.func_130014_f_());
        List<BasicTag> tags = TagHelper.getTagList(stack);
        for (int i = 0; i < tags.size(); ++i) {
            BasicTag eTag;
            if (tags.get((int)i).active) continue;
            if (tags.get(i) instanceof EffectTag) {
                eTag = (EffectTag)tags.get(i);
                if (((EffectTag)eTag).offensive) {
                    ((EffectTag)eTag).runEffect(stack, attacker.field_70170_p, target);
                    continue;
                }
                ((EffectTag)eTag).runEffect(stack, attacker.field_70170_p, attacker);
                continue;
            }
            if (!(tags.get(i) instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tags.get(i);
            if (!((WorldInteractTag)eTag).forWeapons) continue;
            ((WorldInteractTag)eTag).runEffect(stack, attacker.field_70170_p, attacker, attacker.func_130014_f_().func_180495_p(new BlockPos(attacker.func_213303_ch())), new BlockPos(attacker.func_213303_ch()), (Entity)target);
        }
        return true;
    }

    @Override
    public List<BasicTag> getAllowedTags() {
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            if (!tag.forTools && !tag.forWeapons) continue;
            allowedTags.add(tag);
        }
        return allowedTags;
    }

    @Override
    public void setStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int dmg = (Integer)Config.BASE_AXE_DAMAGE.get();
        double spd = (Double)Config.BASE_AXE_ATTACK_SPEED.get();
        nbt.func_74768_a("rl_damage", dmg);
        nbt.func_74780_a("rl_speed", spd);
        nbt.func_74776_a("rl_dig_speed", 1.0f);
        ToolUtilities.setIntNBT(stack, "rl_level", 1);
        stack.func_77982_d(nbt);
    }

    @Override
    public void updateStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        CompoundNBT damage = new CompoundNBT();
        damage.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.attack_damage"));
        damage.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.attack_damage"));
        int dmg = nbt.func_74762_e("rl_damage");
        double spd = nbt.func_74769_h("rl_speed");
        damage.func_218657_a("Amount", (INBT)IntNBT.func_229692_a_((int)dmg));
        damage.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        IntArrayNBT UUID2 = new IntArrayNBT(new int[]{1, 2, 3, 4});
        damage.func_218657_a("UUID", (INBT)UUID2);
        damage.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)"mainhand"));
        CompoundNBT speed = new CompoundNBT();
        speed.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.attack_speed"));
        speed.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.attack_speed"));
        speed.func_218657_a("Amount", (INBT)DoubleNBT.func_229684_a_((double)spd));
        speed.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        UUID2 = new IntArrayNBT(new int[]{5, 6, 7, 8});
        speed.func_218657_a("UUID", (INBT)UUID2);
        speed.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)"mainhand"));
        ListNBT modifiers = new ListNBT();
        modifiers.add((Object)damage);
        modifiers.add((Object)speed);
        nbt.func_218657_a("AttributeModifiers", (INBT)modifiers);
        stack.func_77982_d(nbt);
    }

    @Override
    public void upgradeTool(ItemStack stack, World worldIn) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a("rl_damage", nbt.func_74762_e("rl_damage") + 1);
        nbt.func_74780_a("rl_speed", nbt.func_74769_h("rl_speed") * 0.9);
        nbt.func_74776_a("rl_dig_speed", nbt.func_74760_g("rl_dig_speed") * 1.1f);
        stack.func_77982_d(nbt);
        this.updateStats(stack);
        ToolUtilities.setLore(stack, worldIn);
    }

    @Override
    public List<String> getStatsLore(ItemStack stack) {
        DecimalFormat f = new DecimalFormat("#0.00");
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ArrayList<String> s = new ArrayList<String>();
        s.add(TextFormatting.GRAY + "Attack Damage: " + nbt.func_74762_e("rl_damage"));
        s.add(TextFormatting.GRAY + "Attack Speed: " + f.format(4.0 + nbt.func_74769_h("rl_speed")));
        s.add(TextFormatting.GRAY + "Dig Speed: " + f.format(this.field_77864_a - 1.0f + nbt.func_74760_g("rl_dig_speed")));
        return s;
    }

    @Override
    public int getVariants() {
        return 11;
    }
}

