/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xyz.marstonconnell.randomloot.init.RLItems;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.EffectTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tags.WorldInteractTag;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.RLShootableItem;
import xyz.marstonconnell.randomloot.tools.TextureProxy;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;

public class RLBowItem
extends RLShootableItem
implements IRLTool {
    public RLBowItem(String name) {
        super(new Item.Properties());
        this.setRegistryName(new ResourceLocation("randomloot", name));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            TextureProxy.setModelProperties(this);
        }
        RLItems.ITEMS.add((Item)this);
    }

    private float getVelo(ItemStack stack) {
        return ToolUtilities.getFloatNBT(stack, "rl_velo");
    }

    private void setVelo(ItemStack stack, float velo) {
        ToolUtilities.setFloatNBT(stack, "rl_velo", velo);
    }

    public void addVelo(float num, ItemStack stack) {
        this.setVelo(stack, this.getVelo(stack) + num);
    }

    public void func_77615_a(ItemStack stack, World worldIn, LivingEntity entityLiving, int timeLeft) {
        float f;
        if (!(entityLiving instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity playerentity = (PlayerEntity)entityLiving;
        boolean infinite = playerentity.field_71075_bZ.field_75098_d || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185312_x, (ItemStack)stack) > 0;
        ItemStack itemstack = playerentity.func_213356_f(stack);
        int i = this.func_77626_a(stack) - timeLeft;
        if ((i = ForgeEventFactory.onArrowLoose((ItemStack)stack, (World)worldIn, (PlayerEntity)playerentity, (int)i, (!itemstack.func_190926_b() || infinite ? 1 : 0) != 0)) < 0) {
            return;
        }
        if (itemstack.func_190926_b() && !infinite) {
            return;
        }
        if (itemstack.func_190926_b()) {
            itemstack = new ItemStack((IItemProvider)Items.field_151032_g);
        }
        if (!((double)(f = RLBowItem.getArrowVelocity(i)) < 0.1)) {
            boolean flag1;
            boolean bl = flag1 = playerentity.field_71075_bZ.field_75098_d || itemstack.func_77973_b() instanceof ArrowItem && ((ArrowItem)itemstack.func_77973_b()).isInfinite(itemstack, stack, playerentity);
            if (!worldIn.field_72995_K) {
                int k;
                int j;
                ArrowItem arrowitem = (ArrowItem)(itemstack.func_77973_b() instanceof ArrowItem ? itemstack.func_77973_b() : Items.field_151032_g);
                double dmgMod = ToolUtilities.getFloatNBT(stack, "rl_bow_dmg");
                ArrowEntity abstractarrowentity = (ArrowEntity)arrowitem.func_200887_a(worldIn, itemstack, (LivingEntity)playerentity);
                abstractarrowentity = this.customArrow(stack, abstractarrowentity);
                abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() * dmgMod);
                abstractarrowentity.func_234612_a_((Entity)playerentity, playerentity.field_70125_A, playerentity.field_70177_z, 0.0f, f * 3.0f, 1.0f);
                if (f == 1.0f) {
                    abstractarrowentity.func_70243_d(true);
                }
                if ((j = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185309_u, (ItemStack)stack)) > 0) {
                    abstractarrowentity.func_70239_b(abstractarrowentity.func_70242_d() + (double)j * 0.5 + 0.5);
                }
                if ((k = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185310_v, (ItemStack)stack)) > 0) {
                    abstractarrowentity.func_70240_a(k);
                }
                if (EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185311_w, (ItemStack)stack) > 0) {
                    abstractarrowentity.func_70015_d(100);
                }
                stack.func_222118_a(1, (LivingEntity)playerentity, p_220009_1_ -> p_220009_1_.func_213334_d(playerentity.func_184600_cs()));
                if (flag1 || playerentity.field_71075_bZ.field_75098_d && (itemstack.func_77973_b() == Items.field_185166_h || itemstack.func_77973_b() == Items.field_185167_i)) {
                    abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
                if (!TagHelper.getTagList(stack).isEmpty()) {
                    abstractarrowentity.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                }
                List<BasicTag> tags = TagHelper.getTagList(stack);
                for (int p = 0; p < tags.size(); ++p) {
                    if (tags.get((int)i).active || !(tags.get(p) instanceof WorldInteractTag)) continue;
                    WorldInteractTag eTag = (WorldInteractTag)tags.get(p);
                    eTag.runEffect(stack, worldIn, entityLiving, null, entityLiving.func_233580_cy_(), (Entity)abstractarrowentity);
                }
                worldIn.func_217376_c((Entity)abstractarrowentity);
                ToolUtilities.changeXP(stack, 1, worldIn, entityLiving.func_233580_cy_());
                ToolUtilities.setLore(stack, worldIn);
            }
            worldIn.func_184148_a((PlayerEntity)null, playerentity.func_226277_ct_(), playerentity.func_226278_cu_(), playerentity.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            if (!flag1 && !playerentity.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
                if (itemstack.func_190926_b()) {
                    playerentity.field_71071_by.func_184437_d(itemstack);
                }
            }
            playerentity.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        }
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public int func_77626_a(ItemStack stack) {
        return (int)this.getVelo(stack);
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        boolean flag = playerIn.func_213356_f(itemstack).func_190926_b();
        System.out.println("has arrow? " + !flag);
        ActionResult ret = ForgeEventFactory.onArrowNock((ItemStack)itemstack, (World)worldIn, (PlayerEntity)playerIn, (Hand)handIn, (!flag ? 1 : 0) != 0);
        if (ret != null) {
            return ret;
        }
        System.out.println("shooting");
        if (!playerIn.field_71075_bZ.field_75098_d && flag) {
            System.out.println("fail");
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    @Override
    public Predicate<ItemStack> func_220004_b() {
        return field_220007_a;
    }

    public ArrowEntity customArrow(ItemStack stack, ArrowEntity arrow) {
        List<BasicTag> tags = TagHelper.getTagList(stack);
        for (int i = 0; i < tags.size(); ++i) {
            if (tags.get((int)i).active || !(tags.get(i) instanceof EffectTag)) continue;
            EffectTag eTag = (EffectTag)tags.get(i);
            if (!eTag.offensive) continue;
            arrow.func_184558_a(eTag.getEffect());
        }
        return arrow;
    }

    @Override
    public int func_230305_d_() {
        return 15;
    }

    @Override
    public void setStats(ItemStack stack) {
        this.setVelo(stack, 72000.0f);
        ToolUtilities.setIntNBT(stack, "rl_level", 1);
        ToolUtilities.setFloatNBT(stack, "rl_bow_dmg", 1.0f);
    }

    @Override
    public void updateStats(ItemStack stack) {
    }

    @Override
    public void upgradeTool(ItemStack stack, World worldIn) {
        this.setVelo(stack, this.getVelo(stack) * 0.95f);
        ToolUtilities.setFloatNBT(stack, "rl_bow_dmg", ToolUtilities.getFloatNBT(stack, "rl_bow_dmg") * 1.2f);
    }

    @Override
    public List<String> getStatsLore(ItemStack stack) {
        DecimalFormat f = new DecimalFormat("#0.00");
        ArrayList<String> s = new ArrayList<String>();
        s.add(TextFormatting.GRAY + "Pull Speed: " + f.format(this.getVelo(stack) / 72000.0f * 100.0f) + "%");
        s.add(TextFormatting.GRAY + "Bow Damage Modifier: " + f.format(ToolUtilities.getFloatNBT(stack, "rl_bow_dmg")));
        return s;
    }

    @Override
    public String getItemType() {
        return "bow";
    }

    @Override
    public int getVariants() {
        return 6;
    }

    @Override
    public List<BasicTag> getAllowedTags() {
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            if (!tag.forBows) continue;
            allowedTags.add(tag);
        }
        return allowedTags;
    }
}

