/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import com.google.common.collect.ImmutableSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.RLToolItem;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;
import xyz.marstonconnell.randomloot.utils.Config;

public class RLPickaxeItem
extends RLToolItem
implements IRLTool {
    private static final Set<Block> EFFECTIVE_ON = ImmutableSet.of((Object)Blocks.field_150408_cc, (Object)Blocks.field_150365_q, (Object)Blocks.field_150347_e, (Object)Blocks.field_150319_E, (Object)Blocks.field_150484_ah, (Object)Blocks.field_150482_ag, (Object[])new Block[]{Blocks.field_196552_aC, Blocks.field_150340_R, Blocks.field_150352_o, Blocks.field_235334_I_, Blocks.field_150432_aD, Blocks.field_150339_S, Blocks.field_150366_p, Blocks.field_150368_y, Blocks.field_150369_x, Blocks.field_150341_Y, Blocks.field_150424_aL, Blocks.field_150403_cj, Blocks.field_205164_gk, Blocks.field_150448_aq, Blocks.field_150450_ax, Blocks.field_150322_A, Blocks.field_196583_aj, Blocks.field_196585_ak, Blocks.field_196798_hA, Blocks.field_196799_hB, Blocks.field_180395_cM, Blocks.field_150348_b, Blocks.field_196650_c, Blocks.field_196652_d, Blocks.field_196654_e, Blocks.field_196655_f, Blocks.field_196656_g, Blocks.field_196657_h, Blocks.field_150333_U, Blocks.field_222401_hJ, Blocks.field_196640_bx, Blocks.field_196643_by, Blocks.field_196646_bz, Blocks.field_196571_bA, Blocks.field_196573_bB, Blocks.field_196575_bC, Blocks.field_196576_bD, Blocks.field_196578_bE, Blocks.field_185771_cX, Blocks.field_196581_bI, Blocks.field_196582_bJ, Blocks.field_196580_bH, Blocks.field_196579_bG, Blocks.field_150430_aB, Blocks.field_150456_au, Blocks.field_222446_lj, Blocks.field_222447_lk, Blocks.field_222448_ll, Blocks.field_222449_lm, Blocks.field_222450_ln, Blocks.field_222451_lo, Blocks.field_222452_lp, Blocks.field_222453_lq, Blocks.field_222454_lr, Blocks.field_222455_ls, Blocks.field_222456_lt, Blocks.field_222457_lu, Blocks.field_222458_lv, Blocks.field_204409_il, Blocks.field_190975_dA, Blocks.field_190988_dw, Blocks.field_190989_dx, Blocks.field_190986_du, Blocks.field_190984_ds, Blocks.field_190990_dy, Blocks.field_190980_do, Blocks.field_196875_ie, Blocks.field_190982_dq, Blocks.field_190979_dn, Blocks.field_190978_dm, Blocks.field_190983_dr, Blocks.field_190987_dv, Blocks.field_190991_dz, Blocks.field_190977_dl, Blocks.field_190981_dp, Blocks.field_150331_J, Blocks.field_150320_F, Blocks.field_150332_K});

    @Override
    public Set<Block> getEffectiveOn() {
        return EFFECTIVE_ON;
    }

    public RLPickaxeItem(String name) {
        super(name, EFFECTIVE_ON, 2.0f, -2.8f);
    }

    @Override
    public String getItemType() {
        return "pickaxe";
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        HashSet<ToolType> hs = new HashSet<ToolType>();
        hs.add(ToolType.PICKAXE);
        return hs;
    }

    public int getHarvestLevel(ItemStack stack, ToolType tool, PlayerEntity player, BlockState blockState) {
        return super.getHarvestLevel(stack, tool, player, blockState);
    }

    public boolean func_150897_b(BlockState blockIn) {
        if (blockIn.getHarvestTool() == ToolType.PICKAXE) {
            return true;
        }
        Material material = blockIn.func_185904_a();
        return material == Material.field_151576_e || material == Material.field_151573_f || material == Material.field_151574_g;
    }

    @Override
    public float func_150893_a(ItemStack stack, BlockState state) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        float speedBonus = nbt.func_74760_g("rl_dig_speed");
        Material material = state.func_185904_a();
        float f = this.getToolTypes(stack).stream().anyMatch(e -> state.isToolEffective(e)) ? this.field_77864_a : (EFFECTIVE_ON.contains(state.func_177230_c()) ? this.field_77864_a : 1.0f);
        return material != Material.field_151573_f && material != Material.field_151574_g && material != Material.field_151576_e ? f : this.field_77864_a + speedBonus - 1.0f;
    }

    @Override
    public List<BasicTag> getAllowedTags() {
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            if (!tag.forTools) continue;
            allowedTags.add(tag);
        }
        return allowedTags;
    }

    @Override
    public void setStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int dmg = (Integer)Config.BASE_PICKAXE_DAMAGE.get();
        double spd = (Double)Config.BASE_PICKAXE_ATTACK_SPEED.get();
        nbt.func_74768_a("rl_damage", dmg);
        nbt.func_74780_a("rl_speed", spd);
        nbt.func_74776_a("rl_dig_speed", 1.0f);
        ToolUtilities.setIntNBT(stack, "rl_level", 1);
        stack.func_77982_d(nbt);
    }

    @Override
    public void updateStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        CompoundNBT damage = new CompoundNBT();
        damage.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.attack_damage"));
        damage.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.attack_damage"));
        int dmg = nbt.func_74762_e("rl_damage");
        double spd = nbt.func_74769_h("rl_speed");
        damage.func_218657_a("Amount", (INBT)IntNBT.func_229692_a_((int)dmg));
        damage.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        IntArrayNBT UUID2 = new IntArrayNBT(new int[]{1, 2, 3, 4});
        damage.func_218657_a("UUID", (INBT)UUID2);
        damage.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)"mainhand"));
        CompoundNBT speed = new CompoundNBT();
        speed.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.attack_speed"));
        speed.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.attack_speed"));
        speed.func_218657_a("Amount", (INBT)DoubleNBT.func_229684_a_((double)spd));
        speed.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        UUID2 = new IntArrayNBT(new int[]{5, 6, 7, 8});
        speed.func_218657_a("UUID", (INBT)UUID2);
        speed.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)"mainhand"));
        ListNBT modifiers = new ListNBT();
        modifiers.add((Object)damage);
        modifiers.add((Object)speed);
        nbt.func_218657_a("AttributeModifiers", (INBT)modifiers);
        stack.func_77982_d(nbt);
    }

    @Override
    public void upgradeTool(ItemStack stack, World worldIn) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74780_a("rl_speed", nbt.func_74769_h("rl_speed") * 0.9);
        nbt.func_74776_a("rl_dig_speed", nbt.func_74760_g("rl_dig_speed") * 1.1f);
        stack.func_77982_d(nbt);
        this.updateStats(stack);
        ToolUtilities.setLore(stack, worldIn);
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    @Override
    public List<String> getStatsLore(ItemStack stack) {
        DecimalFormat f = new DecimalFormat("#0.00");
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ArrayList<String> s = new ArrayList<String>();
        s.add(TextFormatting.GRAY + "Attack Damage: " + nbt.func_74762_e("rl_damage"));
        s.add(TextFormatting.GRAY + "Attack Speed: " + f.format(4.0 + nbt.func_74769_h("rl_speed")));
        s.add(TextFormatting.GRAY + "Dig Speed: " + f.format(this.field_77864_a - 1.0f + nbt.func_74760_g("rl_dig_speed")));
        return s;
    }

    @Override
    public int getVariants() {
        return 17;
    }
}

