/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CampfireBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.RLToolItem;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;
import xyz.marstonconnell.randomloot.utils.Config;

public class RLShovelItem
extends RLToolItem
implements IRLTool {
    private static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150346_d, Blocks.field_196660_k, Blocks.field_196661_l, Blocks.field_150458_ak, Blocks.field_196658_i, Blocks.field_150351_n, Blocks.field_150391_bh, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_196604_cC, Blocks.field_150433_aE, Blocks.field_150425_aM, Blocks.field_185774_da, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh, Blocks.field_235336_cN_});
    protected static final Map<Block, BlockState> SHOVEL_LOOKUP = Maps.newHashMap((Map)ImmutableMap.of((Object)Blocks.field_196658_i, (Object)Blocks.field_185774_da.func_176223_P()));

    @Override
    public Set<Block> getEffectiveOn() {
        return EFFECTIVE_ON;
    }

    public RLShovelItem(String name) {
        super(name, EFFECTIVE_ON, 1.5f, -3.0f);
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        HashSet<ToolType> hs = new HashSet<ToolType>();
        hs.add(ToolType.SHOVEL);
        return hs;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = world.func_180495_p(blockpos);
        if (context.func_196000_l() == Direction.DOWN) {
            return ActionResultType.PASS;
        }
        PlayerEntity playerentity = context.func_195999_j();
        BlockState blockstate1 = SHOVEL_LOOKUP.get(blockstate.func_177230_c());
        BlockState blockstate2 = null;
        if (blockstate1 != null && world.func_175623_d(blockpos.func_177984_a())) {
            world.func_184133_a(playerentity, blockpos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
            blockstate2 = blockstate1;
        } else if (blockstate.func_177230_c() instanceof CampfireBlock && ((Boolean)blockstate.func_177229_b((Property)CampfireBlock.field_220101_b)).booleanValue()) {
            if (!world.func_201670_d()) {
                world.func_217378_a((PlayerEntity)null, 1009, blockpos, 0);
            }
            CampfireBlock.func_235475_c_((IWorld)world, (BlockPos)blockpos, (BlockState)blockstate);
            blockstate2 = (BlockState)blockstate.func_206870_a((Property)CampfireBlock.field_220101_b, (Comparable)Boolean.valueOf(false));
        }
        if (blockstate2 != null) {
            if (!world.field_72995_K) {
                world.func_180501_a(blockpos, blockstate2, 11);
                if (playerentity != null) {
                    context.func_195996_i().func_222118_a(1, (LivingEntity)playerentity, p_220041_1_ -> p_220041_1_.func_213334_d(context.func_221531_n()));
                }
            }
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.PASS;
    }

    @Override
    public String getItemType() {
        return "pickaxe";
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_150433_aE) || blockIn.func_203425_a(Blocks.field_196604_cC);
    }

    @Override
    public float func_150893_a(ItemStack stack, BlockState state) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        float speedBonus = nbt.func_74760_g("rl_dig_speed");
        Material material = state.func_185904_a();
        return material != Material.field_151597_y && material != Material.field_151596_z && material != Material.field_151571_B && material != Material.field_151578_c && material != Material.field_151595_p ? super.func_150893_a(stack, state) : super.func_150893_a(stack, state) + speedBonus - 1.0f;
    }

    @Override
    public List<BasicTag> getAllowedTags() {
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            if (!tag.forTools) continue;
            allowedTags.add(tag);
        }
        return allowedTags;
    }

    @Override
    public void setStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int dmg = (Integer)Config.BASE_SPADE_DAMAGE.get();
        double spd = (Double)Config.BASE_SPADE_ATTACK_SPEED.get();
        nbt.func_74768_a("rl_damage", dmg);
        nbt.func_74780_a("rl_speed", spd);
        nbt.func_74776_a("rl_dig_speed", 1.0f);
        ToolUtilities.setIntNBT(stack, "rl_level", 1);
        stack.func_77982_d(nbt);
    }

    @Override
    public void updateStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        CompoundNBT damage = new CompoundNBT();
        damage.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.attack_damage"));
        damage.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.attack_damage"));
        int dmg = nbt.func_74762_e("rl_damage");
        double spd = nbt.func_74769_h("rl_speed");
        damage.func_218657_a("Amount", (INBT)IntNBT.func_229692_a_((int)dmg));
        damage.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        IntArrayNBT UUID2 = new IntArrayNBT(new int[]{1, 2, 3, 4});
        damage.func_218657_a("UUID", (INBT)UUID2);
        damage.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)"mainhand"));
        CompoundNBT speed = new CompoundNBT();
        speed.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.attack_speed"));
        speed.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.attack_speed"));
        speed.func_218657_a("Amount", (INBT)DoubleNBT.func_229684_a_((double)spd));
        speed.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        UUID2 = new IntArrayNBT(new int[]{5, 6, 7, 8});
        speed.func_218657_a("UUID", (INBT)UUID2);
        speed.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)"mainhand"));
        ListNBT modifiers = new ListNBT();
        modifiers.add((Object)damage);
        modifiers.add((Object)speed);
        nbt.func_218657_a("AttributeModifiers", (INBT)modifiers);
        stack.func_77982_d(nbt);
    }

    @Override
    public void upgradeTool(ItemStack stack, World worldIn) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74780_a("rl_speed", nbt.func_74769_h("rl_speed") * 0.9);
        nbt.func_74776_a("rl_dig_speed", nbt.func_74760_g("rl_dig_speed") * 1.1f);
        stack.func_77982_d(nbt);
        this.updateStats(stack);
        ToolUtilities.setLore(stack, worldIn);
    }

    @Override
    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        return super.func_179218_a(stack, worldIn, state, pos, entityLiving);
    }

    @Override
    public List<String> getStatsLore(ItemStack stack) {
        DecimalFormat f = new DecimalFormat("#0.00");
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ArrayList<String> s = new ArrayList<String>();
        s.add(TextFormatting.GRAY + "Attack Damage: " + nbt.func_74762_e("rl_damage"));
        s.add(TextFormatting.GRAY + "Attack Speed: " + f.format(4.0 + nbt.func_74769_h("rl_speed")));
        s.add(TextFormatting.GRAY + "Dig Speed: " + f.format(this.field_77864_a - 1.0f + nbt.func_74760_g("rl_dig_speed")));
        return s;
    }

    @Override
    public int getVariants() {
        return 8;
    }
}

