/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xyz.marstonconnell.randomloot.init.RLItems;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.EffectTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tags.WorldInteractTag;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.TextureProxy;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;
import xyz.marstonconnell.randomloot.utils.Config;

public class RLSwordItem
extends SwordItem
implements IRLTool {
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> attributes;

    @Override
    public int getVariants() {
        return 35;
    }

    @Override
    public List<String> getStatsLore(ItemStack stack) {
        DecimalFormat f = new DecimalFormat("#0.00");
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ArrayList<String> s = new ArrayList<String>();
        s.add(TextFormatting.GRAY + "Attack Damage: " + nbt.func_74762_e("rl_damage"));
        s.add(TextFormatting.GRAY + "Attack Speed: " + f.format(4.0 + nbt.func_74769_h("rl_speed")));
        return s;
    }

    @Override
    public List<BasicTag> getAllowedTags() {
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            if (!tag.forWeapons) continue;
            allowedTags.add(tag);
        }
        return allowedTags;
    }

    public RLSwordItem(String name, int attackDamageIn, float attackSpeedIn) {
        super((IItemTier)ItemTier.DIAMOND, attackDamageIn, attackSpeedIn, new Item.Properties());
        this.attackDamage = attackDamageIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.attributes = builder.build();
        this.setRegistryName(new ResourceLocation("randomloot", name));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            TextureProxy.setModelProperties((Item)this);
        }
        RLItems.ITEMS.add((Item)this);
    }

    @Override
    public String getItemType() {
        return "sword";
    }

    public float func_200894_d() {
        return this.attackDamage;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        if (state.func_203425_a(Blocks.field_196553_aF)) {
            return 15.0f;
        }
        Material material = state.func_185904_a();
        return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_151589_v && !state.func_235714_a_((ITag)BlockTags.field_206952_E) && material != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, livingEntity -> livingEntity.func_213361_c(EquipmentSlotType.MAINHAND));
        if (stack.func_77973_b().equals(Items.field_190931_a)) {
            return false;
        }
        ToolUtilities.changeXP(stack, 1, attacker.func_130014_f_(), attacker.func_233580_cy_());
        ToolUtilities.setLore(stack, attacker.func_130014_f_());
        List<BasicTag> tags = TagHelper.getTagList(stack);
        for (int i = 0; i < tags.size(); ++i) {
            BasicTag eTag;
            if (tags.get((int)i).active) continue;
            if (tags.get(i) instanceof EffectTag) {
                eTag = (EffectTag)tags.get(i);
                if (((EffectTag)eTag).offensive) {
                    ((EffectTag)eTag).runEffect(stack, attacker.field_70170_p, target);
                    continue;
                }
                ((EffectTag)eTag).runEffect(stack, attacker.field_70170_p, attacker);
                continue;
            }
            if (!(tags.get(i) instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tags.get(i);
            ((WorldInteractTag)eTag).runEffect(stack, attacker.field_70170_p, attacker, attacker.func_130014_f_().func_180495_p(new BlockPos(attacker.func_213303_ch())), new BlockPos(attacker.func_213303_ch()), (Entity)target);
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(2, entityLiving, attacker -> attacker.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public boolean func_150897_b(BlockState blockIn) {
        return blockIn.func_203425_a(Blocks.field_196553_aF);
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.attributes : super.func_111205_h(equipmentSlot);
    }

    @Override
    public void setStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int dmg = (Integer)Config.BASE_SWORD_DAMAGE.get();
        double spd = (Double)Config.BASE_SWORD_SPEED.get();
        nbt.func_74768_a("rl_damage", dmg);
        nbt.func_74780_a("rl_speed", spd);
        ToolUtilities.setIntNBT(stack, "rl_level", 1);
        stack.func_77982_d(nbt);
    }

    @Override
    public void updateStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        CompoundNBT damage = new CompoundNBT();
        damage.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.attack_damage"));
        damage.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.attack_damage"));
        int dmg = nbt.func_74762_e("rl_damage");
        double spd = nbt.func_74769_h("rl_speed");
        damage.func_218657_a("Amount", (INBT)IntNBT.func_229692_a_((int)dmg));
        damage.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        IntArrayNBT UUID2 = new IntArrayNBT(new int[]{1, 2, 3, 4});
        damage.func_218657_a("UUID", (INBT)UUID2);
        damage.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)"mainhand"));
        CompoundNBT speed = new CompoundNBT();
        speed.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.attack_speed"));
        speed.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.attack_speed"));
        speed.func_218657_a("Amount", (INBT)DoubleNBT.func_229684_a_((double)spd));
        speed.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        UUID2 = new IntArrayNBT(new int[]{5, 6, 7, 8});
        speed.func_218657_a("UUID", (INBT)UUID2);
        speed.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)"mainhand"));
        ListNBT modifiers = new ListNBT();
        modifiers.add((Object)damage);
        modifiers.add((Object)speed);
        nbt.func_218657_a("AttributeModifiers", (INBT)modifiers);
        stack.func_77982_d(nbt);
    }

    @Override
    public void upgradeTool(ItemStack stack, World worldIn) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a("rl_damage", nbt.func_74762_e("rl_damage") + 1);
        nbt.func_74780_a("rl_speed", nbt.func_74769_h("rl_speed") * 0.9);
        stack.func_77982_d(nbt);
        this.updateStats(stack);
    }
}

