/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import xyz.marstonconnell.randomloot.init.RLItems;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.EffectTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tags.WorldInteractTag;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;
import xyz.marstonconnell.randomloot.utils.Config;

public class RLThrowableItem
extends Item
implements IRLTool {
    private final Multimap<Attribute, AttributeModifier> field_234812_a_;

    public RLThrowableItem(String name) {
        super(new Item.Properties());
        RLItems.ITEMS.add(this);
        this.setRegistryName(new ResourceLocation("randomloot", name));
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", 8.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)-2.9f, AttributeModifier.Operation.ADDITION));
        this.field_234812_a_ = builder.build();
    }

    @Override
    public void setStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int dmg = (Integer)Config.BASE_THROWABLE_DAMAGE.get();
        nbt.func_74768_a("rl_damage", dmg);
        ToolUtilities.setIntNBT(stack, "rl_level", 1);
        stack.func_77982_d(nbt);
    }

    @Override
    public void updateStats(ItemStack stack) {
    }

    @Override
    public void upgradeTool(ItemStack stack, World worldIn) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int dmg = nbt.func_74762_e("rl_damage");
        nbt.func_74768_a("rl_damage", dmg + 1);
        stack.func_77982_d(nbt);
    }

    @Override
    public List<String> getStatsLore(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ArrayList<String> s = new ArrayList<String>();
        s.add(TextFormatting.GRAY + "Attack Damage: " + nbt.func_74762_e("rl_damage"));
        return s;
    }

    @Override
    public String getItemType() {
        return "throwable";
    }

    @Override
    public int getVariants() {
        return 10;
    }

    @Override
    public List<BasicTag> getAllowedTags() {
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            BasicTag eTag;
            if (tag instanceof EffectTag) {
                eTag = (EffectTag)tag;
                if (!eTag.forWeapons) continue;
                allowedTags.add(eTag);
                continue;
            }
            if (!(tag instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tag;
            if (!((WorldInteractTag)eTag).forWeapons) continue;
            allowedTags.add(eTag);
        }
        return allowedTags;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.SPEAR;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (itemstack.func_77952_i() >= itemstack.func_77958_k() - 1) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        if (EnchantmentHelper.func_203190_g((ItemStack)itemstack) > 0 && !playerIn.func_70026_G()) {
            return ActionResult.func_226251_d_((Object)itemstack);
        }
        playerIn.func_184598_c(handIn);
        return ActionResult.func_226249_b_((Object)itemstack);
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(1, attacker, p_220048_0_ -> p_220048_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.func_185887_b((IBlockReader)worldIn, pos) != 0.0) {
            stack.func_222118_a(2, entityLiving, p_220046_0_ -> p_220046_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.field_234812_a_ : super.func_111205_h(equipmentSlot);
    }

    public int func_77619_b() {
        return 1;
    }
}

