/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTier;
import net.minecraft.item.Items;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.loading.FMLEnvironment;
import xyz.marstonconnell.randomloot.init.RLItems;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.EffectTag;
import xyz.marstonconnell.randomloot.tags.StatBoostTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tags.WorldInteractTag;
import xyz.marstonconnell.randomloot.tools.TextureProxy;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;

public class RLToolItem
extends ToolItem {
    private final Set<Block> effectiveBlocks;
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> field_234674_d_;

    public Set<Material> getEffectiveMaterials() {
        HashSet<Material> effectiveOn = new HashSet<Material>();
        for (Block b : this.effectiveBlocks) {
            effectiveOn.add(b.func_176223_P().func_185904_a());
        }
        return effectiveOn;
    }

    public RLToolItem(String name, Set<Block> effectiveBlocksIn, float attackDamageIn, float attackSpeedIn) {
        super(attackDamageIn, attackSpeedIn, (IItemTier)ItemTier.DIAMOND, effectiveBlocksIn, new Item.Properties());
        this.setRegistryName(new ResourceLocation("randomloot", name));
        this.effectiveBlocks = effectiveBlocksIn;
        this.attackDamage = attackDamageIn;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.field_234674_d_ = builder.build();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            TextureProxy.setModelProperties((Item)this);
        }
        RLItems.ITEMS.add((Item)this);
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b().equals(RLItems.best_shard);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, PlayerEntity player) {
        return super.onBlockStartBreak(stack, pos, player);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        float eff = this.field_77864_a;
        eff += ToolUtilities.getFloatNBT(stack, "rl_bonus_speed");
        if (this.getToolTypes(stack).stream().anyMatch(e -> state.isToolEffective(e))) {
            return eff;
        }
        return this.effectiveBlocks.contains(state.func_177230_c()) ? eff : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.func_222118_a(2, attacker, p_220039_0_ -> p_220039_0_.func_213361_c(EquipmentSlotType.MAINHAND));
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        System.out.println("Activating Active Trait.");
        ItemStack stack = playerIn.func_184586_b(handIn);
        List<BasicTag> tags = TagHelper.getTagList(stack);
        for (int i = 0; i < tags.size(); ++i) {
            BasicTag eTag;
            if (!tags.get((int)i).active) continue;
            System.out.println("\t" + tags.get((int)i).name);
            if (tags.get(i) instanceof EffectTag) {
                eTag = (EffectTag)tags.get(i);
                if (((EffectTag)eTag).offensive) continue;
                ((EffectTag)eTag).runEffect(stack, worldIn, (LivingEntity)playerIn);
                continue;
            }
            if (tags.get(i) instanceof WorldInteractTag) {
                eTag = (WorldInteractTag)tags.get(i);
                if (!((WorldInteractTag)eTag).forTools) continue;
                ((WorldInteractTag)eTag).runEffect(stack, worldIn, (LivingEntity)playerIn, worldIn.func_180495_p(playerIn.func_233580_cy_()), playerIn.func_233580_cy_(), null);
                continue;
            }
            if (!(tags.get(i) instanceof StatBoostTag)) continue;
            eTag = (StatBoostTag)tags.get(i);
            if (!((StatBoostTag)eTag).forTools) continue;
            ((StatBoostTag)eTag).undoEffect(stack, worldIn, (LivingEntity)playerIn, playerIn.func_233580_cy_(), null);
            ((StatBoostTag)eTag).runEffect(stack, worldIn, (LivingEntity)playerIn, playerIn.func_233580_cy_(), null);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (stack.func_77973_b().equals(Items.field_190931_a)) {
            return false;
        }
        if (!worldIn.field_72995_K && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            stack.func_222118_a(1, entityLiving, p_220038_0_ -> p_220038_0_.func_213361_c(EquipmentSlotType.MAINHAND));
            ToolUtilities.changeXP(stack, 1, worldIn, entityLiving.func_233580_cy_());
            ToolUtilities.setLore(stack, worldIn);
            List<BasicTag> tags = TagHelper.getTagList(stack);
            for (int i = 0; i < tags.size(); ++i) {
                BasicTag eTag;
                if (tags.get((int)i).active) continue;
                if (tags.get(i) instanceof EffectTag) {
                    eTag = (EffectTag)tags.get(i);
                    if (((EffectTag)eTag).offensive) continue;
                    ((EffectTag)eTag).runEffect(stack, worldIn, entityLiving);
                    continue;
                }
                if (tags.get(i) instanceof WorldInteractTag) {
                    eTag = (WorldInteractTag)tags.get(i);
                    if (!((WorldInteractTag)eTag).forTools) continue;
                    ((WorldInteractTag)eTag).runEffect(stack, worldIn, entityLiving, state, pos, null);
                    continue;
                }
                if (!(tags.get(i) instanceof StatBoostTag)) continue;
                eTag = (StatBoostTag)tags.get(i);
                if (!((StatBoostTag)eTag).forTools) continue;
                ((StatBoostTag)eTag).undoEffect(stack, worldIn, entityLiving, pos, null);
                ((StatBoostTag)eTag).runEffect(stack, worldIn, entityLiving, pos, null);
            }
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlot) {
        return equipmentSlot == EquipmentSlotType.MAINHAND ? this.field_234674_d_ : super.func_111205_h(equipmentSlot);
    }

    public float func_234675_d_() {
        return this.attackDamage;
    }

    public Set<Block> getEffectiveOn() {
        return this.effectiveBlocks;
    }
}

