/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xyz.marstonconnell.randomloot.RandomLootMod;
import xyz.marstonconnell.randomloot.init.RLItems;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.EffectTag;
import xyz.marstonconnell.randomloot.tags.StatBoostTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tags.WorldInteractTag;
import xyz.marstonconnell.randomloot.tools.BaseArmorMaterial;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.tools.ToolUtilities;
import xyz.marstonconnell.randomloot.utils.Config;

public class RandomArmor
extends ArmorItem
implements IRLTool {
    public RandomArmor(String name, BaseArmorMaterial mat, EquipmentSlotType slot) {
        super((IArmorMaterial)mat, slot, new Item.Properties());
        this.setRegistryName(new ResourceLocation("randomloot", name));
        RLItems.ITEMS.add((Item)this);
    }

    @Override
    public void setStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int armor = (Integer)Config.BASE_ARMOR.get();
        double toughness = (Double)Config.BASE_TOUGHNESS.get();
        nbt.func_74780_a("rl_armor", (double)armor);
        nbt.func_74780_a("rl_tough", toughness);
        stack.func_77982_d(nbt);
        ToolUtilities.setIntNBT(stack, "rl_level", 1);
    }

    public boolean isRepairItem(ItemStack stack) {
        return stack.func_77973_b() == RLItems.best_shard;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b().equals(RLItems.best_shard);
    }

    @Override
    public void updateStats(ItemStack stack) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        CompoundNBT armorPoints = new CompoundNBT();
        armorPoints.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.armor"));
        armorPoints.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.armor"));
        double armor = nbt.func_74769_h("rl_armor");
        double tough = nbt.func_74769_h("rl_tough");
        armorPoints.func_218657_a("Amount", (INBT)DoubleNBT.func_229684_a_((double)armor));
        armorPoints.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        IntArrayNBT UUID2 = new IntArrayNBT(new int[]{RandomLootMod.rand.nextInt(Integer.MAX_VALUE), RandomLootMod.rand.nextInt(Integer.MAX_VALUE), RandomLootMod.rand.nextInt(Integer.MAX_VALUE), RandomLootMod.rand.nextInt(Integer.MAX_VALUE)});
        armorPoints.func_218657_a("UUID", (INBT)UUID2);
        armorPoints.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)this.getItemType()));
        CompoundNBT toughness = new CompoundNBT();
        toughness.func_218657_a("AttributeName", (INBT)StringNBT.func_229705_a_((String)"generic.armor_toughness"));
        toughness.func_218657_a("Name", (INBT)StringNBT.func_229705_a_((String)"generic.armor_toughness"));
        toughness.func_218657_a("Amount", (INBT)DoubleNBT.func_229684_a_((double)tough));
        toughness.func_218657_a("Operation", (INBT)IntNBT.func_229692_a_((int)0));
        UUID2 = new IntArrayNBT(new int[]{RandomLootMod.rand.nextInt(Integer.MAX_VALUE), RandomLootMod.rand.nextInt(Integer.MAX_VALUE), RandomLootMod.rand.nextInt(Integer.MAX_VALUE), RandomLootMod.rand.nextInt(Integer.MAX_VALUE)});
        toughness.func_218657_a("UUID", (INBT)UUID2);
        toughness.func_218657_a("Slot", (INBT)StringNBT.func_229705_a_((String)this.getItemType()));
        ListNBT modifiers = new ListNBT();
        modifiers.add((Object)armorPoints);
        modifiers.add((Object)toughness);
        nbt.func_218657_a("AttributeModifiers", (INBT)modifiers);
        stack.func_77982_d(nbt);
    }

    @Override
    public void upgradeTool(ItemStack stack, World worldIn) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74780_a("rl_armor", nbt.func_74769_h("rl_armor") * 1.05);
        nbt.func_74780_a("rl_tough", nbt.func_74769_h("rl_tough") * 1.05);
        stack.func_77982_d(nbt);
        this.updateStats(stack);
    }

    @Override
    public List<String> getStatsLore(ItemStack stack) {
        DecimalFormat f = new DecimalFormat("#0.00");
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ArrayList<String> s = new ArrayList<String>();
        s.add(TextFormatting.GRAY + "Armor: " + f.format(nbt.func_74769_h("rl_armor")));
        s.add(TextFormatting.GRAY + "Toughness: " + f.format(nbt.func_74769_h("rl_tough")));
        return s;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        List<BasicTag> tags = TagHelper.getTagList(stack);
        if (stack.func_77973_b().equals(Items.field_190931_a)) {
            return;
        }
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        int dm = nbt.func_74762_e("rl_armor_damage");
        if (this.getDamage(stack) != dm) {
            ToolUtilities.changeXP(stack, 1, world, player.func_233580_cy_());
            ToolUtilities.setLore(stack, world);
            dm = this.getDamage(stack);
            nbt.func_74768_a("rl_armor_damage", dm);
            stack.func_77982_d(nbt);
        }
        for (int i = 0; i < tags.size(); ++i) {
            BasicTag eTag;
            if (tags.get((int)i).active) continue;
            if (tags.get(i) instanceof EffectTag) {
                eTag = (EffectTag)tags.get(i);
                ((EffectTag)eTag).runEffect(stack, world, (LivingEntity)player);
                continue;
            }
            if (!(tags.get(i) instanceof WorldInteractTag)) continue;
            eTag = (WorldInteractTag)tags.get(i);
            ((WorldInteractTag)eTag).runEffect(stack, world, (LivingEntity)player, world.func_180495_p(new BlockPos(player.func_213303_ch())), new BlockPos(player.func_213303_ch()), null);
        }
        super.onArmorTick(stack, world, player);
    }

    @Override
    public String getItemType() {
        return this.func_185083_B_().func_188450_d();
    }

    @Override
    public int getVariants() {
        return 2;
    }

    @Override
    public List<BasicTag> getAllowedTags() {
        ArrayList<BasicTag> allowedTags = new ArrayList<BasicTag>();
        for (BasicTag tag : TagHelper.allTags) {
            BasicTag eTag;
            if (tag instanceof EffectTag) {
                eTag = (EffectTag)tag;
                if (eTag.offensive) continue;
                allowedTags.add(eTag);
                continue;
            }
            if (tag instanceof WorldInteractTag) {
                eTag = (WorldInteractTag)tag;
                if (!((WorldInteractTag)eTag).forArmor) continue;
                allowedTags.add(eTag);
                continue;
            }
            if (!(tag instanceof StatBoostTag)) continue;
            eTag = (StatBoostTag)tag;
            if (!((StatBoostTag)eTag).forArmor) continue;
            allowedTags.add(eTag);
        }
        return allowedTags;
    }
}

