/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.tools;

import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import xyz.marstonconnell.randomloot.init.ItemFactory;
import xyz.marstonconnell.randomloot.tags.BasicTag;
import xyz.marstonconnell.randomloot.tags.TagHelper;
import xyz.marstonconnell.randomloot.tools.IRLTool;

public abstract class ToolUtilities {
    public static final String[] FOUND_IN_TEXTS = new String[]{"Found in the heart of the", "Discovered deep in the", "Found in the", "Rightfully claimed at the", "Taken from the", "Gifted by the gods in the", "Uncovered at the", "Found deep in the"};
    public static final String TAG_XP = "xp";
    public static final String TAG_MAX_XP = "max_xp";
    public static final String TAG_TEXTURE = "texture";
    public static final String TAG_BONUS_SPEED = "rl_bonus_speed";

    public static void changeXP(ItemStack stack, int amt, World worldIn, BlockPos pos) {
        ToolUtilities.setXP(stack, ToolUtilities.getXP(stack) + amt);
        if (ToolUtilities.getXP(stack) >= ToolUtilities.getMaxXP(stack)) {
            ToolUtilities.setIntNBT(stack, "rl_level", ToolUtilities.getIntNBT(stack, "rl_level") + 1);
            ToolUtilities.upgradeTool(stack, worldIn, pos);
        }
    }

    private static void upgradeTool(ItemStack stack, World worldIn, BlockPos pos) {
        ToolUtilities.setXP(stack, 0);
        ToolUtilities.setMaxXP(stack, (int)((double)ToolUtilities.getMaxXP(stack) * 1.5));
        ItemFactory.applyToken(stack, worldIn);
        worldIn.func_184148_a((PlayerEntity)null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
    }

    public static void setLore(ItemStack stack, World worldIn) {
        ToolUtilities.setLore(stack, "", worldIn);
    }

    public static ItemStack updateToNewVersion(ItemStack stack, World worldIn) {
        if (worldIn == null) {
            return stack;
        }
        if (ToolUtilities.getIntNBT(stack, "rl_tool_version") != 1) {
            CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
            ListNBT tags = nbt.func_150295_c("rl_tags", 8);
            for (int i = 0; i < tags.size(); ++i) {
                TagHelper.addTag(stack, TagHelper.tagMap.get(tags.func_150307_f(i)), worldIn);
            }
            ToolUtilities.setIntNBT(stack, "rl_tool_version", 1);
            tags.clear();
            nbt.func_218657_a("rl_tags", (INBT)tags);
        }
        return stack;
    }

    public static void setLore(ItemStack stack, String addLore, World worldIn) {
        int i;
        CompoundNBT nbt = (stack = ToolUtilities.updateToNewVersion(stack, worldIn)).func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        ListNBT lore = new ListNBT();
        String location = ToolUtilities.getStringNBT(stack, "rl_found_in");
        if (location.length() > 0) {
            lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + TextFormatting.GRAY + FOUND_IN_TEXTS[(int)(Math.random() * (double)FOUND_IN_TEXTS.length)] + " " + location + "\"}")));
        }
        lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + addLore + "\"}")));
        List<BasicTag> tags = TagHelper.getTagList(stack);
        for (int i2 = 0; i2 < tags.size(); ++i2) {
            lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + tags.get((int)i2).color + tags.get(i2).toString() + "\"}")));
        }
        lore.add((Object)StringNBT.func_229705_a_((String)"{\"text\":\"\"}"));
        for (String s : ((IRLTool)stack.func_77973_b()).getStatsLore(stack)) {
            lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + s + "\"}")));
        }
        lore.add((Object)StringNBT.func_229705_a_((String)"{\"text\":\"\"}"));
        lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + TextFormatting.GRAY + "XP: " + ToolUtilities.getXP(stack) + " / " + ToolUtilities.getMaxXP(stack) + "\"}")));
        lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + TextFormatting.GRAY + "Level: " + ToolUtilities.getIntNBT(stack, "rl_level") + "\"}")));
        int cells = 14;
        int perc = (int)Math.ceil((double)ToolUtilities.getXP(stack) / (double)ToolUtilities.getMaxXP(stack) * (double)cells);
        String bar = "";
        for (i = 0; i < perc; ++i) {
            bar = bar + "\u23f9";
        }
        for (i = perc; i < cells; ++i) {
            bar = bar + "\u25a1";
        }
        bar = bar + "";
        lore.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + TextFormatting.GRAY + bar + "\"}")));
        CompoundNBT display = nbt.func_74775_l("display");
        display.func_218657_a("Lore", (INBT)lore);
        nbt.func_218657_a("display", (INBT)display);
        nbt.func_74768_a("HideFlags", 6);
        stack.func_77982_d(nbt);
    }

    public static void setName(ItemStack stack, String name) {
        ToolUtilities.setStringNBT(stack, "name", name);
    }

    public static String getName(ItemStack stack) {
        return ToolUtilities.getStringNBT(stack, "name");
    }

    public static void setStringNBT(ItemStack stack, String tag, String value) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74778_a(tag, value);
        stack.func_77982_d(nbt);
    }

    public static String getStringNBT(ItemStack stack, String tag) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        return nbt.func_74779_i(tag);
    }

    public static void setIntNBT(ItemStack stack, String tag, int value) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74768_a(tag, value);
        stack.func_77982_d(nbt);
    }

    public static int getIntNBT(ItemStack stack, String tag) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        return nbt.func_74762_e(tag);
    }

    public static long getLongNBT(ItemStack stack, String tag) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        return nbt.func_74763_f(tag);
    }

    public static void setLongNBT(ItemStack stack, String tag, long value) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74776_a(tag, (float)value);
        stack.func_77982_d(nbt);
    }

    public static void setFloatNBT(ItemStack stack, String tag, float value) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_74776_a(tag, value);
        stack.func_77982_d(nbt);
    }

    public static float getFloatNBT(ItemStack stack, String tag) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        return nbt.func_74760_g(tag);
    }

    public static int getXP(ItemStack stack) {
        return ToolUtilities.getIntNBT(stack, TAG_XP);
    }

    public static void setXP(ItemStack stack, int xp) {
        ToolUtilities.setIntNBT(stack, TAG_XP, xp);
    }

    public static int getMaxXP(ItemStack stack) {
        return ToolUtilities.getIntNBT(stack, TAG_MAX_XP);
    }

    public static void setMaxXP(ItemStack stack, int xp) {
        ToolUtilities.setIntNBT(stack, TAG_MAX_XP, xp);
    }

    public static int getTexture(ItemStack stack) {
        return ToolUtilities.getIntNBT(stack, TAG_TEXTURE);
    }

    public static void setTexture(ItemStack stack, int textureId) {
        ToolUtilities.setIntNBT(stack, TAG_TEXTURE, textureId);
    }

    public static void deleteStringNBT(ItemStack stack, String string) {
        CompoundNBT nbt = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
        nbt.func_82580_o(string);
        stack.func_77982_d(nbt);
    }
}

