/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.utils;

import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.stats.ServerStatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.marstonconnell.randomloot.init.RLItems;
import xyz.marstonconnell.randomloot.tools.IRLTool;
import xyz.marstonconnell.randomloot.utils.Config;
import xyz.marstonconnell.randomloot.utils.WeightedChooser;

public class LootSystem {
    static ArrayList<Item> allSwords;
    static ArrayList<Item> allAxes;
    static ArrayList<Item> allPicks;
    static ArrayList<Item> allShovels;
    static ArrayList<Item> allBows;

    public static void init() {
        allSwords = new ArrayList();
        allAxes = new ArrayList();
        allPicks = new ArrayList();
        allShovels = new ArrayList();
        allBows = new ArrayList();
        Set allItemLocations = ForgeRegistries.ITEMS.getEntries();
        ArrayList allItems = new ArrayList();
        for (Map.Entry e : allItemLocations) {
            allItems.add(e.getValue());
        }
        allItemLocations = null;
        for (Item i : allItems) {
            Set types = i.getToolTypes(new ItemStack((IItemProvider)i));
            if (types.contains(ToolType.AXE)) {
                allAxes.add(i);
            }
            if (types.contains(ToolType.PICKAXE)) {
                allPicks.add(i);
            }
            if (types.contains(ToolType.SHOVEL)) {
                allPicks.add(i);
            }
            if (i instanceof SwordItem) {
                allSwords.add(i);
            }
            if (!(i instanceof ShootableItem)) continue;
            allBows.add(i);
        }
    }

    private static int adjustChance(int amt, float adjustment, int ratio) {
        return (int)((float)(amt / ratio) * adjustment + (float)(amt - amt / ratio));
    }

    public static Item getPersonalItem(ServerPlayerEntity playerIn) {
        ServerStatisticsManager ssm = playerIn.func_147099_x();
        float swordsUsed = 0.0f;
        float axesUsed = 0.0f;
        float bowsUsed = 0.0f;
        float picksUsed = 0.0f;
        float shovelsUsed = 0.0f;
        for (Item i : allSwords) {
            swordsUsed += (float)ssm.func_77444_a(Stats.field_75929_E.func_199076_b((Object)i));
        }
        for (Item i : allAxes) {
            axesUsed += (float)ssm.func_77444_a(Stats.field_75929_E.func_199076_b((Object)i));
        }
        for (Item i : allPicks) {
            picksUsed += (float)ssm.func_77444_a(Stats.field_75929_E.func_199076_b((Object)i));
        }
        for (Item i : allBows) {
            bowsUsed += (float)ssm.func_77444_a(Stats.field_75929_E.func_199076_b((Object)i));
        }
        for (Item i : allShovels) {
            shovelsUsed += (float)ssm.func_77444_a(Stats.field_75929_E.func_199076_b((Object)i));
        }
        float dmgAbsorbed = ssm.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_212738_J));
        float dmgTaken = (float)ssm.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188112_z)) + 1.0E-5f;
        float totalDamage = dmgTaken + dmgAbsorbed;
        float armorRatio = 1.0f - dmgTaken / totalDamage;
        float total = swordsUsed + bowsUsed + shovelsUsed + picksUsed + axesUsed;
        WeightedChooser<IRLTool> wc = new WeightedChooser<IRLTool>();
        int ratio = 2;
        float timePlaying = ssm.func_77444_a(Stats.field_199092_j.func_199076_b((Object)Stats.field_188097_g));
        float timeFactor = 2000.0f;
        ratio = (int)((double)ratio + Math.pow(10.0, -timePlaying / timeFactor + 1.0f));
        wc.addChoice(RLItems.random_sword, LootSystem.adjustChance((Integer)Config.SWORD_CHANCE.get(), swordsUsed / total, ratio));
        wc.addChoice(RLItems.random_pick, LootSystem.adjustChance((Integer)Config.PICK_CHANCE.get(), picksUsed / total, ratio));
        wc.addChoice(RLItems.random_axe, LootSystem.adjustChance((Integer)Config.AXE_CHANCE.get(), axesUsed / total, ratio));
        wc.addChoice(RLItems.random_spade, LootSystem.adjustChance((Integer)Config.SPADE_CHANCE.get(), shovelsUsed / total, ratio));
        wc.addChoice(RLItems.random_bow, LootSystem.adjustChance((Integer)Config.BOW_CHANCE.get(), bowsUsed / total, ratio));
        wc.addChoice((IRLTool)RLItems.HEAVY_BOOTS, LootSystem.adjustChance((Integer)Config.ARMOR_CHANCE.get(), armorRatio, ratio));
        wc.addChoice((IRLTool)RLItems.HEAVY_CHEST, LootSystem.adjustChance((Integer)Config.ARMOR_CHANCE.get(), armorRatio, ratio));
        wc.addChoice((IRLTool)RLItems.HEAVY_HELMET, LootSystem.adjustChance((Integer)Config.ARMOR_CHANCE.get(), armorRatio, ratio));
        wc.addChoice((IRLTool)RLItems.HEAVY_LEGS, LootSystem.adjustChance((Integer)Config.ARMOR_CHANCE.get(), armorRatio, ratio));
        wc.addChoice((IRLTool)RLItems.TITANIUM_BOOTS, LootSystem.adjustChance((Integer)Config.ARMOR_CHANCE.get(), armorRatio, ratio));
        wc.addChoice((IRLTool)RLItems.TITANIUM_CHEST, LootSystem.adjustChance((Integer)Config.ARMOR_CHANCE.get(), armorRatio, ratio));
        wc.addChoice((IRLTool)RLItems.TITANIUM_HELMET, LootSystem.adjustChance((Integer)Config.ARMOR_CHANCE.get(), armorRatio, ratio));
        wc.addChoice((IRLTool)RLItems.TITANIUM_LEGS, LootSystem.adjustChance((Integer)Config.ARMOR_CHANCE.get(), armorRatio, ratio));
        return (Item)wc.getRandomObject();
    }
}

