/*
 * Decompiled with CFR 0.152.
 */
package xyz.marstonconnell.randomloot.utils.handlers;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.marstonconnell.randomloot.init.ItemFactory;
import xyz.marstonconnell.randomloot.utils.LootSystem;

public class BaseMessage {
    private int value;
    private int rarity;

    public BaseMessage() {
    }

    public BaseMessage(int i, int rarity) {
        this.value = i;
        this.rarity = rarity;
    }

    public BaseMessage(PacketBuffer buff) {
        this.value = buff.readInt();
        this.rarity = buff.readInt();
    }

    public void encode(PacketBuffer buff) {
        buff.writeInt(this.value);
        buff.writeInt(this.rarity);
    }

    public static void handle(BaseMessage pckt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (pckt.value == 0) {
                ((NetworkEvent.Context)ctx.get()).getSender().func_184614_ca().func_190918_g(1);
                BaseMessage.getNewItem(pckt.rarity, ((NetworkEvent.Context)ctx.get()).getSender());
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static ItemStack getNewItem(int rarity, ServerPlayerEntity playerIn) {
        ItemStack s = new ItemStack((IItemProvider)LootSystem.getPersonalItem(playerIn));
        s = ItemFactory.forgeItem(s, rarity, playerIn.func_130014_f_(), playerIn.func_233580_cy_());
        playerIn.func_191521_c(s);
        LootSystem.getPersonalItem(playerIn);
        return s;
    }
}

