/*
 * Decompiled with CFR 0.152.
 */
package realsurvivor;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.SleepingLocationCheckEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import realsurvivor.DataFake;
import realsurvivor.Register;
import realsurvivor.WorldData;
import realsurvivor.capabilities.IStatus;
import realsurvivor.capabilities.StatusProvider;
import realsurvivor.network.Dispatcher;
import realsurvivor.network.client.PacketClientSetCheck;
import realsurvivor.network.client.PacketClientSetDirty;
import realsurvivor.network.client.PacketClientSetEnergy;
import realsurvivor.network.client.PacketClientSetExcretion;
import realsurvivor.network.client.PacketClientUpdate;
import realsurvivor.network.server.PacketServerExcrete;
import realsurvivor.network.server.PacketServerSetDirty;
import realsurvivor.network.server.PacketServerSetEnergy;
import realsurvivor.network.server.PacketServerSetExcretion;
import realsurvivor.network.server.PacketServerSleepy;
import realsurvivor.network.server.PacketServerStink;
import realsurvivor.network.server.PacketServerStool;

public class Event {
    long eg = 0L;
    long et = 0L;
    int dt = 0;
    long sw = 0L;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerSleep(SleepingLocationCheckEvent event) {
        Player player;
        if (event.getEntity() instanceof Player && (player = (Player)event.getEntity()).m_5803_() && player.m_36318_() >= 100) {
            this.eg = 0L;
            Dispatcher.sendToServer(new PacketServerSetEnergy(20));
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onUpdatePlayer(LivingEvent.LivingUpdateEvent e) {
        DataFake data;
        if (e.getEntity().f_19853_.f_46443_ && e.getEntity() instanceof LocalPlayer && (data = new DataFake()).getxCheck() && !Minecraft.m_91087_().f_91074_.m_7500_()) {
            this.TickStatus((Player)Minecraft.m_91087_().f_91074_, data.getxEnergy(), data.getxExcretion());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void TickStatus(Player player, int en, int et) {
        IStatus status = (IStatus)player.getCapability(StatusProvider.Status_CAP, null).orElse(null);
        if (player.m_5803_()) {
            if (this.eg >= 400L) {
                this.eg = 0L;
                if (status.getEnergy() != 20) {
                    Dispatcher.sendToServer(new PacketServerSetEnergy(status.getEnergy() + 1));
                }
            } else {
                ++this.eg;
            }
        } else {
            if (this.eg >= (long)(800 * en)) {
                this.eg = 0L;
                if (status.getEnergy() != 0) {
                    Dispatcher.sendToServer(new PacketServerSetEnergy(status.getEnergy() - 1));
                }
            } else {
                ++this.eg;
            }
            if (player.m_36324_().m_38702_() == 20) {
                if (this.et >= (long)(500 * et)) {
                    this.et = 0L;
                    if (status.getExcretion() != 0) {
                        Dispatcher.sendToServer(new PacketServerSetExcretion(status.getExcretion() - 1));
                    }
                } else {
                    ++this.et;
                }
            }
            if (player.m_20069_()) {
                if (this.dt >= 80) {
                    this.dt = 0;
                    if (status.getDirty() < 20) {
                        Dispatcher.sendToServer(new PacketServerSetDirty(status.getDirty() + 1));
                    }
                } else {
                    ++this.dt;
                }
            }
            if (status.getEnergy() <= 6) {
                Dispatcher.sendToServer(new PacketServerSleepy());
            }
            if (status.getExcretion() <= 0) {
                Dispatcher.sendToServer(new PacketServerStool());
            }
            if (status.getDirty() <= 0) {
                Dispatcher.sendToServer(new PacketServerStink());
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerAttack(LivingAttackEvent event) {
        Entity source = event.getSource().m_7640_();
        if (event.getEntity().f_19853_.f_46443_ && source instanceof LocalPlayer) {
            DataFake data = new DataFake();
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            IStatus status = (IStatus)player.getCapability(StatusProvider.Status_CAP, null).orElse(null);
            if (data.getxCheck()) {
                int dt = data.getxDitry();
                if (!player.m_7500_()) {
                    if (this.dt >= 20 * dt) {
                        this.dt = 0;
                        if (status.getDirty() != 0) {
                            Dispatcher.sendToServer(new PacketServerSetDirty(status.getDirty() - 1));
                        }
                    } else {
                        ++this.dt;
                    }
                }
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        DataFake data;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (Register.excrete.m_90857_() && player.m_150109_().m_36063_(new ItemStack((ItemLike)Items.f_42446_)) && (data = new DataFake()).getExcretion() < 20) {
            Dispatcher.sendToServer(new PacketServerExcrete());
            Dispatcher.sendToServer(new PacketServerSetExcretion(20));
        }
    }

    @SubscribeEvent
    public void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (Event.canHaveAttributes((Entity)event.getObject())) {
            if (!(event.getObject() instanceof Player)) {
                return;
            }
            event.addCapability(new ResourceLocation("realsurvivor", "status"), (ICapabilityProvider)new StatusProvider());
        }
    }

    public static boolean canHaveAttributes(Entity entity) {
        return entity instanceof LivingEntity;
    }

    @SubscribeEvent
    public void onPlayerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            Player player = event.getPlayer();
            IStatus status = (IStatus)player.getCapability(StatusProvider.Status_CAP, null).orElse(null);
            this.sendStart(status, player);
        }
    }

    private void sendStart(IStatus data, Player player) {
        ServerPlayer mp = (ServerPlayer)player;
        Dispatcher.sendTo(new PacketClientSetEnergy(data.getEnergy()), mp);
        Dispatcher.sendTo(new PacketClientSetDirty(data.getDirty()), mp);
        Dispatcher.sendTo(new PacketClientSetExcretion(data.getExcretion()), mp);
        Dispatcher.sendTo(new PacketClientSetCheck(true), mp);
    }

    @SubscribeEvent
    public void onPlayerJoin(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            WorldData worlddata = WorldData.forWorld((ServerLevel)event.getWorld());
            Dispatcher.sendTo(new PacketClientUpdate(worlddata.getData().m_128471_("xCheck"), worlddata.getData().m_128451_("xEnergy"), worlddata.getData().m_128451_("xDitry"), worlddata.getData().m_128451_("xExcretion")), (ServerPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public void onPlayerSpawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            Player player = event.getPlayer();
            IStatus status = (IStatus)player.getCapability(StatusProvider.Status_CAP, null).orElse(null);
            this.sendStart(status, player);
        }
    }
}

