/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2385;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import org.apache.commons.lang3.mutable.MutableObject;

public class PieceLimitedJigsawManager {
    public static void assembleJigsawStructure(class_5455 dynamicRegistryManager, class_3812 jigsawConfig, class_2794 chunkGenerator, class_3485 templateManager, class_2338 startPos, List<? super class_3443> components, Random random, boolean doBoundaryAdjustments, boolean useHeightmap, Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, int maxY, int minY) {
        class_2385 jigsawPoolRegistry = dynamicRegistryManager.method_30530(class_2378.field_25917);
        class_2470 rotation = class_2470.method_16548((Random)random);
        class_3785 startPool = (class_3785)jigsawConfig.method_27223().get();
        if (startPool.method_16632() == 0) {
            RepurposedStructures.LOGGER.warn("Empty or nonexistent start pool: {}  Crash is imminent", (Object)startPool.method_16629());
        }
        class_3784 startPieceBlueprint = startPool.method_16631(random);
        class_3790 startPiece = new class_3790(templateManager, startPieceBlueprint, startPos, startPieceBlueprint.method_19308(), rotation, startPieceBlueprint.method_16628(templateManager, startPos, rotation));
        class_3341 pieceBoundingBox = startPiece.method_14935();
        int pieceCenterX = (pieceBoundingBox.field_14378 + pieceBoundingBox.field_14381) / 2;
        int pieceCenterZ = (pieceBoundingBox.field_14376 + pieceBoundingBox.field_14379) / 2;
        int pieceCenterY = useHeightmap ? startPos.method_10264() + chunkGenerator.method_20402(pieceCenterX, pieceCenterZ, class_2902.class_2903.field_13194) : startPos.method_10264();
        int yAdjustment = pieceBoundingBox.field_14380 + startPiece.method_16646();
        startPiece.method_14922(0, pieceCenterY - yAdjustment, 0);
        int attempts = 0;
        while (PieceLimitedJigsawManager.doesNotHaveAllRequiredPieces(components, requiredPieces)) {
            if (attempts == 100) {
                RepurposedStructures.LOGGER.error("Failed to create valid structure with all required pieces starting from this pool file: {}. Required pieces are: {}", (Object)startPool.method_16629(), (Object)Arrays.toString(requiredPieces.keySet().toArray()));
                break;
            }
            ++attempts;
            components.clear();
            components.add((class_3443)startPiece);
            if (jigsawConfig.method_27222() <= 0) continue;
            class_238 axisAlignedBB = new class_238((double)(pieceCenterX - 80), (double)(pieceCenterY - 120), (double)(pieceCenterZ - 80), (double)(pieceCenterX + 80 + 1), (double)(pieceCenterY + 180 + 1), (double)(pieceCenterZ + 80 + 1));
            Assembler assembler = new Assembler((class_2378<class_3785>)jigsawPoolRegistry, jigsawConfig.method_27222(), chunkGenerator, templateManager, components, random, requiredPieces, maxY, minY);
            Entry startPieceEntry = new Entry(startPiece, (MutableObject<class_265>)new MutableObject((Object)class_259.method_1072((class_265)class_259.method_1078((class_238)axisAlignedBB), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)pieceBoundingBox)), (class_247)class_247.field_16886)), pieceCenterY + 80, 0);
            assembler.availablePieces.addLast(startPieceEntry);
            while (!assembler.availablePieces.isEmpty()) {
                Entry entry = assembler.availablePieces.removeFirst();
                assembler.generatePiece(entry.piece, entry.pieceShape, entry.minY, entry.depth, doBoundaryAdjustments);
            }
        }
    }

    private static boolean doesNotHaveAllRequiredPieces(List<? super class_3443> components, Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces) {
        HashMap<class_2960, Integer> counter = new HashMap<class_2960, Integer>();
        requiredPieces.forEach((key, value) -> counter.put((class_2960)key, value.getRequiredAmount()));
        for (class_3443 class_34432 : components) {
            class_2960 pieceID;
            class_3784 poolElement;
            if (!(class_34432 instanceof class_3790) || !((poolElement = ((class_3790)class_34432).method_16644()) instanceof class_3781) || !counter.containsKey(pieceID = (class_2960)((SinglePoolElementAccessor)poolElement).repurposedstructures_getField_24015().left().orElse(null))) continue;
            counter.put(pieceID, (Integer)counter.get(pieceID) - 1);
        }
        return counter.values().stream().anyMatch(count -> count > 0);
    }

    public static final class Entry {
        public final class_3790 piece;
        public final MutableObject<class_265> pieceShape;
        public final int minY;
        public final int depth;

        public Entry(class_3790 piece, MutableObject<class_265> pieceShape, int minY, int depth) {
            this.piece = piece;
            this.pieceShape = pieceShape;
            this.minY = minY;
            this.depth = depth;
        }
    }

    public static final class Assembler {
        private final class_2378<class_3785> poolRegistry;
        private final int maxDepth;
        private final class_2794 chunkGenerator;
        private final class_3485 structureManager;
        private final List<? super class_3790> structurePieces;
        private final Random rand;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();
        private final Map<class_2960, Integer> pieceCounts;
        private final Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces;
        private final int maxY;
        private final int minY;

        public Assembler(class_2378<class_3785> poolRegistry, int maxDepth, class_2794 chunkGenerator, class_3485 structureManager, List<? super class_3790> structurePieces, Random rand, Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, int maxY, int minY) {
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = chunkGenerator;
            this.structureManager = structureManager;
            this.structurePieces = structurePieces;
            this.rand = rand;
            this.maxY = maxY;
            this.minY = minY;
            this.requiredPieces = new HashMap<class_2960, StructurePiecesBehavior.RequiredPieceNeeds>(requiredPieces);
            this.pieceCounts = new HashMap<class_2960, Integer>(StructurePiecesBehavior.PIECES_COUNT);
            this.requiredPieces.forEach((key, value) -> this.pieceCounts.putIfAbsent((class_2960)key, value.getRequiredAmount()));
        }

        public void generatePiece(class_3790 piece, MutableObject<class_265> voxelShape, int minY, int depth, boolean doBoundaryAdjustments) {
            class_3784 pieceBlueprint = piece.method_16644();
            class_2338 piecePos = piece.method_16648();
            class_2470 pieceRotation = piece.method_16888();
            class_3341 pieceBoundingBox = piece.method_14935();
            int pieceMinY = pieceBoundingBox.field_14380;
            MutableObject<class_265> tempNewPieceVoxelShape = new MutableObject<class_265>();
            List pieceJigsawBlocks = pieceBlueprint.method_16627(this.structureManager, piecePos, pieceRotation, this.rand);
            for (class_3499.class_3501 jigsawBlock : pieceJigsawBlocks) {
                class_3784 generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<class_265> pieceVoxelShape;
                class_2350 direction = class_3748.method_26378((class_2680)jigsawBlock.field_15596);
                class_2338 jigsawBlockPos = jigsawBlock.field_15597;
                class_2338 jigsawBlockTargetPos = jigsawBlockPos.method_10093(direction);
                class_2960 jigsawBlockPool = new class_2960(jigsawBlock.field_15595.method_10558("pool"));
                Optional poolOptional = this.poolRegistry.method_17966(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((class_3785)poolOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockPool, class_5468.field_26254.method_29177())) {
                    RepurposedStructures.LOGGER.warn("Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof class_3781 ? ((SinglePoolElementAccessor)pieceBlueprint).repurposedstructures_getField_24015().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                class_2960 jigsawBlockFallback = ((class_3785)poolOptional.get()).method_16634();
                Optional fallbackOptional = this.poolRegistry.method_17966(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((class_3785)fallbackOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockFallback, class_5468.field_26254.method_29177())) {
                    RepurposedStructures.LOGGER.warn("Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockFallback, pieceBlueprint instanceof class_3781 ? ((SinglePoolElementAccessor)pieceBlueprint).repurposedstructures_getField_24015().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.method_14662((class_2382)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    pieceVoxelShape = tempNewPieceVoxelShape;
                    targetPieceBoundsTop = pieceMinY;
                    if (tempNewPieceVoxelShape.getValue() == null) {
                        tempNewPieceVoxelShape.setValue((Object)class_259.method_1078((class_238)class_238.method_19316((class_3341)pieceBoundingBox)));
                    }
                } else {
                    pieceVoxelShape = voxelShape;
                    targetPieceBoundsTop = minY;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)poolOptional.get()).repurposedstructures_getElementCounts()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, pieceVoxelShape, piece, depth, targetPieceBoundsTop)) != null) continue;
                this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)fallbackOptional.get()).repurposedstructures_getElementCounts()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, pieceVoxelShape, piece, depth, targetPieceBoundsTop);
            }
        }

        private class_3784 processList(List<Pair<class_3784, Integer>> candidatePieces, boolean doBoundaryAdjustments, class_3499.class_3501 jigsawBlock, class_2338 jigsawBlockTargetPos, int pieceMinY, class_2338 jigsawBlockPos, MutableObject<class_265> pieceVoxelShape, class_3790 piece, int depth, int targetPieceBoundsTop) {
            class_3785.class_3786 piecePlacementBehavior = piece.method_16644().method_16624();
            boolean isPieceRigid = piecePlacementBehavior == class_3785.class_3786.field_16687;
            int jigsawBlockRelativeY = jigsawBlockPos.method_10264() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                class_3784 candidatePiece;
                Object chosenPiecePair = null;
                Optional<class_2960> pieceNeededToSpawn = this.requiredPieces.keySet().stream().filter(key -> {
                    int currentCount = this.pieceCounts.get(key);
                    StructurePiecesBehavior.RequiredPieceNeeds requiredPieceNeeds = this.requiredPieces.get(key);
                    int requireCount = requiredPieceNeeds == null ? 0 : requiredPieceNeeds.getRequiredAmount();
                    int startCount = StructurePiecesBehavior.PIECES_COUNT.getOrDefault(key, requireCount);
                    return currentCount > 0 && startCount - currentCount < requireCount;
                }).findFirst();
                if (pieceNeededToSpawn.isPresent()) {
                    for (int i = 0; i < candidatePieces.size(); ++i) {
                        Pair<class_3784, Integer> candidatePiecePair = candidatePieces.get(i);
                        class_3784 class_37842 = (class_3784)candidatePiecePair.getFirst();
                        if (!(class_37842 instanceof class_3781) || !((class_2960)((SinglePoolElementAccessor)class_37842).repurposedstructures_getField_24015().left().get()).equals((Object)pieceNeededToSpawn.get())) continue;
                        if (depth >= this.requiredPieces.get(pieceNeededToSpawn.get()).getMinDistanceFromCenter()) {
                            chosenPiecePair = candidatePiecePair;
                            break;
                        }
                        totalCount -= ((Integer)candidatePiecePair.getSecond()).intValue();
                        candidatePieces.remove(candidatePiecePair);
                        break;
                    }
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.rand.nextInt(totalCount) + 1;
                    for (Pair pair : candidatePieces) {
                        if ((chosenWeight -= ((Integer)pair.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = pair;
                        break;
                    }
                }
                if ((candidatePiece = (class_3784)chosenPiecePair.getFirst()) == class_3777.field_16663) {
                    return null;
                }
                class_2960 pieceName = null;
                if (candidatePiece instanceof class_3781 && this.pieceCounts.containsKey(pieceName = (class_2960)((SinglePoolElementAccessor)candidatePiece).repurposedstructures_getField_24015().left().get()) && this.pieceCounts.get(pieceName) <= 0) {
                    totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (class_2470 rotation : class_2470.method_16547((Random)this.rand)) {
                    List candidateJigsawBlocks = candidatePiece.method_16627(this.structureManager, class_2338.field_10980, rotation, this.rand);
                    class_3341 tempCandidateBoundingBox = candidatePiece.method_16628(this.structureManager, class_2338.field_10980, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.method_14663() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.method_14662((class_2382)pieceCandidateJigsawBlock.field_15597.method_10093(class_3748.method_26378((class_2680)pieceCandidateJigsawBlock.field_15596)))) {
                            return 0;
                        }
                        class_2960 candidateTargetPool = new class_2960(pieceCandidateJigsawBlock.field_15595.method_10558("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.method_17966(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(p_242843_1_ -> this.poolRegistry.method_17966(p_242843_1_.method_16634()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(p_242842_1_ -> p_242842_1_.method_19309(this.structureManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(p_242840_1_ -> p_242840_1_.method_19309(this.structureManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (class_3499.class_3501 candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!class_3748.method_16546((class_3499.class_3501)jigsawBlock, (class_3499.class_3501)candidateJigsawBlock)) continue;
                        class_2338 candidateJigsawBlockPos = candidateJigsawBlock.field_15597;
                        class_2338 candidateJigsawBlockRelativePos = new class_2338(jigsawBlockTargetPos.method_10263() - candidateJigsawBlockPos.method_10263(), jigsawBlockTargetPos.method_10264() - candidateJigsawBlockPos.method_10264(), jigsawBlockTargetPos.method_10260() - candidateJigsawBlockPos.method_10260());
                        class_3341 candidateBoundingBox = candidatePiece.method_16628(this.structureManager, candidateJigsawBlockRelativePos, rotation);
                        class_3785.class_3786 candidatePlacementBehavior = candidatePiece.method_16624();
                        boolean isCandidateRigid = candidatePlacementBehavior == class_3785.class_3786.field_16687;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.method_10264();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + class_3748.method_26378((class_2680)jigsawBlock.field_15596).method_10164();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.field_14380;
                        class_3341 adjustedCandidateBoundingBox = candidateBoundingBox.method_19311(0, candidatePieceYOffsetNeeded, 0);
                        class_2338 adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.method_10069(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.field_14377 - adjustedCandidateBoundingBox.field_14380);
                            adjustedCandidateBoundingBox.field_14377 = adjustedCandidateBoundingBox.field_14380 + k2;
                        }
                        if (adjustedCandidateBoundingBox.field_14377 > this.maxY || adjustedCandidateBoundingBox.field_14380 < this.minY || class_259.method_1074((class_265)((class_265)pieceVoxelShape.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)adjustedCandidateBoundingBox).method_1011(0.25)), (class_247)class_247.field_16893)) continue;
                        pieceVoxelShape.setValue((Object)class_259.method_1082((class_265)((class_265)pieceVoxelShape.getValue()), (class_265)class_259.method_1078((class_238)class_238.method_19316((class_3341)adjustedCandidateBoundingBox)), (class_247)class_247.field_16886));
                        int newPieceGroundLevelDelta = piece.method_16646();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.method_19308();
                        class_3790 newPiece = new class_3790(this.structureManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.method_16647(new class_3780(jigsawBlockTargetPos.method_10263(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.method_10260(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.method_16647(new class_3780(jigsawBlockPos.method_10263(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.method_10260(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((class_3790)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, pieceVoxelShape, targetPieceBoundsTop, depth + 1));
                        }
                        if (pieceName != null && this.pieceCounts.containsKey(pieceName)) {
                            this.pieceCounts.put(pieceName, this.pieceCounts.get(pieceName) - 1);
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

