/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.JsonOps;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.NamespaceResourceManagerAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.ReloadableResourceManagerImplAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.StructureManagerAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.utils.SafeDecodingRegistryOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3294;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5455;

public class PoolAdditionMerger {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().create();
    private static final String DATA_TYPE = "pool_additions";
    private static final int FILE_SUFFIX_LENGTH = ".json".length();

    public static void mergeAdditionPools() {
        ServerLifecycleEvents.SERVER_STARTING.register(minecraftServer -> {
            class_3300 resourceManager = ((StructureManagerAccessor)minecraftServer.method_27727()).repurposedstructures_getField_25189();
            Map<class_2960, List<JsonElement>> poolAdditionJSON = PoolAdditionMerger.getPoolAdditionJSON(resourceManager);
            PoolAdditionMerger.parsePoolsAndBeginMerger(poolAdditionJSON, minecraftServer.method_30611());
        });
    }

    private static Map<class_2960, List<JsonElement>> getPoolAdditionJSON(class_3300 resourceManager) {
        HashMap<class_2960, List<JsonElement>> map = new HashMap<class_2960, List<JsonElement>>();
        int dataTypeLength = DATA_TYPE.length() + 1;
        for (class_2960 fileIDWithExtension : resourceManager.method_14488(DATA_TYPE, fileString -> fileString.endsWith(".json"))) {
            String identifierPath = fileIDWithExtension.method_12832();
            class_2960 fileID = new class_2960(fileIDWithExtension.method_12836(), identifierPath.substring(dataTypeLength, identifierPath.length() - FILE_SUFFIX_LENGTH));
            try {
                for (InputStream fileStream : PoolAdditionMerger.getAllFileStreams(resourceManager, fileIDWithExtension)) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileStream, StandardCharsets.UTF_8));
                    Throwable throwable = null;
                    try {
                        JsonElement poolJSONElement = (JsonElement)class_3518.method_15276((Gson)GSON, (Reader)bufferedReader, JsonElement.class);
                        if (poolJSONElement != null) {
                            if (!map.containsKey(fileID)) {
                                map.put(fileID, new ArrayList());
                            }
                            ((List)map.get(fileID)).add(poolJSONElement);
                            continue;
                        }
                        RepurposedStructures.LOGGER.error("(POOL MERGER) Couldn't load data file {} from {} as it's null or empty", (Object)fileID, (Object)fileIDWithExtension);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (bufferedReader == null) continue;
                        if (throwable != null) {
                            try {
                                ((Reader)bufferedReader).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        ((Reader)bufferedReader).close();
                    }
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                RepurposedStructures.LOGGER.error("(POOL MERGER) Couldn't parse data file {} from {}", (Object)fileID, (Object)fileIDWithExtension, (Object)exception);
            }
        }
        return map;
    }

    private static List<InputStream> getAllFileStreams(class_3300 resourceManager, class_2960 fileID) throws IOException {
        ArrayList<InputStream> fileStreams = new ArrayList<InputStream>();
        class_3294 namespaceResourceManager = ((ReloadableResourceManagerImplAccessor)resourceManager).repurposedstructures_getNamespaceManagers().get(fileID.method_12836());
        List<class_3262> allResourcePacks = ((NamespaceResourceManagerAccessor)namespaceResourceManager).repurposedstructures_getPackList();
        for (class_3262 resourcePack : allResourcePacks) {
            InputStream inputStream;
            if (!resourcePack.method_14411(class_3264.field_14190, fileID) || (inputStream = ((NamespaceResourceManagerAccessor)namespaceResourceManager).repurposedstructures_callOpen(fileID, resourcePack)) == null) continue;
            fileStreams.add(inputStream);
        }
        return fileStreams;
    }

    private static void parsePoolsAndBeginMerger(Map<class_2960, List<JsonElement>> poolAdditionJSON, class_5455 dynamicRegistryManager) {
        class_2385 poolRegistry = dynamicRegistryManager.method_30530(class_2378.field_25917);
        SafeDecodingRegistryOps customRegistryOps = new SafeDecodingRegistryOps(JsonOps.INSTANCE, dynamicRegistryManager);
        for (Map.Entry<class_2960, List<JsonElement>> entry : poolAdditionJSON.entrySet()) {
            if (!poolRegistry.method_10250(entry.getKey())) continue;
            for (JsonElement jsonElement : entry.getValue()) {
                class_3785.field_25853.parse(customRegistryOps, (Object)jsonElement).resultOrPartial(messageString -> PoolAdditionMerger.logBadData((class_2960)entry.getKey(), messageString)).ifPresent(validPool -> PoolAdditionMerger.mergeIntoExistingPool(validPool, (class_3785)poolRegistry.method_10223((class_2960)entry.getKey())));
            }
        }
    }

    private static void mergeIntoExistingPool(class_3785 feedingPool, class_3785 gluttonyPool) {
        ArrayList<class_3784> elements = new ArrayList<class_3784>(((StructurePoolAccessor)gluttonyPool).repurposedstructures_getElements());
        ArrayList<Pair<class_3784, Integer>> elementCounts = new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)gluttonyPool).repurposedstructures_getElementCounts());
        elements.addAll(((StructurePoolAccessor)feedingPool).repurposedstructures_getElements());
        elementCounts.addAll(((StructurePoolAccessor)feedingPool).repurposedstructures_getElementCounts());
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures_setElements(elements);
        ((StructurePoolAccessor)gluttonyPool).repurposedstructures_setElementCounts(elementCounts);
    }

    private static void logBadData(class_2960 poolPath, String messageString) {
        RepurposedStructures.LOGGER.error("(POOL MERGER) Failed to parse {} additions file. Error is: {}", (Object)poolPath, (Object)messageString);
    }
}

