/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.misc;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.mixin.BuilderAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.LootContextAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.LootManagerAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_5321;

public class StructureModdedLootImporter {
    private static final Map<class_52, class_2960> REVERSED_TABLES = new HashMap<class_52, class_2960>();
    private static Set<class_2960> BLACKLISTED_LOOTTABLES;
    private static final Map<class_2960, class_2960> TABLE_IMPORTS;

    private static Map<class_2960, class_2960> createMap() {
        HashMap<class_2960, class_2960> tableMap = new HashMap<class_2960, class_2960>();
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/birch"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/crimson"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/desert"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/end"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/icy"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/jungle"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/nether"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/ocean"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/savanna"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/stone"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/dark_forest"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/swamp"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/taiga"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mineshaft/warped"), new class_2960("minecraft:chests/abandoned_mineshaft"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/bridge"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/other"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/bastions/underground/skeleton_horse_stable"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/cities/nether"), new class_2960("minecraft:chests/bastion_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/badlands"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/dark_forest"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/desert"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/end"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/jungle"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/mushroom"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/nether"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/ocean"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/snow"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/dungeon/swamp"), new class_2960("minecraft:chests/simple_dungeon"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortress/jungle_center_chest"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortress/jungle_hallway_chest"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/fortress/jungle_shrine_chest"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/igloos/grassy_chest"), new class_2960("minecraft:chests/igloo_chest"));
        tableMap.put(new class_2960("repurposed_structures", "chests/igloos/stone_chest"), new class_2960("minecraft:chests/igloo_chest"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansion/birch"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansion/desert"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansion/jungle"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansion/oak"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansion/savanna"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansion/snowy"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/mansion/taiga"), new class_2960("minecraft:chests/woodland_mansion"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/badlands_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/birch_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/crimson_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/desert_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/giant_tree_taiga_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/icy_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/jungle_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/nether_brick_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/oak_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/snowy_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/taiga_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/warped_chest"), new class_2960("minecraft:chests/pillager_outpost"));
        tableMap.put(new class_2960("repurposed_structures", "chests/outpost/end_shulker_box"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/badlands_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/nether_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/snowy_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/icy_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/jungle_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/mushroom_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/ocean_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/giant_tree_taiga_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/flower_forest_chest"), new class_2960("minecraft:chests/desert_pyramid"));
        tableMap.put(new class_2960("repurposed_structures", "chests/pyramid/end_chest"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruin/nether"), new class_2960("minecraft:chests/bastion_other"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruin/land_hot/large"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruin/land_hot/small"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruin/land_warm/large"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruin/land_warm/small"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruined_portal/large_portal_chest"), new class_2960("minecraft:chests/ruined_portal"));
        tableMap.put(new class_2960("repurposed_structures", "chests/ruined_portal/small_portal_chest"), new class_2960("minecraft:chests/ruined_portal"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/crimson/map_chest"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/crimson/supply_chest"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/crimson/treasure_chest"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/end/map_chest"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/end/supply_chest"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/end/treasure_chest"), new class_2960("minecraft:chests/end_city_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/warped/map_chest"), new class_2960("minecraft:chests/shipwreck_map"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/warped/supply_chest"), new class_2960("minecraft:chests/shipwreck_supply"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/warped/treasure_chest"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/shipwreck/nether_bricks/treasure_chest"), new class_2960("minecraft:chests/shipwreck_treasure"));
        tableMap.put(new class_2960("repurposed_structures", "chests/stronghold/nether_storage_room"), new class_2960("minecraft:chests/stronghold_crossing"));
        tableMap.put(new class_2960("repurposed_structures", "chests/stronghold/nether_hallway"), new class_2960("minecraft:chests/stronghold_corridor"));
        tableMap.put(new class_2960("repurposed_structures", "chests/stronghold/nether_library"), new class_2960("minecraft:chests/stronghold_library"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_basalt_chest"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_crimson_chest"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_soul_chest"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_warped_chest"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_warped_trapped_chest"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_wasteland_chest"), new class_2960("minecraft:chests/nether_bridge"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_basalt_dispenser"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_crimson_dispenser"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_soul_dispenser"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_warped_dispenser"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "chests/temple/nether_wasteland_dispenser"), new class_2960("minecraft:chests/jungle_temple_dispenser"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_badands_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_birch_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_dark_forest_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_giant_taiga_house"), new class_2960("minecraft:chests/village/village_taiga_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_jungle_house"), new class_2960("minecraft:chests/village/village_savanna_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_mountains_house"), new class_2960("minecraft:chests/village/village_snowy_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_oak_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_swamp_house"), new class_2960("minecraft:chests/village/village_plains_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_crimson_cartographer"), new class_2960("minecraft:chests/village/village_cartographer"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_crimson_fisher"), new class_2960("minecraft:chests/village/village_fisher"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_crimson_tanner"), new class_2960("minecraft:chests/village/village_tannery"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_crimson_weaponsmith"), new class_2960("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_crimson_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_warped_cartographer"), new class_2960("minecraft:chests/village/village_cartographer"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_warped_fisher"), new class_2960("minecraft:chests/village/village_fisher"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_warped_tanner"), new class_2960("minecraft:chests/village/village_tannery"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_warped_weaponsmith"), new class_2960("minecraft:chests/village/village_weaponsmith"));
        tableMap.put(new class_2960("repurposed_structures", "chests/village/village_warped_house"), new class_2960("minecraft:chests/village/village_desert_house"));
        return tableMap;
    }

    public static List<class_1799> checkAndGetModifiedLoot(class_47 context, class_52 currentLootTable, List<class_1799> originalLoot) {
        class_2960 lootTableID;
        if (RepurposedStructures.RSAllConfig.RSMainConfig.importModdedItems && (lootTableID = REVERSED_TABLES.computeIfAbsent(currentLootTable, lootTable -> ((LootManagerAccessor)context.method_299().method_8503().method_3857()).repurposedstructures_getTables().entrySet().stream().filter(entry -> lootTable.equals(entry.getValue())).map(Map.Entry::getKey).findFirst().orElse(null))) != null && lootTableID.method_12836().equals("repurposed_structures") && !StructureModdedLootImporter.isInBlacklist(lootTableID)) {
            return StructureModdedLootImporter.modifyLootTables(context, lootTableID, originalLoot);
        }
        return new ArrayList<class_1799>();
    }

    public static List<class_1799> modifyLootTables(class_47 context, class_2960 lootTableID, List<class_1799> originalLoot) {
        class_2960 tableToImportLoot = TABLE_IMPORTS.get(lootTableID);
        if (tableToImportLoot == null) {
            return originalLoot;
        }
        class_47 newContext = StructureModdedLootImporter.copyLootContextWithNewQueryID(context);
        List newlyGeneratedLoot = newContext.method_22556(tableToImportLoot).method_319(newContext);
        newlyGeneratedLoot.removeIf(itemStack -> {
            class_5321 itemKey = class_2378.field_11142.method_29113((Object)itemStack.method_7909()).orElse(null);
            return itemKey != null && itemKey.method_29177().method_12836().equals("minecraft");
        });
        originalLoot.addAll(newlyGeneratedLoot);
        return originalLoot;
    }

    private static class_47 copyLootContextWithNewQueryID(class_47 oldLootContext) {
        class_47.class_48 newContextBuilder = new class_47.class_48(oldLootContext.method_299()).method_311(oldLootContext.method_294()).method_303(oldLootContext.method_302());
        ((BuilderAccessor)newContextBuilder).repurposedstructures_setDrops(((LootContextAccessor)oldLootContext).repurposedstructures_getDrops());
        ((BuilderAccessor)newContextBuilder).repurposedstructures_setParameters(((LootContextAccessor)oldLootContext).repurposedstructures_getParameters());
        return newContextBuilder.method_309(class_173.field_1179);
    }

    private static boolean isInBlacklist(class_2960 lootTableID) {
        if (BLACKLISTED_LOOTTABLES == null) {
            String cleanedBlacklist = RepurposedStructures.RSAllConfig.RSMainConfig.blacklistedRSLoottablesFromImportingModdedItems.replace(" ", "");
            BLACKLISTED_LOOTTABLES = cleanedBlacklist.equals("") ? new HashSet<class_2960>() : Arrays.stream(cleanedBlacklist.split(",")).map(class_2960::new).collect(Collectors.toSet());
        }
        return BLACKLISTED_LOOTTABLES.contains(lootTableID);
    }

    static {
        TABLE_IMPORTS = StructureModdedLootImporter.createMap();
    }
}

