/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import java.util.Arrays;
import java.util.HashSet;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.minecraft.class_1959;
import net.minecraft.class_3195;
import net.minecraft.class_5321;

public class BiomeSelection {
    public static boolean hasName(BiomeSelectionContext context, String ... names) {
        return Arrays.stream(names).anyMatch(name -> context.getBiomeKey().method_29177().method_12832().contains((CharSequence)name));
    }

    public static boolean hasNamespace(BiomeSelectionContext context, String ... namespace) {
        return Arrays.stream(namespace).anyMatch(name -> context.getBiomeKey().method_29177().method_12836().contains((CharSequence)name));
    }

    @SafeVarargs
    public static boolean isBiome(BiomeSelectionContext context, class_5321<class_1959> ... keys) {
        return Arrays.stream(keys).anyMatch(key -> context.getBiomeKey().equals(key));
    }

    public static boolean haveCategories(BiomeSelectionContext context, class_1959.class_1961 ... categories) {
        HashSet<class_1959.class_1961> categorySet = new HashSet<class_1959.class_1961>(Arrays.asList(categories));
        return categorySet.contains(context.getBiome().method_8688());
    }

    public static boolean hasStructure(BiomeSelectionContext context, class_3195<?> structureFeature) {
        return context.getBiome().method_30970().method_30980(structureFeature);
    }

    public static boolean hasStructureType(BiomeSelectionContext context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().anyMatch(structure -> context.getBiome().method_30970().method_30980(structure));
    }

    public static boolean doesNotHaveStructureType(BiomeSelectionContext context, RSStructureTagMap.STRUCTURE_TAGS tag) {
        return RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag).stream().noneMatch(structure -> context.getBiome().method_30970().method_30980(structure));
    }

    public static boolean isBiomeAllowed(BiomeSelectionContext context, String structureType) {
        return RepurposedStructures.ALL_BIOME_BLACKLISTS.get(structureType).stream().noneMatch(blacklistedBiome -> blacklistedBiome.equals(context.getBiomeKey().method_29177().toString()));
    }
}

