/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.utils;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.biome.v1.BiomeModificationContext;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectionContext;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5425;

public class GeneralUtils {
    private static final Map<class_2680, Boolean> IS_FULLCUBE_MAP = new HashMap<class_2680, Boolean>();
    private static Set<class_5321<class_1937>> BLACKLISTED_WORLDS = null;

    public static <T> T getRandomEntry(List<Pair<T, Integer>> rlList, Random random) {
        int index;
        double totalWeight = 0.0;
        for (Pair<T, Integer> pair : rlList) {
            totalWeight += (double)((Integer)pair.getSecond()).intValue();
        }
        double randomWeightPicked = (double)random.nextFloat() * totalWeight;
        for (index = 0; index < rlList.size() - 1 && !((randomWeightPicked -= (double)((Integer)rlList.get(index).getSecond()).intValue()) <= 0.0); ++index) {
        }
        return (T)rlList.get(index).getFirst();
    }

    public static boolean isFullCube(class_1922 world, class_2338 pos, class_2680 state) {
        if (!IS_FULLCUBE_MAP.containsKey(state)) {
            boolean isFullCube = class_2248.method_9614((class_265)state.method_26201(world, pos));
            IS_FULLCUBE_MAP.put(state, isFullCube);
        }
        return IS_FULLCUBE_MAP.get(state);
    }

    public static class_2680 orientateChest(class_5425 blockView, class_2338 blockPos, class_2680 blockState) {
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2350 wallDirection = (class_2350)blockState.method_11654((class_2769)class_2383.field_11177);
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)blockPos).method_10098(facing);
            if (!GeneralUtils.isFullCube((class_1922)blockView, (class_2338)mutable, blockView.method_8320((class_2338)mutable))) continue;
            wallDirection = facing;
            mutable.method_10104(facing.method_10153(), 2);
            if (blockView.method_8320((class_2338)mutable).method_26207().method_15799()) continue;
            break;
        }
        return (class_2680)blockState.method_11657((class_2769)class_2383.field_11177, (Comparable)wallDirection.method_10153());
    }

    public static boolean isWorldBlacklisted(class_5425 world) {
        if (BLACKLISTED_WORLDS == null) {
            BLACKLISTED_WORLDS = Arrays.stream(RepurposedStructures.RSAllConfig.RSMainConfig.blacklistedDimensions.split(",")).map(String::trim).map(dimensionName -> class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)new class_2960(dimensionName))).collect(Collectors.toSet());
        }
        return BLACKLISTED_WORLDS.contains(world.method_8410().method_27983());
    }

    public static void addToBiome(String modificationName, Predicate<BiomeSelectionContext> selectorPredicate, Consumer<BiomeModificationContext> biomeAdditionConsumer) {
        BiomeModifications.create((class_2960)new class_2960("repurposed_structures", modificationName)).add(ModificationPhase.ADDITIONS, selectorPredicate, biomeAdditionConsumer);
    }

    public static class_1799 enchantRandomly(Random random, class_1799 itemToEnchant, float chance) {
        List list;
        if (random.nextFloat() < chance && !(list = class_2378.field_11160.method_10220().filter(class_1887::method_25950).filter(enchantmentToCheck -> enchantmentToCheck.method_8192(itemToEnchant)).collect(Collectors.toList())).isEmpty()) {
            class_1887 enchantment = (class_1887)list.get(random.nextInt(list.size()));
            int enchantmentLevel = random.nextInt(class_3532.method_15395((Random)random, (int)enchantment.method_8187(), (int)enchantment.method_8183()) + 1);
            itemToEnchant.method_7978(enchantment, enchantmentLevel);
        }
        return itemToEnchant;
    }
}

