/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.features.configs;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2246;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3037;

public class NbtDungeonConfig
implements class_3037 {
    public static final Codec<NbtDungeonConfig> CODEC = RecordCodecBuilder.create(configInstance -> configInstance.group((App)Codec.BOOL.fieldOf("replace_air").orElse((Object)false).forGetter(nbtDungeonConfig -> nbtDungeonConfig.replaceAir), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("min_air_space").forGetter(nbtFeatureConfig -> nbtFeatureConfig.minAirSpace), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("max_air_space").forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxAirSpace), (App)Codec.intRange((int)0, (int)100).fieldOf("max_num_of_chests").forGetter(nbtFeatureConfig -> nbtFeatureConfig.maxNumOfChests), (App)Codec.BOOL.fieldOf("air_requirement_is_now_water").orElse((Object)false).forGetter(nbtDungeonConfig -> nbtDungeonConfig.airRequirementIsNowWater), (App)Codec.INT.fieldOf("structure_y_offset").orElse((Object)0).forGetter(nbtFeatureConfig -> nbtFeatureConfig.structureYOffset), (App)class_2680.field_24734.fieldOf("loot_block").orElse((Object)class_2246.field_10034.method_9564()).forGetter(nbtDungeonConfig -> nbtDungeonConfig.lootBlock), (App)class_2960.field_25139.fieldOf("chest_loottable_resourcelocation").forGetter(nbtDungeonConfig -> nbtDungeonConfig.chestResourcelocation), (App)class_2960.field_25139.fieldOf("rs_spawner_resourcelocation").forGetter(nbtDungeonConfig -> nbtDungeonConfig.rsSpawnerResourcelocation), (App)class_2960.field_25139.fieldOf("processors").forGetter(nbtDungeonConfig -> nbtDungeonConfig.processor), (App)class_2960.field_25139.fieldOf("post_processors").orElse((Object)new class_2960("minecraft:empty")).forGetter(nbtDungeonConfig -> nbtDungeonConfig.postProcessor), (App)Codec.mapPair((MapCodec)class_2960.field_25139.fieldOf("resourcelocation"), (MapCodec)Codec.intRange((int)1, (int)Integer.MAX_VALUE).fieldOf("weight")).codec().listOf().fieldOf("dungeon_nbt_entries").forGetter(nbtFeatureConfig -> nbtFeatureConfig.nbtResourcelocationsAndWeights)).apply((Applicative)configInstance, NbtDungeonConfig::new)).comapFlatMap(nbtDungeonConfig -> nbtDungeonConfig.maxAirSpace <= nbtDungeonConfig.minAirSpace ? DataResult.error((String)"min_air_space has to be smaller than max_air_space") : DataResult.success((Object)nbtDungeonConfig), Function.identity());
    public final boolean replaceAir;
    public final int minAirSpace;
    public final int maxAirSpace;
    public final int maxNumOfChests;
    public final class_2960 chestResourcelocation;
    public final List<Pair<class_2960, Integer>> nbtResourcelocationsAndWeights;
    public final class_2960 rsSpawnerResourcelocation;
    public final class_2960 processor;
    public final class_2960 postProcessor;
    public final boolean airRequirementIsNowWater;
    public final int structureYOffset;
    public final class_2680 lootBlock;

    public NbtDungeonConfig(boolean replaceAir, int minAirSpace, int maxAirSpace, int maxNumOfChests, boolean airRequirementIsNowWater, int structureYOffset, class_2680 lootBlock, class_2960 chestIdentifier, class_2960 rsSpawnerIdentifier, class_2960 processor, class_2960 postProcessor, List<Pair<class_2960, Integer>> nbtIdentifiersAndWeights) {
        this.replaceAir = replaceAir;
        this.minAirSpace = minAirSpace;
        this.maxAirSpace = maxAirSpace;
        this.maxNumOfChests = maxNumOfChests;
        this.chestResourcelocation = chestIdentifier;
        this.nbtResourcelocationsAndWeights = nbtIdentifiersAndWeights;
        this.rsSpawnerResourcelocation = rsSpawnerIdentifier;
        this.processor = processor;
        this.postProcessor = postProcessor;
        this.airRequirementIsNowWater = airRequirementIsNowWater;
        this.structureYOffset = structureYOffset;
        this.lootBlock = lootBlock;
    }

    public NbtDungeonConfig(String dungeonType, class_2960 postProcessor) {
        this(dungeonType, dungeonType, postProcessor);
    }

    public NbtDungeonConfig(String dungeonType, String spawnerType, class_2960 postProcessor) {
        this(dungeonType, spawnerType, postProcessor, 13, false, 0);
    }

    public NbtDungeonConfig(String dungeonType, String spawnerType, class_2960 processor, class_2960 postProcessor) {
        this(dungeonType, spawnerType, processor, postProcessor, 13, false, 0);
    }

    public NbtDungeonConfig(String dungeonType, String spawnerType, class_2960 postProcessor, int maxAirSpace, boolean airRequirementIsNowWater, int structureYOffset) {
        this(dungeonType, spawnerType, new class_2960("repurposed_structures", "dungeons/" + dungeonType), postProcessor, maxAirSpace, airRequirementIsNowWater, structureYOffset);
    }

    public NbtDungeonConfig(String dungeonType, String spawnerType, class_2960 processor, class_2960 postProcessor, int maxAirSpace, boolean airRequirementIsNowWater, int structureYOffset) {
        this(false, 1, maxAirSpace, 2, airRequirementIsNowWater, structureYOffset, class_2246.field_10034.method_9564(), new class_2960("repurposed_structures", "chests/dungeon/" + dungeonType), new class_2960("repurposed_structures", "dungeon_" + spawnerType), processor, postProcessor, (List<Pair<class_2960, Integer>>)ImmutableList.of((Object)Pair.of((Object)new class_2960("repurposed_structures", "dungeons/" + dungeonType + "_1"), (Object)1), (Object)Pair.of((Object)new class_2960("repurposed_structures", "dungeons/" + dungeonType + "_2"), (Object)1), (Object)Pair.of((Object)new class_2960("repurposed_structures", "dungeons/" + dungeonType + "_3"), (Object)1)));
    }

    public NbtDungeonConfig(String dungeonType, class_2960 postProcessor, int maxAirSpace, class_2680 lootBlock) {
        this(false, 1, maxAirSpace, 2, false, 0, lootBlock, new class_2960("repurposed_structures", "chests/dungeon/" + dungeonType), new class_2960("repurposed_structures", "dungeon_" + dungeonType), new class_2960("repurposed_structures", "dungeons/" + dungeonType), postProcessor, (List<Pair<class_2960, Integer>>)ImmutableList.of((Object)Pair.of((Object)new class_2960("repurposed_structures", "dungeons/" + dungeonType + "_1"), (Object)1), (Object)Pair.of((Object)new class_2960("repurposed_structures", "dungeons/" + dungeonType + "_2"), (Object)1), (Object)Pair.of((Object)new class_2960("repurposed_structures", "dungeons/" + dungeonType + "_3"), (Object)1)));
    }
}

