/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.PieceLimitedJigsawManager;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.StructurePiecesBehavior;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3785;
import net.minecraft.class_3812;
import net.minecraft.class_4183;
import net.minecraft.class_5455;
import net.minecraft.class_5483;

public class AdvancedJigsawStructure
extends AbstractBaseStructure<class_3111> {
    protected final class_2960 startPool;
    protected final int structureSize;
    protected final int biomeRange;
    protected final List<class_5483.class_1964> monsterSpawns;
    protected final List<class_5483.class_1964> creatureSpawns;
    protected final Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces;
    protected final int maxY;
    protected final int minY;
    protected final boolean clipOutOfBoundsPieces;
    protected final Integer verticalRange;

    public AdvancedJigsawStructure(class_2960 poolID, int structureSize, Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, int maxY, int minY) {
        this(poolID, structureSize, 0, new ArrayList<class_5483.class_1964>(), new ArrayList<class_5483.class_1964>(), requiredPieces, maxY, minY, true, null);
    }

    public AdvancedJigsawStructure(class_2960 poolID, int structureSize, List<class_5483.class_1964> monsterSpawns, Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, int maxY, int minY) {
        this(poolID, structureSize, 0, monsterSpawns, new ArrayList<class_5483.class_1964>(), requiredPieces, maxY, minY, true, null);
    }

    public AdvancedJigsawStructure(class_2960 poolID, int structureSize, int biomeRange, List<class_5483.class_1964> monsterSpawns, Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, int maxY, int minY, boolean clipOutOfBoundsPieces, Integer verticalRange) {
        this(poolID, structureSize, biomeRange, monsterSpawns, new ArrayList<class_5483.class_1964>(), requiredPieces, maxY, minY, clipOutOfBoundsPieces, verticalRange);
    }

    public AdvancedJigsawStructure(class_2960 poolID, int structureSize, int biomeRange, List<class_5483.class_1964> monsterSpawns, List<class_5483.class_1964> creatureSpawns, Map<class_2960, StructurePiecesBehavior.RequiredPieceNeeds> requiredPieces, int maxY, int minY, boolean clipOutOfBoundsPieces, Integer verticalRange) {
        super(class_3111.field_24893);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.biomeRange = biomeRange;
        this.monsterSpawns = monsterSpawns;
        this.creatureSpawns = creatureSpawns;
        this.requiredPieces = requiredPieces;
        this.maxY = maxY;
        this.minY = minY;
        this.clipOutOfBoundsPieces = clipOutOfBoundsPieces;
        this.verticalRange = verticalRange;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    public List<class_5483.class_1964> method_13149() {
        return this.monsterSpawns;
    }

    public List<class_5483.class_1964> method_16140() {
        return this.creatureSpawns;
    }

    protected boolean shouldStartAt(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, int chunkX, int chunkZ, class_1959 biome, class_1923 chunkPos, class_3111 defaultFeatureConfig) {
        if (!(biomeSource instanceof class_1973)) {
            for (int curChunkX = chunkX - this.biomeRange; curChunkX <= chunkX + this.biomeRange; ++curChunkX) {
                for (int curChunkZ = chunkZ - this.biomeRange; curChunkZ <= chunkZ + this.biomeRange; ++curChunkZ) {
                    if (biomeSource.method_16359(curChunkX << 2, 64, curChunkZ << 2).method_30970().method_30980((class_3195)this)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((class_3195<class_3111>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class MainStart
    extends class_4183<class_3111> {
        public MainStart(class_3195<class_3111> structureIn, int chunkX, int chunkZ, class_3341 mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void init(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, int chunkX, int chunkZ, class_1959 biome, class_3111 defaultFeatureConfig) {
            int bottomClipOff;
            int topClipOff;
            class_2338.class_2339 blockpos = new class_2338.class_2339(chunkX * 16, 0, chunkZ * 16);
            if (AdvancedJigsawStructure.this.maxY - AdvancedJigsawStructure.this.minY <= 0) {
                RepurposedStructures.LOGGER.error("MinY should always be less than MaxY or else a crash will occur or no pieces will spawn. Problematic structure is:" + class_2378.field_16644.method_10221((Object)this.method_16656()));
            }
            int structureStartHeight = this.field_16715.nextInt(AdvancedJigsawStructure.this.maxY - AdvancedJigsawStructure.this.minY) + AdvancedJigsawStructure.this.minY;
            blockpos.method_10104(class_2350.field_11036, structureStartHeight);
            if (AdvancedJigsawStructure.this.verticalRange == null) {
                topClipOff = AdvancedJigsawStructure.this.clipOutOfBoundsPieces ? AdvancedJigsawStructure.this.maxY + 5 : Integer.MAX_VALUE;
                bottomClipOff = AdvancedJigsawStructure.this.clipOutOfBoundsPieces ? AdvancedJigsawStructure.this.minY - 5 : Integer.MIN_VALUE;
            } else {
                topClipOff = structureStartHeight + AdvancedJigsawStructure.this.verticalRange;
                bottomClipOff = structureStartHeight - AdvancedJigsawStructure.this.verticalRange;
            }
            PieceLimitedJigsawManager.assembleJigsawStructure(dynamicRegistryManager, new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(AdvancedJigsawStructure.this.startPool), AdvancedJigsawStructure.this.structureSize), chunkGenerator, structureManager, (class_2338)blockpos, this.field_15325, (Random)this.field_16715, false, false, AdvancedJigsawStructure.this.requiredPieces, topClipOff, bottomClipOff);
            this.method_14969();
        }
    }
}

