/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4183;
import net.minecraft.class_5314;
import net.minecraft.class_5455;
import net.minecraft.class_5483;

public class GenericJigsawStructure
extends AbstractBaseStructure<class_3111> {
    protected final class_2960 startPool;
    protected final int structureSize;
    protected final int centerOffset;
    protected final int biomeRange;
    protected final int structureBlacklistRange;
    protected final Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet;
    protected final List<class_5483.class_1964> monsterSpawns;
    protected final List<class_5483.class_1964> creatureSpawns;
    protected final int allowTerrainHeightRange;
    protected final int terrainHeightRadius;
    protected final int minHeightLimit;
    protected int fixedYSpawn = 0;
    protected boolean useHeightmap = true;

    public GenericJigsawStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet) {
        this(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, -1, 0);
    }

    public GenericJigsawStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius) {
        this(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, new ArrayList<class_5483.class_1964>(), new ArrayList<class_5483.class_1964>());
    }

    public GenericJigsawStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, List<class_5483.class_1964> monsterSpawns, List<class_5483.class_1964> creatureSpawns) {
        this(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, -1, 0, monsterSpawns, creatureSpawns);
    }

    public GenericJigsawStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, List<class_5483.class_1964> monsterSpawns, List<class_5483.class_1964> creatureSpawns) {
        this(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet, allowTerrainHeightRange, terrainHeightRadius, monsterSpawns, creatureSpawns, Integer.MIN_VALUE);
    }

    public GenericJigsawStructure(class_2960 poolID, int biomeRange, int structureSize, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, List<class_5483.class_1964> monsterSpawns, int fixedHeight) {
        this(poolID, structureSize, 0, biomeRange, structureBlacklistRange, avoidStructuresSet, -1, 0, monsterSpawns, new ArrayList<class_5483.class_1964>(), Integer.MIN_VALUE);
        this.fixedYSpawn = fixedHeight;
        this.useHeightmap = false;
    }

    public GenericJigsawStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, List<class_5483.class_1964> monsterSpawns, List<class_5483.class_1964> creatureSpawns, int minHeightLimit) {
        super(class_3111.field_24893);
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.centerOffset = centerOffset;
        this.biomeRange = biomeRange;
        this.structureBlacklistRange = structureBlacklistRange;
        this.avoidStructuresSet = avoidStructuresSet;
        this.monsterSpawns = monsterSpawns;
        this.creatureSpawns = creatureSpawns;
        this.allowTerrainHeightRange = allowTerrainHeightRange;
        this.terrainHeightRadius = terrainHeightRadius;
        this.minHeightLimit = minHeightLimit;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    public List<class_5483.class_1964> method_13149() {
        return this.monsterSpawns;
    }

    public List<class_5483.class_1964> method_16140() {
        return this.creatureSpawns;
    }

    protected boolean shouldStartAt(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, int chunkX, int chunkZ, class_1959 biome, class_1923 chunkPos, class_3111 defaultFeatureConfig) {
        int curChunkZ;
        int curChunkX;
        if (!(biomeSource instanceof class_1973)) {
            for (curChunkX = chunkX - this.biomeRange; curChunkX <= chunkX + this.biomeRange; ++curChunkX) {
                for (curChunkZ = chunkZ - this.biomeRange; curChunkZ <= chunkZ + this.biomeRange; ++curChunkZ) {
                    if (biomeSource.method_16359(curChunkX << 2, 64, curChunkZ << 2).method_30970().method_30980((class_3195)this)) continue;
                    return false;
                }
            }
        }
        for (curChunkX = chunkX - this.structureBlacklistRange; curChunkX <= chunkX + this.structureBlacklistRange; ++curChunkX) {
            for (curChunkZ = chunkZ - this.structureBlacklistRange; curChunkZ <= chunkZ + this.structureBlacklistRange; ++curChunkZ) {
                if (curChunkX == chunkX && curChunkZ == chunkZ) continue;
                for (RSStructureTagMap.STRUCTURE_TAGS tag : this.avoidStructuresSet) {
                    for (class_3195<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)tag)) {
                        class_5314 structureConfig = chunkGenerator.method_12109().method_28600(structureFeature);
                        if (structureConfig == null || structureConfig.method_28803() <= 8) continue;
                        class_1923 chunkPos2 = structureFeature.method_27218(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                        if (curChunkX != chunkPos2.field_9181 || curChunkZ != chunkPos2.field_9180) continue;
                        return false;
                    }
                }
            }
        }
        if (this.allowTerrainHeightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX2 = chunkX - this.terrainHeightRadius; curChunkX2 <= chunkX + this.terrainHeightRadius; ++curChunkX2) {
                for (int curChunkZ2 = chunkZ - this.terrainHeightRadius; curChunkZ2 <= chunkZ + this.terrainHeightRadius; ++curChunkZ2) {
                    int height = chunkGenerator.method_16397((curChunkX2 << 4) + 7, (curChunkZ2 << 4) + 7, class_2902.class_2903.field_13194);
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    if ((minTerrainHeight = Math.min(minTerrainHeight, height)) >= this.minHeightLimit) continue;
                    return false;
                }
            }
            return maxTerrainHeight - minTerrainHeight <= this.allowTerrainHeightRange;
        }
        return true;
    }

    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new MainStart((class_3195<class_3111>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class MainStart
    extends class_4183<class_3111> {
        public MainStart(class_3195<class_3111> structureIn, int chunkX, int chunkZ, class_3341 mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void init(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, int chunkX, int chunkZ, class_1959 biome, class_3111 defaultFeatureConfig) {
            class_2338 blockpos = new class_2338(chunkX * 16, GenericJigsawStructure.this.fixedYSpawn, chunkZ * 16);
            class_3778.method_30419((class_5455)dynamicRegistryManager, (class_3812)new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(GenericJigsawStructure.this.startPool), GenericJigsawStructure.this.structureSize), class_3790::new, (class_2794)chunkGenerator, (class_3485)structureManager, (class_2338)blockpos, (List)this.field_15325, (Random)this.field_16715, (boolean)GenericJigsawStructure.this.useHeightmap, (boolean)GenericJigsawStructure.this.useHeightmap);
            this.method_14969();
            ((class_3443)this.field_15325.get(0)).method_14922(0, GenericJigsawStructure.this.centerOffset, 0);
        }
    }
}

