/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.world.structures.GenericJigsawStructure;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_5455;

public class LandBasedEndStructure
extends GenericJigsawStructure {
    public LandBasedEndStructure(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet) {
        super(poolID, structureSize, centerOffset, biomeRange, structureBlacklistRange, avoidStructuresSet);
    }

    @Override
    protected boolean shouldStartAt(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, int chunkX, int chunkZ, class_1959 biome, class_1923 chunkPos, class_3111 defaultFeatureConfig) {
        return LandBasedEndStructure.getTerrainHeight(chunkX, chunkZ, chunkGenerator) >= Math.min(chunkGenerator.method_12104(), 50);
    }

    private static int getTerrainHeight(int chunkX, int chunkZ, class_2794 chunkGenerator) {
        int xPos = chunkX << 4;
        int zPos = chunkZ << 4;
        int height = chunkGenerator.method_18028(xPos, zPos, class_2902.class_2903.field_13194);
        class_2338 pos = new class_2338(xPos, chunkGenerator.method_12104(), zPos);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_10101((class_2382)pos).method_10104(direction, 16);
            height = Math.min(height, chunkGenerator.method_18028(mutable.method_10263(), mutable.method_10260(), class_2902.class_2903.field_13194));
        }
        return height;
    }

    @Override
    public class_3195.class_3774<class_3111> method_14016() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((class_3195<class_3111>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends GenericJigsawStructure.MainStart {
        public Start(class_3195<class_3111> structureIn, int chunkX, int chunkZ, class_3341 mutableBoundingBox, int referenceIn, long seedIn) {
            super(LandBasedEndStructure.this, structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        @Override
        public void init(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, int chunkX, int chunkZ, class_1959 biome, class_3111 defaultFeatureConfig) {
            super.init(dynamicRegistryManager, chunkGenerator, structureManager, chunkX, chunkZ, biome, defaultFeatureConfig);
            class_3341 box = ((class_3443)this.field_15325.get(0)).method_14935();
            class_2338 centerPos = new class_2338(box.method_22874());
            int radius = (int)Math.sqrt(box.method_14659().method_10263() * box.method_14659().method_10263() + box.method_14659().method_10260() * box.method_14659().method_10260()) / 2;
            ArrayList<Integer> landHeights = new ArrayList<Integer>();
            for (int xOffset = -radius; xOffset <= radius; xOffset += radius / 2) {
                for (int zOffset = -radius; zOffset <= radius; zOffset += radius / 2) {
                    int landHeight = chunkGenerator.method_18028(centerPos.method_10263() + xOffset, centerPos.method_10260() + zOffset, class_2902.class_2903.field_13194);
                    landHeights.add(landHeight);
                }
            }
            int avgHeight = (int)Math.max(landHeights.stream().mapToInt(val -> val).average().orElse(0.0), 50.0);
            int parentHeight = ((class_3443)this.field_15325.get((int)0)).method_14935().field_14380;
            int offsetAmount = avgHeight - parentHeight + LandBasedEndStructure.this.centerOffset;
            this.field_15325.forEach(child -> child.method_14922(0, offsetAmount, 0));
            this.method_14969();
        }
    }
}

