/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.google.common.collect.Lists;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.NetherShipwreckConfig;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2794;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_4183;
import net.minecraft.class_5314;
import net.minecraft.class_5455;
import net.minecraft.class_5483;

public class ShipwreckNetherStructure
extends AbstractBaseStructure<NetherShipwreckConfig> {
    private final class_2960 startPool;
    private final int sealevelOffset;
    private static final List<class_5483.class_1964> MONSTER_SPAWNS = Lists.newArrayList((Object[])new class_5483.class_1964[]{new class_5483.class_1964(class_1299.field_6076, 25, 1, 1)});

    public ShipwreckNetherStructure(class_2960 startPool, int sealevelOffset) {
        super(NetherShipwreckConfig.CODEC);
        this.startPool = startPool;
        this.sealevelOffset = sealevelOffset;
        RSStructures.RS_STRUCTURE_START_PIECES.add(startPool);
    }

    protected boolean shouldStartAt(class_2794 chunkGenerator, class_1966 biomeSource, long seed, class_2919 chunkRandom, int chunkX, int chunkZ, class_1959 biome, class_1923 chunkPos, NetherShipwreckConfig config) {
        class_2338 blockPos;
        if (!config.isFlying) {
            blockPos = new class_2338(chunkX << 4, chunkGenerator.method_16398() + 1, chunkZ << 4);
        } else {
            class_2919 random = new class_2919(seed + (long)(chunkX * (chunkZ * 17)));
            int height = chunkGenerator.method_16398() + random.nextInt(Math.max(chunkGenerator.method_12104() - (chunkGenerator.method_16398() + 30), 1));
            blockPos = new class_2338(chunkX << 4, height, chunkZ << 4);
        }
        int checkRadius = 16;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        for (int xOffset = -checkRadius; xOffset <= checkRadius; xOffset += 8) {
            for (int zOffset = -checkRadius; zOffset <= checkRadius; zOffset += 8) {
                class_1922 blockView = chunkGenerator.method_26261(xOffset + blockPos.method_10263(), zOffset + blockPos.method_10260());
                for (int yOffset = 0; yOffset <= 30; yOffset += 5) {
                    mutable.method_10101((class_2382)blockPos).method_10100(xOffset, yOffset, zOffset);
                    if (blockView.method_8320((class_2338)mutable).method_26215()) continue;
                    return false;
                }
            }
        }
        for (int curChunkX = chunkX - 3; curChunkX <= chunkX + 3; ++curChunkX) {
            for (int curChunkZ = chunkZ - 3; curChunkZ <= chunkZ + 3; ++curChunkZ) {
                if (curChunkX == chunkX && curChunkZ == chunkZ) continue;
                for (class_3195<?> structureFeature : RSStructureTagMap.REVERSED_TAGGED_STRUCTURES.get((Object)RSStructureTagMap.STRUCTURE_TAGS.SHIPWRECK_AVOID_NETHER_STRUCTURE)) {
                    class_5314 structureConfig = chunkGenerator.method_12109().method_28600(structureFeature);
                    if (structureConfig == null || structureConfig.method_28803() <= 8) continue;
                    class_1923 chunkPos2 = structureFeature.method_27218(structureConfig, seed, chunkRandom, curChunkX, curChunkZ);
                    if (curChunkX != chunkPos2.field_9181 || curChunkZ != chunkPos2.field_9180) continue;
                    return false;
                }
            }
        }
        return super.method_14026(chunkGenerator, biomeSource, seed, chunkRandom, chunkX, chunkZ, biome, chunkPos, (class_3037)config);
    }

    public List<class_5483.class_1964> method_13149() {
        return MONSTER_SPAWNS;
    }

    public class_3195.class_3774<NetherShipwreckConfig> method_14016() {
        return (x$0, x$1, x$2, x$3, x$4, x$5) -> new Start((class_3195<NetherShipwreckConfig>)x$0, x$1, x$2, x$3, x$4, x$5);
    }

    public class Start
    extends class_4183<NetherShipwreckConfig> {
        private final long seed;

        public Start(class_3195<NetherShipwreckConfig> structureIn, int chunkX, int chunkZ, class_3341 mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
            this.seed = seedIn;
        }

        public void init(class_5455 dynamicRegistryManager, class_2794 chunkGenerator, class_3485 structureManager, int chunkX, int chunkZ, class_1959 biome, NetherShipwreckConfig config) {
            int placementHeight = chunkGenerator.method_16398();
            if (!config.isFlying) {
                placementHeight += ShipwreckNetherStructure.this.sealevelOffset;
            } else {
                class_2919 random = new class_2919(this.seed + (long)(chunkX * (chunkZ * 17)));
                placementHeight += random.nextInt(Math.max(chunkGenerator.method_12104() - (placementHeight + 30), 1));
            }
            class_2338 blockpos = new class_2338(chunkX << 4, placementHeight, chunkZ << 4);
            class_3778.method_30419((class_5455)dynamicRegistryManager, (class_3812)new class_3812(() -> (class_3785)dynamicRegistryManager.method_30530(class_2378.field_25917).method_10223(ShipwreckNetherStructure.this.startPool), 6), class_3790::new, (class_2794)chunkGenerator, (class_3485)structureManager, (class_2338)blockpos, (List)this.field_15325, (Random)this.field_16715, (boolean)false, (boolean)false);
            this.method_14969();
        }
    }
}

