/*
 * Decompiled with CFR 0.152.
 */
package robotic_companions.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import robotic_companions.RoboticCompanionsModElements;
import robotic_companions.gui.BunnyBotInventoryGui;
import robotic_companions.procedures.RABBOTEntityDiesProcedure;
import robotic_companions.procedures.RABBOTPlayerCollidesWithThisEntityProcedure;

@RoboticCompanionsModElements.ModElement.Tag
public class RABBOTEntity
extends RoboticCompanionsModElements.ModElement {
    public static EntityType entity = null;

    public RABBOTEntity(RoboticCompanionsModElements instance) {
        super(instance, 1);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(0.5f, 1.2f).func_206830_a("rabbot").setRegistryName("rabbot");
        this.elements.entities.add(() -> entity);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void registerModels(ModelRegistryEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new ModelBunnyBot(), 0.5f){
            {
                this.func_177094_a(new GlowingLayer(this));
            }

            public ResourceLocation func_110775_a(Entity entity) {
                return new ResourceLocation("robotic_companions:textures/bunnybot_good.png");
            }
        });
    }

    public static class ModelBunnyBot
    extends EntityModel<Entity> {
        private final ModelRenderer Head;
        private final ModelRenderer RightArm;
        private final ModelRenderer LeftArm;
        private final ModelRenderer Body;
        private final ModelRenderer RightLeg;
        private final ModelRenderer LeftLeg;

        public ModelBunnyBot() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.Head = new ModelRenderer((Model)this);
            this.Head.func_78793_a(0.0f, 10.6667f, 0.0f);
            this.Head.func_78784_a(0, 0).func_228303_a_(-3.0f, -6.1667f, -3.0f, 6.0f, 6.0f, 6.0f, 0.0f, false);
            this.Head.func_78784_a(16, 26).func_228303_a_(0.5f, -10.1667f, -0.5f, 2.0f, 5.0f, 1.0f, 0.0f, false);
            this.Head.func_78784_a(0, 34).func_228303_a_(-2.5f, -9.6667f, -0.5f, 2.0f, 5.0f, 1.0f, 0.0f, false);
            this.Head.func_78784_a(6, 34).func_228303_a_(-0.5f, -2.5f, -3.5f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.RightArm = new ModelRenderer((Model)this);
            this.RightArm.func_78793_a(-2.5f, 12.3333f, 0.0f);
            this.RightArm.func_78784_a(24, 12).func_228303_a_(-3.0f, 4.6667f, -1.5f, 3.0f, 2.0f, 3.0f, 0.0f, false);
            this.RightArm.func_78784_a(12, 12).func_228303_a_(-3.0f, -1.3333f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f, false);
            this.RightArm.func_78784_a(20, 18).func_228303_a_(-2.5f, 0.1667f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
            this.LeftArm = new ModelRenderer((Model)this);
            this.LeftArm.func_78793_a(2.5f, 12.3333f, 0.0f);
            this.LeftArm.func_78784_a(0, 18).func_228303_a_(0.0f, 4.6667f, -1.5f, 3.0f, 2.0f, 3.0f, 0.0f, false);
            this.LeftArm.func_78784_a(0, 12).func_228303_a_(0.0f, -1.3333f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f, false);
            this.LeftArm.func_78784_a(12, 18).func_228303_a_(0.5f, 0.1667f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
            this.Body = new ModelRenderer((Model)this);
            this.Body.func_78793_a(2.5f, 19.0f, -1.5f);
            this.Body.func_78784_a(6, 36).func_228303_a_(-3.0f, -8.5f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Body.func_78784_a(24, 0).func_228303_a_(-5.0f, -7.5f, 0.0f, 5.0f, 7.0f, 3.0f, 0.0f, false);
            this.RightLeg = new ModelRenderer((Model)this);
            this.RightLeg.func_78793_a(-1.5f, 18.5f, 0.0f);
            this.RightLeg.func_78784_a(8, 26).func_228303_a_(-1.0f, -0.5f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
            this.LeftLeg = new ModelRenderer((Model)this);
            this.LeftLeg.func_78793_a(1.5f, 18.5f, 0.0f);
            this.LeftLeg.func_78784_a(0, 26).func_228303_a_(-1.0f, -0.5f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.Head.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.RightArm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.LeftArm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.Body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.RightLeg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.LeftLeg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.Head.field_78796_g = f3 / 57.295776f;
            this.Head.field_78795_f = f4 / 57.295776f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends EntityModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("robotic_companions:textures/bunnybot_good_glow.png")));
            this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class CustomEntity
    extends TameableEntity {
        private final ItemStackHandler inventory = new ItemStackHandler(78){

            public int getSlotLimit(int slot) {
                return 64;
            }
        };
        private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 6;
            this.func_94061_f(false);
            this.func_110163_bv();
            this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Items.field_151028_Y, 1));
            this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)Items.field_151030_Z, 1));
            this.func_184201_a(EquipmentSlotType.LEGS, new ItemStack((IItemProvider)Items.field_151165_aa, 1));
            this.func_184201_a(EquipmentSlotType.FEET, new ItemStack((IItemProvider)Items.field_151167_ab, 1));
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70714_bg.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
            this.field_70714_bg.func_75776_a(2, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.1, false));
            this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.5, 6.0f, 2.0f, false));
            this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{((Object)((Object)this)).getClass()}));
            this.field_70714_bg.func_75776_a(5, (Goal)new SwimGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(8, (Goal)new AvoidEntityGoal((CreatureEntity)this, EndermanEntity.class, 4.0f, 1.0, 1.2));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        public boolean func_213397_c(double distanceToClosestPlayer) {
            return false;
        }

        public double func_70042_X() {
            return super.func_70042_X() + 0.4;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)Items.field_179556_br, 1));
        }

        public void func_180429_a(BlockPos pos, BlockState blockIn) {
            this.func_184185_a((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("block.anvil.step")), 0.15f, 1.0f);
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof ArrowEntity) {
                return false;
            }
            if (source.func_76364_f() instanceof PlayerEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70645_a(DamageSource source) {
            super.func_70645_a(source);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Entity sourceentity = source.func_76346_g();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            RABBOTEntityDiesProcedure.executeProcedure($_dependencies);
        }

        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
            if (this.func_70089_S() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side == null) {
                return LazyOptional.of(() -> this.combined).cast();
            }
            return super.getCapability(capability, side);
        }

        protected void func_213337_cE() {
            super.func_213337_cE();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack itemstack = this.inventory.getStackInSlot(i);
                if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
                this.func_199701_a_(itemstack);
            }
        }

        public void func_213281_b(CompoundNBT compound) {
            super.func_213281_b(compound);
            compound.func_218657_a("InventoryCustom", (INBT)this.inventory.serializeNBT());
        }

        public void func_70037_a(CompoundNBT compound) {
            super.func_70037_a(compound);
            INBT inventoryCustom = compound.func_74781_a("InventoryCustom");
            if (inventoryCustom instanceof CompoundNBT) {
                this.inventory.deserializeNBT((CompoundNBT)inventoryCustom);
            }
        }

        public boolean func_184645_a(final PlayerEntity sourceentity, Hand hand) {
            ItemStack itemstack = sourceentity.func_184586_b(hand);
            boolean retval = true;
            if (sourceentity.func_226563_dT_()) {
                if (sourceentity instanceof ServerPlayerEntity) {
                    NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)sourceentity), (INamedContainerProvider)new INamedContainerProvider(){

                        public ITextComponent func_145748_c_() {
                            return new StringTextComponent("Bunny Bot");
                        }

                        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                            PacketBuffer packetBuffer = new PacketBuffer(Unpooled.buffer());
                            packetBuffer.func_179255_a(new BlockPos((Entity)sourceentity));
                            packetBuffer.writeByte(0);
                            packetBuffer.func_150787_b(this.func_145782_y());
                            return new BunnyBotInventoryGui.GuiContainerMod(id, inventory, packetBuffer);
                        }
                    }, buf -> {
                        buf.func_179255_a(new BlockPos((Entity)sourceentity));
                        buf.writeByte(0);
                        buf.func_150787_b(this.func_145782_y());
                    });
                }
                return true;
            }
            Item item = itemstack.func_77973_b();
            if (itemstack.func_77973_b() instanceof SpawnEggItem) {
                retval = super.func_184645_a(sourceentity, hand);
            } else if (this.field_70170_p.field_72995_K) {
                retval = this.func_70909_n() && this.func_152114_e((LivingEntity)sourceentity) || this.func_70877_b(itemstack);
            } else if (this.func_70909_n()) {
                if (this.func_152114_e((LivingEntity)sourceentity)) {
                    if (item.func_219971_r() && this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                        this.func_175505_a(sourceentity, itemstack);
                        this.func_70691_i(item.func_219967_s().func_221466_a());
                        retval = true;
                    } else if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                        this.func_175505_a(sourceentity, itemstack);
                        this.func_70691_i(4.0f);
                        retval = true;
                    } else {
                        retval = super.func_184645_a(sourceentity, hand);
                    }
                }
            } else if (this.func_70877_b(itemstack)) {
                this.func_175505_a(sourceentity, itemstack);
                if (this.field_70146_Z.nextInt(3) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)sourceentity)) {
                    this.func_193101_c(sourceentity);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
                this.func_110163_bv();
                retval = true;
            } else {
                retval = super.func_184645_a(sourceentity, hand);
                if (retval) {
                    this.func_110163_bv();
                }
            }
            sourceentity.func_184220_m((Entity)this);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            CustomEntity entity = this;
            return retval;
        }

        public void func_70100_b_(PlayerEntity sourceentity) {
            super.func_70100_b_(sourceentity);
            CustomEntity entity = this;
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("entity", (Object)entity);
            $_dependencies.put("sourceentity", sourceentity);
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            RABBOTPlayerCollidesWithThisEntityProcedure.executeProcedure($_dependencies);
        }

        protected void func_110147_ax() {
            super.func_110147_ax();
            if (this.func_110148_a(SharedMonsterAttributes.field_111263_d) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111267_a) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(450.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_188791_g) != null) {
                this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(7.0);
            }
            if (this.func_110148_a(SharedMonsterAttributes.field_111264_e) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
            if (this.func_110148_a(SharedMonsterAttributes.field_111266_c) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111266_c);
            }
            this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.1);
            if (this.func_110148_a(SharedMonsterAttributes.field_221120_g) == null) {
                this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_221120_g);
            }
            this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(0.1);
        }

        public AgeableEntity func_90011_a(AgeableEntity ageable) {
            CustomEntity retval = (CustomEntity)entity.func_200721_a(this.field_70170_p);
            retval.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)retval)), SpawnReason.BREEDING, null, null);
            return retval;
        }

        public boolean func_70877_b(ItemStack stack) {
            if (stack == null) {
                return false;
            }
            return false;
        }

        public void func_213352_e(Vec3d dir) {
            Entity entity;
            Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (this.func_184207_aI()) {
                double d0;
                this.field_70126_B = this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70747_aH = this.func_70689_ay() * 0.15f;
                this.field_70761_aq = entity.field_70177_z;
                this.field_70759_as = entity.field_70177_z;
                this.field_70138_W = 1.0f;
                if (entity instanceof LivingEntity) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    float forward = ((LivingEntity)entity).field_191988_bg;
                    float strafe = ((LivingEntity)entity).field_70702_br;
                    super.func_213352_e(new Vec3d((double)strafe, 0.0, (double)forward));
                }
                this.field_184618_aE = this.field_70721_aZ;
                double d1 = this.func_226277_ct_() - this.field_70169_q;
                float f1 = MathHelper.func_76133_a((double)(d1 * d1 + (d0 = this.func_226281_cx_() - this.field_70166_s) * d0)) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
                return;
            }
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_213352_e(dir);
        }
    }
}

