/*
 * Decompiled with CFR 0.152.
 */
package robotic_companions.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.DungeonHooks;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import robotic_companions.RoboticCompanionsModElements;
import robotic_companions.particle.ZapParticle;
import robotic_companions.procedures.BadRABBOTEntityDiesProcedure;

@RoboticCompanionsModElements.ModElement.Tag
public class BadRABBOTEntity
extends RoboticCompanionsModElements.ModElement {
    public static EntityType entity = null;

    public BadRABBOTEntity(RoboticCompanionsModElements instance) {
        super(instance, 7);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)new ModelRegisterHandler());
    }

    @Override
    public void initElements() {
        entity = (EntityType)EntityType.Builder.func_220322_a(CustomEntity::new, (EntityClassification)EntityClassification.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CustomEntity::new).func_220320_c().func_220321_a(0.5f, 1.2f).func_206830_a("bad_rabbot").setRegistryName("bad_rabbot");
        this.elements.entities.add(() -> entity);
        this.elements.items.add(() -> (Item)new SpawnEggItem(entity, -14212836, -65536, new Item.Properties().func_200916_a(ItemGroup.field_78026_f)).setRegistryName("bad_rabbot_spawn_egg"));
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(this::setupAttributes);
        DungeonHooks.addDungeonMob((EntityType)entity, (int)180);
    }

    private void setupAttributes() {
        AttributeModifierMap.MutableAttribute ammma = MobEntity.func_233666_p_();
        ammma = ammma.func_233815_a_(Attributes.field_233821_d_, 0.3);
        ammma = ammma.func_233815_a_(Attributes.field_233818_a_, 55.0);
        ammma = ammma.func_233815_a_(Attributes.field_233826_i_, 6.0);
        ammma = ammma.func_233815_a_(Attributes.field_233823_f_, 5.0);
        ammma = ammma.func_233815_a_(Attributes.field_233824_g_, 0.1);
        GlobalEntityTypeAttributes.put((EntityType)entity, (AttributeModifierMap)ammma.func_233813_a_());
    }

    public static class ModelBunnyBot
    extends EntityModel<Entity> {
        private final ModelRenderer Head;
        private final ModelRenderer RightArm;
        private final ModelRenderer LeftArm;
        private final ModelRenderer Body;
        private final ModelRenderer RightLeg;
        private final ModelRenderer LeftLeg;

        public ModelBunnyBot() {
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.Head = new ModelRenderer((Model)this);
            this.Head.func_78793_a(0.0f, 10.6667f, 0.0f);
            this.Head.func_78784_a(0, 0).func_228303_a_(-3.0f, -6.1667f, -3.0f, 6.0f, 6.0f, 6.0f, 0.0f, false);
            this.Head.func_78784_a(16, 26).func_228303_a_(0.5f, -10.1667f, -0.5f, 2.0f, 5.0f, 1.0f, 0.0f, false);
            this.Head.func_78784_a(0, 34).func_228303_a_(-2.5f, -9.6667f, -0.5f, 2.0f, 5.0f, 1.0f, 0.0f, false);
            this.Head.func_78784_a(6, 34).func_228303_a_(-0.5f, -2.5f, -3.5f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.RightArm = new ModelRenderer((Model)this);
            this.RightArm.func_78793_a(-2.5f, 12.3333f, 0.0f);
            this.RightArm.func_78784_a(24, 12).func_228303_a_(-3.0f, 4.6667f, -1.5f, 3.0f, 2.0f, 3.0f, 0.0f, false);
            this.RightArm.func_78784_a(12, 12).func_228303_a_(-3.0f, -1.3333f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f, false);
            this.RightArm.func_78784_a(20, 18).func_228303_a_(-2.5f, 0.1667f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
            this.LeftArm = new ModelRenderer((Model)this);
            this.LeftArm.func_78793_a(2.5f, 12.3333f, 0.0f);
            this.LeftArm.func_78784_a(0, 18).func_228303_a_(0.0f, 4.6667f, -1.5f, 3.0f, 2.0f, 3.0f, 0.0f, false);
            this.LeftArm.func_78784_a(0, 12).func_228303_a_(0.0f, -1.3333f, -1.5f, 3.0f, 3.0f, 3.0f, 0.0f, false);
            this.LeftArm.func_78784_a(12, 18).func_228303_a_(0.5f, 0.1667f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
            this.Body = new ModelRenderer((Model)this);
            this.Body.func_78793_a(2.5f, 19.0f, -1.5f);
            this.Body.func_78784_a(6, 36).func_228303_a_(-3.0f, -8.5f, 1.0f, 1.0f, 1.0f, 1.0f, 0.0f, false);
            this.Body.func_78784_a(24, 0).func_228303_a_(-5.0f, -7.5f, 0.0f, 5.0f, 7.0f, 3.0f, 0.0f, false);
            this.RightLeg = new ModelRenderer((Model)this);
            this.RightLeg.func_78793_a(-1.5f, 18.5f, 0.0f);
            this.RightLeg.func_78784_a(8, 26).func_228303_a_(-1.0f, -0.5f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
            this.LeftLeg = new ModelRenderer((Model)this);
            this.LeftLeg.func_78793_a(1.5f, 18.5f, 0.0f);
            this.LeftLeg.func_78784_a(0, 26).func_228303_a_(-1.0f, -0.5f, -1.0f, 2.0f, 6.0f, 2.0f, 0.0f, false);
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
            this.Head.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.RightArm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.LeftArm.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.Body.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.RightLeg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
            this.LeftLeg.func_228308_a_(matrixStack, buffer, packedLight, packedOverlay);
        }

        public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
            modelRenderer.field_78795_f = x;
            modelRenderer.field_78796_g = y;
            modelRenderer.field_78808_h = z;
        }

        public void func_225597_a_(Entity e, float f, float f1, float f2, float f3, float f4) {
            this.RightArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f + (float)Math.PI)) * f1;
            this.LeftLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * -1.0f * f1;
            this.Head.field_78796_g = f3 / 57.295776f;
            this.Head.field_78795_f = f4 / 57.295776f;
            this.LeftArm.field_78795_f = MathHelper.func_76134_b((float)(f * 0.6662f)) * f1;
            this.RightLeg.field_78795_f = MathHelper.func_76134_b((float)(f * 1.0f)) * 1.0f * f1;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GlowingLayer<T extends Entity, M extends EntityModel<T>>
    extends LayerRenderer<T, M> {
        public GlowingLayer(IEntityRenderer<T, M> er) {
            super(er);
        }

        public void func_225628_a_(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228652_i_((ResourceLocation)new ResourceLocation("robotic_companions:textures/bunnybot_bad_glow.png")));
            this.func_215332_c().func_225598_a_(matrixStackIn, ivertexbuilder, 0xF00000, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class CustomEntity
    extends MonsterEntity {
        public CustomEntity(FMLPlayMessages.SpawnEntity packet, World world) {
            this((EntityType<CustomEntity>)entity, world);
        }

        public CustomEntity(EntityType<CustomEntity> type, World world) {
            super(type, world);
            this.field_70728_aV = 0;
            this.func_94061_f(false);
        }

        public IPacket<?> func_213297_N() {
            return NetworkHooks.getEntitySpawningPacket((Entity)this);
        }

        protected void func_184651_r() {
            super.func_184651_r();
            this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false, false));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, ServerPlayerEntity.class, false, false));
            this.field_70714_bg.func_75776_a(3, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.2, false));
            this.field_70714_bg.func_75776_a(4, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
            this.field_70715_bh.func_75776_a(5, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
            this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(7, (Goal)new SwimGoal((MobEntity)this));
        }

        public CreatureAttribute func_70668_bt() {
            return CreatureAttribute.field_223222_a_;
        }

        protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
            super.func_213333_a(source, looting, recentlyHitIn);
            this.func_199701_a_(new ItemStack((IItemProvider)Items.field_151137_ax, 1));
        }

        public SoundEvent func_184601_bQ(DamageSource ds) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
        }

        public SoundEvent func_184615_bR() {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
        }

        public boolean func_70097_a(DamageSource source, float amount) {
            if (source.func_76364_f() instanceof ArrowEntity) {
                return false;
            }
            if (source == DamageSource.field_76379_h) {
                return false;
            }
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source == DamageSource.field_76369_e) {
                return false;
            }
            if (source == DamageSource.field_180137_b) {
                return false;
            }
            return super.func_70097_a(source, amount);
        }

        public void func_70645_a(DamageSource source) {
            super.func_70645_a(source);
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Entity sourceentity = source.func_76346_g();
            CustomEntity entity = this;
            HashMap<String, Object> $_dependencies = new HashMap<String, Object>();
            $_dependencies.put("x", x);
            $_dependencies.put("y", y);
            $_dependencies.put("z", z);
            $_dependencies.put("world", this.field_70170_p);
            BadRABBOTEntityDiesProcedure.executeProcedure($_dependencies);
        }

        public void func_70636_d() {
            super.func_70636_d();
            double x = this.func_226277_ct_();
            double y = this.func_226278_cu_();
            double z = this.func_226281_cx_();
            Random random = this.field_70146_Z;
            CustomEntity entity = this;
            for (int l = 0; l < 4; ++l) {
                double d0 = x + (double)random.nextFloat();
                double d1 = y + (double)random.nextFloat();
                double d2 = z + (double)random.nextFloat();
                int i1 = random.nextInt(2) * 2 - 1;
                double d3 = ((double)random.nextFloat() - 0.5) * 0.0999999985098839;
                double d4 = ((double)random.nextFloat() - 0.5) * 0.0999999985098839;
                double d5 = ((double)random.nextFloat() - 0.5) * 0.0999999985098839;
                this.field_70170_p.func_195594_a((IParticleData)ZapParticle.particle, d0, d1, d2, d3, d4, d5);
            }
        }
    }

    private static class ModelRegisterHandler {
        private ModelRegisterHandler() {
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void registerModels(ModelRegistryEvent event) {
            RenderingRegistry.registerEntityRenderingHandler((EntityType)entity, renderManager -> new MobRenderer(renderManager, new ModelBunnyBot(), 0.5f){
                {
                    super(x0, x1, x2);
                    this.func_177094_a(new GlowingLayer(this));
                }

                public ResourceLocation func_110775_a(Entity entity) {
                    return new ResourceLocation("robotic_companions:textures/bunnybot_bad.png");
                }
            });
        }
    }
}

